/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.network.ImmPtlNetworkConfig;
import qouteall.imm_ptl.core.platform_specific.RequiemCompat;
import qouteall.imm_ptl.core.platform_specific.RequiemCompatClient;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;

public class O_O {
    public static boolean isDimensionalThreadingPresent = false;
    private static final BlockState obsidianState = Blocks.OBSIDIAN.defaultBlockState();

    public static boolean isForge() {
        return false;
    }

    public static void onPlayerChangeDimensionClient(ResourceKey<Level> from, ResourceKey<Level> to) {
        RequiemCompatClient.onPlayerTeleportedClient();
    }

    public static void onPlayerTravelOnServer(ServerPlayer player, ServerLevel fromWorld, ServerLevel toWorld) {
        RequiemCompat.onPlayerTeleportedServer(player);
    }

    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static boolean isObsidian(BlockState blockState) {
        return blockState == obsidianState;
    }

    public static void postClientChunkLoadEvent(LevelChunk chunk) {
        NeoForge.EVENT_BUS.post((Event)new ChunkEvent.Load((ChunkAccess)chunk, true));
    }

    public static void postClientChunkUnloadEvent(LevelChunk chunk) {
        NeoForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((ChunkAccess)chunk));
    }

    public static boolean isDedicatedServer() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    public static void postPortalSpawnEventForge(PortalGenInfo info) {
    }

    public static boolean getIsPehkuiPresent() {
        return ModList.get().isLoaded("pehkui");
    }

    @Nullable
    public static String getImmPtlModInfoUrl() {
        String gameVersion = SharedConstants.getCurrentVersion().getName();
        if (O_O.isForge()) {
            return "https://qouteall.fun/immptl_info/forge-%s.json".formatted(gameVersion);
        }
        return "https://qouteall.fun/immptl_info/%s.json".formatted(gameVersion);
    }

    public static boolean isModLoadedWithinVersion(String modId, @Nullable String startVersion, @Nullable String endVersion) {
        Optional modContainer = ModList.get().getModContainerById(modId);
        if (modContainer.isPresent()) {
            ArtifactVersion version = ((ModContainer)modContainer.get()).getModInfo().getVersion();
            try {
                int i;
                if (startVersion != null && (i = new DefaultArtifactVersion(startVersion).compareTo(version)) > 0) {
                    return false;
                }
                if (endVersion != null && (i = new DefaultArtifactVersion(endVersion).compareTo(version)) < 0) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static ImmPtlNetworkConfig.ModVersion getImmPtlVersion() {
        return new ImmPtlNetworkConfig.ModVersion(1, 0, 0);
    }

    public static String getImmPtlVersionStr() {
        return "";
    }

    public static boolean shouldUpdateImmPtl(String latestReleaseVersion) {
        return false;
    }

    public static String getModDownloadLink() {
        return "https://modrinth.com/mod/immersiveportals";
    }

    public static String getIssueLink() {
        return "https://github.com/iPortalTeam/ImmersivePortalsMod/discussions";
    }

    @Nullable
    public static ResourceLocation getModIconLocation(String modid) {
        return null;
    }

    @Nullable
    public static String getModName(String modid) {
        return ((IModInfo)FMLLoader.getLoadingModList().getModFileById(modid).getMods().stream().findFirst().get()).getDisplayName();
    }

    public static boolean isQuilt() {
        return false;
    }

    public static List<String> getLoadedModIds() {
        return ModList.get().getSortedMods().stream().map(ModContainer::getModId).sorted().toList();
    }

    public static boolean allowTeleportingEntity(Entity entity, Portal portal) {
        return true;
    }

    public static boolean isDevEnv() {
        return !FMLEnvironment.production;
    }
}

