/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import java.util.Arrays;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.IPModMainClient;
import qouteall.imm_ptl.core.compat.IPModInfoChecking;
import qouteall.imm_ptl.core.compat.iris_compatibility.ExperimentalIrisPortalRenderer;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.BreakableMirror;
import qouteall.imm_ptl.core.portal.EndPortalEntity;
import qouteall.imm_ptl.core.portal.LoadingIndicatorEntity;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalTrackedPortal;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.imm_ptl.core.portal.global_portals.WorldWrappingPortal;
import qouteall.imm_ptl.core.portal.nether_portal.GeneralBreakablePortal;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalEntity;
import qouteall.imm_ptl.core.render.LoadingIndicatorRenderer;
import qouteall.imm_ptl.core.render.PortalEntityRenderer;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.MyTaskList;

public class IPModEntryClient {
    public static void initPortalRenderers(EntityRenderersEvent.RegisterRenderers event) {
        Arrays.stream(new EntityType[]{Portal.ENTITY_TYPE, NetherPortalEntity.ENTITY_TYPE, EndPortalEntity.ENTITY_TYPE, Mirror.ENTITY_TYPE, BreakableMirror.ENTITY_TYPE, GlobalTrackedPortal.ENTITY_TYPE, WorldWrappingPortal.ENTITY_TYPE, VerticalConnectingPortal.ENTITY_TYPE, GeneralBreakablePortal.ENTITY_TYPE}).forEach(entityType -> event.registerEntityRenderer(entityType, PortalEntityRenderer::new));
        event.registerEntityRenderer(LoadingIndicatorEntity.entityType, LoadingIndicatorRenderer::new);
    }

    public void onInitializeClient(IEventBus modEventBus) {
        boolean isSodiumPresent;
        IPModMainClient.init();
        modEventBus.addListener(EntityRenderersEvent.RegisterRenderers.class, IPModEntryClient::initPortalRenderers);
        boolean bl = isSodiumPresent = ModList.get().isLoaded("embeddium") || ModList.get().isLoaded("sodium");
        if (isSodiumPresent) {
            Helper.log("Sodium is present");
            SodiumInterface.invoker = new SodiumInterface.OnSodiumPresent();
        } else {
            Helper.log("Sodium is not present");
        }
        if (ModList.get().isLoaded("iris")) {
            Helper.log("Iris is present");
            IrisInterface.invoker = new IrisInterface.OnIrisPresent();
            ExperimentalIrisPortalRenderer.init();
            IPGlobal.CLIENT_TASK_LIST.addTask(MyTaskList.oneShotTask(() -> {
                if (IPConfig.getConfig().shouldDisplayWarning("iris")) {
                    CHelper.printChat((Component)Component.translatable((String)"imm_ptl.iris_warning").append(IPMcHelper.getDisableWarningText("iris")));
                }
            }));
        } else {
            Helper.log("Iris is not present");
        }
        IPModInfoChecking.initClient();
    }
}

