/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import com.google.gson.JsonObject;
import java.util.HashSet;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.peripheral.platform_specific.IPFeatureControl;
import qouteall.q_misc_util.Helper;

@Config(name="immersive_portals")
public class IPConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public String check_the_wiki_for_more_information = "https://qouteall.fun/immptl/wiki/Config-Options";
    @ConfigEntry.Category(value="client")
    @ConfigEntry.BoundedDiscrete(min=0L, max=10L)
    @ConfigEntry.Gui.Tooltip
    public int maxPortalLayer = 5;
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.Tooltip
    public boolean lagAttackProof = true;
    @ConfigEntry.Category(value="client")
    public boolean enableCrossPortalSound = true;
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.Tooltip
    public boolean pureMirror = false;
    @ConfigEntry.Category(value="client")
    public boolean renderYourselfInPortal = true;
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.Tooltip
    public boolean correctCrossPortalEntityRendering = true;
    @ConfigEntry.Category(value="client")
    public boolean reducedPortalRendering = false;
    @ConfigEntry.Category(value="client")
    public boolean netherPortalOverlay = false;
    @ConfigEntry.Category(value="client")
    public boolean enableNetherPortalEffect = true;
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.Tooltip
    public boolean enableClientPerformanceAdjustment = true;
    @ConfigEntry.Category(value="client")
    public boolean clientTolerantVersionMismatchWithServer = false;
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.Tooltip
    public boolean compatibilityRenderMode = false;
    @ConfigEntry.Gui.Excluded
    public boolean checkModInfoFromInternet = true;
    @ConfigEntry.Gui.Excluded
    public boolean enableUpdateNotification = true;
    @ConfigEntry.Gui.Excluded
    public boolean sharedBlockMeshBufferOptimization = true;
    @ConfigEntry.Gui.Excluded
    public boolean enableClippingMechanism = true;
    @ConfigEntry.Gui.Excluded
    public boolean visibilityPrediction = true;
    @ConfigEntry.Gui.Excluded
    public boolean useDepthClampForPortalRendering = true;
    @ConfigEntry.Gui.Excluded
    public boolean enableCrossPortalView = true;
    @ConfigEntry.Gui.Excluded
    public int portalRenderLimit = 200;
    @ConfigEntry.Gui.Excluded
    public boolean doCheckGlError = false;
    @ConfigEntry.Gui.Excluded
    public boolean shaderpackWarning = true;
    @ConfigEntry.Gui.Excluded
    public int portalWandCursorAlignment = 2;
    @ConfigEntry.Gui.Excluded
    public boolean saveMemoryInBufferPack = false;
    @ConfigEntry.Gui.Excluded
    public boolean initialScreenShown = false;
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public IPGlobal.NetherPortalMode netherPortalMode = IPFeatureControl.enableVanillaBehaviorChangingByDefault() ? IPGlobal.NetherPortalMode.adaptive : IPGlobal.NetherPortalMode.vanilla;
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public IPGlobal.EndPortalMode endPortalMode = IPFeatureControl.enableVanillaBehaviorChangingByDefault() ? IPGlobal.EndPortalMode.normal : IPGlobal.EndPortalMode.vanilla;
    public boolean enableMirrorCreation = IPFeatureControl.enableVanillaBehaviorChangingByDefault();
    public boolean enableWarning = true;
    public boolean lightVanillaNetherPortalWhenCrouching = true;
    @ConfigEntry.Gui.Tooltip
    public boolean enableServerPerformanceAdjustment = true;
    public boolean enableDatapackPortalGen = true;
    @ConfigEntry.BoundedDiscrete(min=1L, max=32L)
    @ConfigEntry.Gui.Tooltip
    public int indirectLoadingRadiusCap = 8;
    @ConfigEntry.BoundedDiscrete(min=3L, max=64L)
    public int regularPortalLengthLimit = 64;
    @ConfigEntry.BoundedDiscrete(min=4L, max=128L)
    public int scaleLimit = 30;
    @ConfigEntry.Gui.Tooltip
    public boolean easeCreativePermission = true;
    @ConfigEntry.Gui.Tooltip
    public boolean easeCommandStickPermission = false;
    public boolean portalsChangeGravityByDefault = false;
    public boolean portalWandUsableOnSurvivalMode = false;
    @ConfigEntry.Gui.Excluded
    public int portalSearchingRange = 128;
    @ConfigEntry.Gui.Excluded
    public boolean serverSideNormalChunkLoading = true;
    @ConfigEntry.Gui.Excluded
    public boolean teleportationDebug = false;
    @ConfigEntry.Gui.Excluded
    public boolean looseMovementCheck = false;
    @ConfigEntry.Gui.Excluded
    public boolean chunkPacketDebug = false;
    @ConfigEntry.Gui.Excluded
    public boolean enableImmPtlChunkLoading = true;
    @ConfigEntry.Gui.Excluded
    public boolean serverTolerantVersionMismatchWithClient = false;
    @ConfigEntry.Gui.Excluded
    public boolean serverRejectClientWithoutImmPtl = true;
    @ConfigEntry.Gui.Excluded
    public boolean serverTeleportLogging = false;
    @ConfigEntry.Gui.Excluded
    public boolean enableCrossPortalInteraction = true;
    @ConfigEntry.Gui.Excluded
    public HashSet<String> disabledWarnings = new HashSet();
    @ConfigEntry.Gui.Excluded
    @Nullable
    public JsonObject dimStackPreset = null;

    public static IPConfig getConfig() {
        return (IPConfig)IPGlobal.configHolder.getConfig();
    }

    public void saveConfigFile() {
        IPGlobal.configHolder.setConfig((ConfigData)this);
        IPGlobal.configHolder.save();
    }

    public void onConfigChanged() {
        this.indirectLoadingRadiusCap = Mth.clamp((int)this.indirectLoadingRadiusCap, (int)1, (int)32);
        this.regularPortalLengthLimit = Mth.clamp((int)this.regularPortalLengthLimit, (int)3, (int)64);
        this.scaleLimit = Mth.clamp((int)this.scaleLimit, (int)8, (int)128);
        if (this.netherPortalMode == null) {
            this.netherPortalMode = IPGlobal.NetherPortalMode.adaptive;
        }
        if (this.endPortalMode == null) {
            this.endPortalMode = IPGlobal.EndPortalMode.normal;
        }
        IPGlobal.renderMode = this.compatibilityRenderMode ? IPGlobal.RenderMode.compatibility : IPGlobal.RenderMode.normal;
        IPGlobal.enableWarning = this.enableWarning;
        IPGlobal.enableMirrorCreation = this.enableMirrorCreation;
        IPGlobal.doCheckGlError = this.doCheckGlError;
        IPGlobal.maxPortalLayer = this.maxPortalLayer;
        IPGlobal.lagAttackProof = this.lagAttackProof;
        IPGlobal.portalRenderLimit = this.portalRenderLimit;
        IPGlobal.netherPortalFindingRadius = this.portalSearchingRange;
        IPGlobal.renderYourselfInPortal = this.renderYourselfInPortal;
        IPGlobal.activeLoading = this.serverSideNormalChunkLoading;
        IPGlobal.teleportationDebugEnabled = this.teleportationDebug;
        IPGlobal.correctCrossPortalEntityRendering = this.correctCrossPortalEntityRendering;
        IPGlobal.looseMovementCheck = this.looseMovementCheck;
        IPGlobal.pureMirror = this.pureMirror;
        IPGlobal.indirectLoadingRadiusCap = this.indirectLoadingRadiusCap;
        IPGlobal.netherPortalMode = this.netherPortalMode;
        IPGlobal.endPortalMode = this.endPortalMode;
        IPGlobal.reducedPortalRendering = this.reducedPortalRendering;
        IPGlobal.offsetOcclusionQuery = this.visibilityPrediction;
        IPGlobal.netherPortalOverlay = this.netherPortalOverlay;
        IPGlobal.scaleLimit = this.scaleLimit;
        IPGlobal.easeCreativePermission = this.easeCreativePermission;
        IPGlobal.easeCommandStickPermission = this.easeCommandStickPermission;
        IPGlobal.enableSharedBlockMeshBuffers = this.sharedBlockMeshBufferOptimization;
        IPGlobal.enableDatapackPortalGen = this.enableDatapackPortalGen;
        IPGlobal.enableCrossPortalView = this.enableCrossPortalView;
        IPGlobal.enableClippingMechanism = this.enableClippingMechanism;
        IPGlobal.lightVanillaNetherPortalWhenCrouching = this.lightVanillaNetherPortalWhenCrouching;
        IPGlobal.enableNetherPortalEffect = this.enableNetherPortalEffect;
        IPGlobal.enableClientPerformanceAdjustment = this.enableClientPerformanceAdjustment;
        IPGlobal.enableServerPerformanceAdjustment = this.enableServerPerformanceAdjustment;
        IPGlobal.enableCrossPortalSound = this.enableCrossPortalSound;
        IPGlobal.checkModInfoFromInternet = this.checkModInfoFromInternet;
        IPGlobal.enableUpdateNotification = this.enableUpdateNotification;
        IPGlobal.enableDepthClampForPortalRendering = this.useDepthClampForPortalRendering;
        BlockPortalShape.defaultLengthLimit = this.regularPortalLengthLimit;
        IPGlobal.maxNormalPortalRadius = Math.max(this.regularPortalLengthLimit / 2, 16);
        IPGlobal.chunkPacketDebug = this.chunkPacketDebug;
        IPGlobal.saveMemoryInBufferPack = this.saveMemoryInBufferPack;
        Helper.LOGGER.info("iPortal Config Applied");
    }

    public boolean shouldDisplayWarning(String warningKey) {
        return this.enableWarning && !this.disabledWarnings.contains(warningKey);
    }
}

