/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.q_misc_util.dimension.DimensionIntId;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class PacketRedirectionClient {
    public static final Minecraft client = Minecraft.getInstance();
    private static final LimitedLogger limitedLogger = new LimitedLogger(100);
    public static final ThreadLocal<ResourceKey<Level>> clientTaskRedirection = ThreadLocal.withInitial(() -> null);

    public static boolean getIsProcessingRedirectedMessage() {
        return clientTaskRedirection.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleRedirectedPacket(int dimensionIntId, Packet<ClientGamePacketListener> packet, ClientGamePacketListener handler) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.isSameThread()) {
            ResourceKey<Level> dimension = DimensionIntId.getClientMap().fromIntegerId(dimensionIntId);
            ResourceKey<Level> oldTaskRedirection = clientTaskRedirection.get();
            clientTaskRedirection.set(dimension);
            try {
                ClientWorldLoader.withSwitchedWorldFailSoft(dimension, () -> packet.handle((PacketListener)handler));
            }
            finally {
                clientTaskRedirection.set(oldTaskRedirection);
            }
        } else {
            minecraft.execute(() -> PacketRedirectionClient.handleRedirectedPacket(dimensionIntId, packet, handler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void old_handleRedirectedPacket(ResourceKey<Level> dimension, Packet<ClientGamePacketListener> packet, ClientGamePacketListener handler) {
        ResourceKey<Level> oldTaskRedirection = clientTaskRedirection.get();
        clientTaskRedirection.set(dimension);
        try {
            if (Minecraft.getInstance().isSameThread()) {
                ClientWorldLoader.withSwitchedWorldFailSoft(dimension, () -> packet.handle((PacketListener)handler));
            } else {
                packet.handle((PacketListener)handler);
            }
        }
        finally {
            clientTaskRedirection.set(oldTaskRedirection);
        }
    }
}

