/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.network.PacketRedirectionClient;

public class PacketRedirection {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketRedirection.class);
    public static final ResourceLocation payloadId = McHelper.newResourceLocation("i:r");
    private static final ThreadLocal<ResourceKey<Level>> serverPacketRedirection = ThreadLocal.withInitial(() -> null);
    private static final ThreadLocal<ForceBundleCallback> forceBundle = ThreadLocal.withInitial(() -> null);
    private static final ProtocolInfo<ClientGamePacketListener> PLACEHOLDER_PROTOCOL_INFO = GameProtocols.CLIENTBOUND_TEMPLATE.bind(argBuf -> (RegistryFriendlyByteBuf)argBuf);

    public static void withForceRedirect(ServerLevel world, Runnable func) {
        PacketRedirection.withForceRedirectAndGet(world, () -> {
            func.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withForceRedirectAndGet(ServerLevel world, Supplier<T> func) {
        if (((IEWorld)world).portal_getThread() != Thread.currentThread()) {
            LOGGER.error("It's possible that a mod is trying to handle packet in networking thread instead of server thread. This is not thread safe and can cause rare bugs! (ImmPtl is just doing checking, it's not an issue of iPortal)", new Throwable());
        }
        ResourceKey redirectDim = world.dimension();
        ResourceKey<Level> oldRedirection = serverPacketRedirection.get();
        if (oldRedirection != redirectDim) {
            serverPacketRedirection.set((ResourceKey<Level>)redirectDim);
        }
        try {
            T t = func.get();
            return t;
        }
        finally {
            if (oldRedirection != redirectDim) {
                serverPacketRedirection.set(oldRedirection);
            }
        }
    }

    @Nullable
    public static ResourceKey<Level> getForceRedirectDimension() {
        return serverPacketRedirection.get();
    }

    public static void sendRedirectedPacket(ServerGamePacketListenerImpl serverPlayNetworkHandler, Packet<ClientGamePacketListener> packet, ResourceKey<Level> dimension) {
        if (PacketRedirection.getForceRedirectDimension() == dimension) {
            serverPlayNetworkHandler.send(packet);
        } else {
            serverPlayNetworkHandler.send(PacketRedirection.createRedirectedMessage(serverPlayNetworkHandler.player.server, dimension, packet));
        }
    }

    public static void validateForceRedirecting() {
        Validate.isTrue((PacketRedirection.getForceRedirectDimension() != null ? 1 : 0) != 0);
    }

    public static Packet<ClientGamePacketListener> createRedirectedMessage(MinecraftServer server, ResourceKey<Level> dimension, Packet<ClientGamePacketListener> packet) {
        if (PacketRedirection.isRedirectPacket(packet)) {
            return packet;
        }
        Validate.isTrue((!(packet instanceof BundleDelimiterPacket) ? 1 : 0) != 0);
        if (packet instanceof ClientboundBundlePacket) {
            ClientboundBundlePacket bundlePacket = (ClientboundBundlePacket)packet;
            ArrayList<Packet<ClientGamePacketListener>> newSubPackets = new ArrayList<Packet<ClientGamePacketListener>>();
            for (Packet subPacket : bundlePacket.subPackets()) {
                newSubPackets.add(PacketRedirection.createRedirectedMessage(server, dimension, (Packet<ClientGamePacketListener>)subPacket));
            }
            return new ClientboundBundlePacket(newSubPackets);
        }
        int intDimId = PortalAPI.serverDimKeyToInt(server, dimension);
        Payload payload = new Payload(intDimId, packet);
        return new ClientboundCustomPayloadPacket((CustomPacketPayload)payload);
    }

    public static void sendRedirectedMessage(ServerPlayer player, ResourceKey<Level> dimension, Packet<ClientGamePacketListener> packet) {
        player.connection.send(PacketRedirection.createRedirectedMessage(player.server, dimension, packet));
    }

    public static boolean isRedirectPacket(Packet<?> packet) {
        ClientboundCustomPayloadPacket customPayloadPacket;
        return packet instanceof ClientboundCustomPayloadPacket && (customPayloadPacket = (ClientboundCustomPayloadPacket)packet).payload() instanceof Payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R withForceBundle(Supplier<R> func) {
        ForceBundleCallback forceBundleCallback = PacketRedirection.getForceBundleCallback();
        if (forceBundleCallback != null) {
            return func.get();
        }
        HashMap map = new HashMap();
        forceBundle.set((listener, packet) -> {
            List packetsToBundle = map.computeIfAbsent(listener, k -> new ArrayList());
            if (packet instanceof BundlePacket) {
                BundlePacket bundlePacket = (BundlePacket)packet;
                Iterable subPackets = bundlePacket.subPackets();
                for (Packet subPacket : subPackets) {
                    packetsToBundle.add(subPacket);
                }
            } else {
                packetsToBundle.add(packet);
            }
        });
        try {
            R r = func.get();
            return r;
        }
        finally {
            forceBundle.set(null);
            for (Map.Entry e : map.entrySet()) {
                ServerCommonPacketListenerImpl listener2 = (ServerCommonPacketListenerImpl)e.getKey();
                List packets = (List)e.getValue();
                listener2.send((Packet)new ClientboundBundlePacket((Iterable)packets));
            }
        }
    }

    @Nullable
    public static ForceBundleCallback getForceBundleCallback() {
        return forceBundle.get();
    }

    public record Payload(int dimensionIntId, Packet<? extends ClientGamePacketListener> packet) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Payload> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)payloadId.toString()));
        public static final StreamCodec<RegistryFriendlyByteBuf, Payload> CODEC = StreamCodec.of((b, p) -> p.write((RegistryFriendlyByteBuf)b), Payload::read);

        public void write(RegistryFriendlyByteBuf buf) {
            Validate.notNull(this.packet, (String)"packet is null", (Object[])new Object[0]);
            buf.writeVarInt(this.dimensionIntId);
            PLACEHOLDER_PROTOCOL_INFO.codec().encode((Object)buf, this.packet);
        }

        public static Payload read(FriendlyByteBuf buf) {
            int dimensionIntId = buf.readVarInt();
            Packet packet = (Packet)PLACEHOLDER_PROTOCOL_INFO.codec().decode((Object)buf);
            return new Payload(dimensionIntId, (Packet<? extends ClientGamePacketListener>)packet);
        }

        public void handle(ClientGamePacketListener listener) {
            PacketRedirectionClient.handleRedirectedPacket(this.dimensionIntId, this.packet, listener);
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public static interface ForceBundleCallback {
        public void accept(ServerCommonPacketListenerImpl var1, Packet<ClientGamePacketListener> var2);
    }
}

