/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.network;

import de.nick1st.imm_ptl.events.ClientPortalSpawnEvent;
import java.util.Objects;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.network.ImmPtlNetworking;
import qouteall.imm_ptl.core.portal.Portal;

public abstract class ImmPtlNetworkingClient {
    public static void handleSyncPacket(ImmPtlNetworking.PortalSyncPacket syncPacket) {
        ResourceKey<Level> dimension = PortalAPI.clientIntToDimKey(syncPacket.dimensionId());
        ClientLevel world = ClientWorldLoader.getWorld(dimension);
        Entity existing = world.getEntity(syncPacket.id());
        if (existing instanceof Portal) {
            Portal existingPortal = (Portal)existing;
            if (!Objects.equals(existingPortal.getUUID(), syncPacket.uuid())) {
                ImmPtlNetworking.LOGGER.error("UUID mismatch when syncing portal {} {}", (Object)existingPortal, (Object)syncPacket.uuid());
                return;
            }
            if (existingPortal.getType() != syncPacket.entityType()) {
                ImmPtlNetworking.LOGGER.error("Entity type mismatch when syncing portal {} {}", (Object)existingPortal, syncPacket.type());
                return;
            }
            existingPortal.acceptDataSync(new Vec3(syncPacket.x(), syncPacket.y(), syncPacket.z()), syncPacket.extraData());
        } else {
            Entity entity = syncPacket.entityType().create((Level)world);
            Validate.notNull((Object)entity, (String)"Entity type is null", (Object[])new Object[0]);
            if (!(entity instanceof Portal)) {
                ImmPtlNetworking.LOGGER.error("Spawned entity is not a portal. {} {}", (Object)entity, syncPacket.type());
                return;
            }
            Portal portal = (Portal)entity;
            entity.setId(syncPacket.id());
            entity.setUUID(syncPacket.uuid());
            entity.syncPacketPositionCodec(syncPacket.x(), syncPacket.y(), syncPacket.z());
            entity.moveTo(syncPacket.x(), syncPacket.y(), syncPacket.z());
            portal.readPortalDataFromNbt(syncPacket.extraData());
            world.addEntity(entity);
            ClientWorldLoader.getWorld(portal.dimensionTo);
            NeoForge.EVENT_BUS.post((Event)new ClientPortalSpawnEvent(portal));
            if (IPGlobal.clientPortalLoadDebug) {
                ImmPtlNetworking.LOGGER.info("Portal loaded to client {}", (Object)portal);
            }
        }
    }
}

