/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.network;

import com.mojang.logging.LogUtils;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.ServerPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.network.ImmPtlNetworkingClient;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorageClient;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;

public class ImmPtlNetworking {
    static final Logger LOGGER = LogUtils.getLogger();

    public record PortalSyncPacket(int id, UUID uuid, EntityType<?> entityType, int dimensionId, double x, double y, double z, CompoundTag extraData) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PortalSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"imm_ptl:spawn_portal"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PortalSyncPacket> CODEC = StreamCodec.of((b, p) -> p.write((RegistryFriendlyByteBuf)b), PortalSyncPacket::read);

        public void write(RegistryFriendlyByteBuf buf) {
            buf.writeVarInt(this.id);
            buf.writeUUID(this.uuid);
            ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE).encode((Object)buf, this.entityType);
            buf.writeVarInt(this.dimensionId);
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeNbt((Tag)this.extraData);
        }

        public static PortalSyncPacket read(RegistryFriendlyByteBuf buf) {
            int id = buf.readVarInt();
            UUID uuid = buf.readUUID();
            EntityType type = (EntityType)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE).decode((Object)buf);
            int dimensionId = buf.readVarInt();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            CompoundTag extraData = buf.readNbt();
            return new PortalSyncPacket(id, uuid, type, dimensionId, x, y, z, extraData);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public void handle() {
            ImmPtlNetworkingClient.handleSyncPacket(this);
        }
    }

    public record GlobalPortalSyncPacket(int dimensionId, CompoundTag data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<GlobalPortalSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"imm_ptl:upd_glb_ptl"));
        public static final StreamCodec<FriendlyByteBuf, GlobalPortalSyncPacket> CODEC = StreamCodec.of((b, p) -> p.write((FriendlyByteBuf)b), GlobalPortalSyncPacket::read);

        public static GlobalPortalSyncPacket read(FriendlyByteBuf buf) {
            int dimId = buf.readVarInt();
            CompoundTag compoundTag = buf.readNbt();
            return new GlobalPortalSyncPacket(dimId, compoundTag);
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeVarInt(this.dimensionId);
            buf.writeNbt((Tag)this.data);
        }

        public void handle() {
            ResourceKey<Level> dim = PortalAPI.clientIntToDimKey(this.dimensionId);
            GlobalPortalStorageClient.receiveGlobalPortalSync(dim, this.data);
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record TeleportPacket(int dimensionId, Vec3 eyePosBeforeTeleportation, UUID portalId) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<TeleportPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"imm_ptl:teleport"));
        public static final StreamCodec<FriendlyByteBuf, TeleportPacket> CODEC = StreamCodec.of((b, p) -> p.write((FriendlyByteBuf)b), TeleportPacket::read);

        public static TeleportPacket read(FriendlyByteBuf buf) {
            int dimId = buf.readVarInt();
            Vec3 pos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
            UUID portalId = buf.readUUID();
            return new TeleportPacket(dimId, pos, portalId);
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeVarInt(this.dimensionId);
            buf.writeDouble(this.eyePosBeforeTeleportation.x);
            buf.writeDouble(this.eyePosBeforeTeleportation.y);
            buf.writeDouble(this.eyePosBeforeTeleportation.z);
            buf.writeUUID(this.portalId);
        }

        public void handle(ServerPayloadContext ctx) {
            ServerPlayer player = ctx.player();
            ResourceKey<Level> dim = PortalAPI.serverIntToDimKey(player.server, this.dimensionId);
            ServerTeleportationManager.of(player.server).onPlayerTeleportedInClient(player, dim, this.eyePosBeforeTeleportation, this.portalId);
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

