/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.network;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ConfigurationTask;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.configuration.ICustomConfigurationTask;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.mixin.common.other_sync.IEServerConfigurationPacketListenerImpl;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.O_O;

public class ImmPtlNetworkConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static ModVersion immPtlVersion;
    @Nullable
    private static ModVersion serverVersion;

    public static void init(IEventBus eventBus) {
        immPtlVersion = O_O.getImmPtlVersion();
        LOGGER.info("Immersive Portals Core version {}", (Object)immPtlVersion);
        eventBus.addListener(RegisterConfigurationTasksEvent.class, event -> {
            if (event.getListener().getConnectionType().isNeoForge()) {
                event.register((ConfigurationTask)new ImmPtlConfigurationTask());
            } else if (FMLEnvironment.dist.isDedicatedServer()) {
                if (IPConfig.getConfig().serverRejectClientWithoutImmPtl) {
                    event.getListener().disconnect((Component)Component.literal((String)"The server detected that client does not install Immersive Portals mod.\nA server with Immersive Portals mod only works with the clients that have it.\n\n(Note: The networking sync may be interfered by Essential mod or other mods. When you are using these mods, the detection may malfunction. In this case, you can disable networking check in the server side by changing `serverRejectClientWithoutImmPtl` to `false` in the server's config file `config/immersive_portals.json` and restart.)\n"));
                } else {
                    GameProfile gameProfile = ((IEServerConfigurationPacketListenerImpl)event.getListener()).ip_getGameProfile();
                    LOGGER.warn("Neo detected that client does not install ImmPtl. {} {}", (Object)gameProfile.getName(), (Object)gameProfile.getId());
                }
            } else {
                LOGGER.error("ImmPtl configuration channel is non-sendable from Fabric API in integrated server. Fabric API sendable channel sync is interfered.");
            }
        });
    }

    public static void initClient() {
        NeoForge.EVENT_BUS.addListener(ClientPlayerNetworkEvent.LoggingIn.class, event -> ImmPtlNetworkConfig.onClientJoin());
    }

    private static void onClientJoin() {
        if (serverVersion == null) {
            ImmPtlNetworkConfig.warnServerMissingImmPtl();
        } else if (serverVersion.isNormalVersion() && immPtlVersion.isNormalVersion() && !serverVersion.equals(immPtlVersion) && IPConfig.getConfig().shouldDisplayWarning("mod_version_mismatch")) {
            MutableComponent text = Component.translatable((String)"imm_ptl.mod_patch_version_mismatch", (Object[])new Object[]{Component.literal((String)serverVersion.toString()).withStyle(ChatFormatting.GOLD), Component.literal((String)immPtlVersion.toString()).withStyle(ChatFormatting.GOLD)}).append(IPMcHelper.getDisableWarningText("mod_version_mismatch"));
            CHelper.printChat((Component)text);
        }
    }

    public static boolean doesServerHaveImmPtl() {
        return serverVersion != null;
    }

    private static void warnServerMissingImmPtl() {
        Minecraft.getInstance().execute(() -> CHelper.printChat((Component)Component.translatable((String)"imm_ptl.server_missing_immptl")));
    }

    static {
        serverVersion = null;
    }

    public record ModVersion(int major, int minor, int patch) {
        public static final ModVersion OTHER = new ModVersion(0, 0, 0);

        public static ModVersion read(FriendlyByteBuf buf) {
            int major = buf.readVarInt();
            int minor = buf.readVarInt();
            int patch = buf.readVarInt();
            return new ModVersion(major, minor, patch);
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeVarInt(this.major);
            buf.writeVarInt(this.minor);
            buf.writeVarInt(this.patch);
        }

        @Override
        public String toString() {
            return "%d.%d.%d".formatted(this.major, this.minor, this.patch);
        }

        public boolean isNormalVersion() {
            return !OTHER.equals(this);
        }

        public boolean isCompatibleWith(ModVersion another) {
            return this.major == another.major && this.minor == another.minor;
        }
    }

    public record ImmPtlConfigurationTask() implements ICustomConfigurationTask
    {
        public static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type("iportal:config");

        public void run(Consumer<CustomPacketPayload> sender) {
            sender.accept(new S2CConfigStartPacket(immPtlVersion));
        }

        @NotNull
        public ConfigurationTask.Type type() {
            return TYPE;
        }
    }

    public record C2SConfigCompletePacket(ModVersion versionFromClient, boolean clientTolerantVersionMismatch) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<C2SConfigCompletePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"iportal:configure_complete"));
        public static final StreamCodec<FriendlyByteBuf, C2SConfigCompletePacket> CODEC = StreamCodec.of((b, p) -> p.write((FriendlyByteBuf)b), C2SConfigCompletePacket::read);

        public static C2SConfigCompletePacket read(FriendlyByteBuf buf) {
            ModVersion info = ModVersion.read(buf);
            boolean clientTolerantVersionMismatch = buf.readBoolean();
            return new C2SConfigCompletePacket(info, clientTolerantVersionMismatch);
        }

        public void write(FriendlyByteBuf buf) {
            this.versionFromClient.write(buf);
            buf.writeBoolean(this.clientTolerantVersionMismatch);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public void handle(IPayloadContext configurationPayloadContext) {
            if (this.versionFromClient.isNormalVersion() && immPtlVersion.isNormalVersion() && (this.versionFromClient.major != ImmPtlNetworkConfig.immPtlVersion.major || this.versionFromClient.minor != ImmPtlNetworkConfig.immPtlVersion.minor) && !IPConfig.getConfig().serverTolerantVersionMismatchWithClient && !this.clientTolerantVersionMismatch) {
                configurationPayloadContext.disconnect((Component)Component.translatable((String)"imm_ptl.mod_major_minor_version_mismatch", (Object[])new Object[]{immPtlVersion.toString(), this.versionFromClient.toString()}));
                LOGGER.info("Disconnecting client because of ImmPtl version difference (only patch version difference is tolerated).\nGame Profile:\nClient ImmPtl version: {}\nServer ImmPtl version: {}", (Object)this.versionFromClient, (Object)immPtlVersion);
                return;
            }
            configurationPayloadContext.finishCurrentTask(ImmPtlConfigurationTask.TYPE);
        }
    }

    public record S2CConfigStartPacket(ModVersion versionFromServer) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<S2CConfigStartPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"iportal:config_packet"));
        public static final StreamCodec<FriendlyByteBuf, S2CConfigStartPacket> CODEC = StreamCodec.of((b, p) -> p.write((FriendlyByteBuf)b), S2CConfigStartPacket::read);

        public static S2CConfigStartPacket read(FriendlyByteBuf buf) {
            ModVersion info = ModVersion.read(buf);
            return new S2CConfigStartPacket(info);
        }

        public void write(FriendlyByteBuf buf) {
            this.versionFromServer.write(buf);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public void handle(IPayloadContext configurationPayloadContext) {
            LOGGER.info("Client received ImmPtl config packet. Server mod version: {}", (Object)this.versionFromServer);
            serverVersion = this.versionFromServer;
            configurationPayloadContext.reply((CustomPacketPayload)new C2SConfigCompletePacket(immPtlVersion, IPConfig.getConfig().clientTolerantVersionMismatchWithServer));
        }
    }
}

