/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.position_sync;

import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEPlayerMoveC2SPacket;
import qouteall.imm_ptl.core.ducks.IEPlayerPositionLookS2CPacket;
import qouteall.imm_ptl.core.ducks.IEServerPlayNetworkHandler;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;
import qouteall.q_misc_util.my_util.CountDownInt;

@Mixin(value={ServerGamePacketListenerImpl.class}, priority=900)
public abstract class MixinServerGamePacketListenerImpl
implements IEServerPlayNetworkHandler {
    @Shadow
    public ServerPlayer player;
    @Shadow
    private Vec3 awaitingPositionFromClient;
    @Shadow
    private int awaitingTeleport;
    @Shadow
    private int awaitingTeleportTime;
    @Shadow
    private int tickCount;
    @Shadow
    private double vehicleLastGoodX;
    @Shadow
    private double vehicleLastGoodY;
    @Shadow
    private double vehicleLastGoodZ;
    @Shadow
    private double vehicleFirstGoodX;
    @Shadow
    private double vehicleFirstGoodY;
    @Shadow
    private double vehicleFirstGoodZ;
    @Shadow
    private Entity lastVehicle;
    @Shadow
    private boolean clientVehicleIsFloating;
    @Shadow
    @Final
    static Logger LOGGER;
    @Shadow
    private boolean clientIsFloating;
    @Unique
    private static final CountDownInt LOG_LIMIT;
    @Unique
    private int ip_wrongMovePacketCount = 0;
    @Unique
    @Nullable
    private ResourceKey<Level> ip_dimOfAwaitingPosition;

    @Shadow
    public abstract ServerPlayer getPlayer();

    @Inject(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/server/level/ServerLevel;)V")}, cancellable=true)
    private void onProcessMovePacket(ServerboundMovePlayerPacket packet, CallbackInfo ci) {
        ResourceKey<Level> packetDimension = ((IEPlayerMoveC2SPacket)packet).ip_getPlayerDimension();
        if (packetDimension == null) {
            LOGGER.error("Player move packet is missing dimension info. Maybe the player client doesn't install iPortal");
            ServerTaskList.of(this.player.server).addTask(() -> {
                this.player.connection.disconnect((Component)Component.literal((String)"The client does not have Immersive Portals mod"));
                return true;
            });
            return;
        }
        if (this.player.level().dimension() != packetDimension) {
            if (LOG_LIMIT.tryDecrement()) {
                LOGGER.info("[ImmPtl] Ignoring player move packet. Player: {} Packet: {} {} {} {}", new Object[]{this.player, packetDimension.location(), packet.getX(this.player.getX()), packet.getY(this.player.getY()), packet.getZ(this.player.getZ())});
            }
            ++this.ip_wrongMovePacketCount;
            if (this.ip_wrongMovePacketCount > 10) {
                LOGGER.info("[ImmPtl] Force move player {} {} {}", new Object[]{this.player, this.player.level().dimension().location(), this.player.position()});
                ServerTeleportationManager.of(this.player.server).forceTeleportPlayer(this.player, (ResourceKey<Level>)this.player.level().dimension(), this.player.position());
                this.ip_wrongMovePacketCount = 0;
            }
            ci.cancel();
        } else {
            this.ip_wrongMovePacketCount = 0;
        }
    }

    @Overwrite
    @IPVanillaCopy
    public void teleport(double x, double y, double z, float yaw, float pitch, Set<RelativeMovement> relativeAttrs) {
        if (this.player.getRemovalReason() != null) {
            LOGGER.error("[ImmPtl] Tries to send player pos packet to a removed player {}", (Object)this.player, (Object)new Throwable());
            return;
        }
        if (IPConfig.getConfig().serverTeleportLogging) {
            LOGGER.info("Teleporting player {} to {} {} {} {}", new Object[]{this.player, this.player.level().dimension().location(), x, y, z});
        }
        double xBase = relativeAttrs.contains(RelativeMovement.X) ? this.player.getX() : 0.0;
        double yBase = relativeAttrs.contains(RelativeMovement.Y) ? this.player.getY() : 0.0;
        double zBase = relativeAttrs.contains(RelativeMovement.Z) ? this.player.getZ() : 0.0;
        float yRotBase = relativeAttrs.contains(RelativeMovement.Y_ROT) ? this.player.getYRot() : 0.0f;
        float xRotBase = relativeAttrs.contains(RelativeMovement.X_ROT) ? this.player.getXRot() : 0.0f;
        this.awaitingPositionFromClient = new Vec3(x, y, z);
        this.ip_dimOfAwaitingPosition = this.player.level().dimension();
        if (++this.awaitingTeleport == Integer.MAX_VALUE) {
            this.awaitingTeleport = 0;
        }
        this.awaitingTeleportTime = this.tickCount;
        this.player.absMoveTo(x, y, z, yaw, pitch);
        ClientboundPlayerPositionPacket lookPacket = new ClientboundPlayerPositionPacket(x - xBase, y - yBase, z - zBase, yaw - yRotBase, pitch - xRotBase, relativeAttrs, this.awaitingTeleport);
        ((IEPlayerPositionLookS2CPacket)lookPacket).ip_setPlayerDimension((ResourceKey<Level>)this.player.level().dimension());
        this.player.connection.send((Packet)lookPacket);
    }

    @Inject(method={"isPlayerCollidingWithAnythingNew"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsPlayerCollidingWithAnythingNew(LevelReader level, AABB playerBB, double newX, double newY, double newZ, CallbackInfoReturnable<Boolean> cir) {
        if (!IPGlobal.crossPortalCollision) {
            return;
        }
        AABB activePlayerBB = ((IEEntity)this.player).ip_getActiveCollisionBox(playerBB);
        if (activePlayerBB == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        AABB newBB = this.player.getBoundingBox().move(newX - this.player.getX(), newY - this.player.getY(), newZ - this.player.getZ());
        AABB activeNewBB = ((IEEntity)this.player).ip_getActiveCollisionBox(newBB);
        if (activeNewBB == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        Iterable newBBCollisions = level.getCollisions((Entity)this.player, activeNewBB.deflate((double)1.0E-5f));
        VoxelShape activePlayerBBShape = Shapes.create((AABB)activePlayerBB.deflate((double)1.0E-5f));
        for (VoxelShape shape : newBBCollisions) {
            if (Shapes.joinIsNotEmpty((VoxelShape)shape, (VoxelShape)activePlayerBBShape, (BooleanOp)BooleanOp.AND)) continue;
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (((IEEntity)this.player).ip_isRecentlyCollidingWithPortal()) {
            this.clientIsFloating = false;
        }
    }

    @Inject(method={"handleAcceptTeleportPacket"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;absMoveTo(DDDFF)V")})
    private void onHandleAcceptTeleportPacket(ServerboundAcceptTeleportationPacket packet, CallbackInfo ci) {
        if (this.ip_dimOfAwaitingPosition == null) {
            LOGGER.error("[ImmPtl] ip_dimOfAwaitingPosition is null {}", (Object)this.player);
            return;
        }
        if (this.ip_dimOfAwaitingPosition != this.player.level().dimension()) {
            LOGGER.info("Accepted teleport to another dimension {} {}", this.ip_dimOfAwaitingPosition, (Object)this.awaitingPositionFromClient);
            ServerLevel destWorld = this.player.server.getLevel(this.ip_dimOfAwaitingPosition);
            if (destWorld == null) {
                LOGGER.error("[ImmPtl] Cannot find destination world {}", (Object)this.ip_dimOfAwaitingPosition.location());
                return;
            }
            ServerTeleportationManager.of(this.player.server).forceTeleportPlayer(this.player, this.ip_dimOfAwaitingPosition, this.awaitingPositionFromClient, false);
            this.ip_dimOfAwaitingPosition = null;
        }
    }

    @Inject(method={"handlePlayerCommand"}, at={@At(value="FIELD", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;awaitingPositionFromClient:Lnet/minecraft/world/phys/Vec3;", opcode=181)})
    private void onTeleportPlayerCancelSleeping(ServerboundPlayerCommandPacket packet, CallbackInfo ci) {
        this.ip_dimOfAwaitingPosition = this.player.level().dimension();
    }

    @Override
    public boolean ip_hasAwaitingTeleport() {
        return this.awaitingPositionFromClient != null;
    }

    static {
        LOG_LIMIT = new CountDownInt(20);
    }
}

