/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.mc_util;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.function.Function;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import qouteall.imm_ptl.core.ducks.IESectionedEntityCache;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;

@Mixin(value={EntitySectionStorage.class})
public class MixinEntitySectionStorage<T extends EntityAccess>
implements IESectionedEntityCache<T> {
    @Shadow
    @Final
    private LongSortedSet sectionIds;
    @Shadow
    @Final
    private Long2ObjectMap<EntitySection<T>> sections;

    @Override
    @IPVanillaCopy
    @Nullable
    public <R> R ip_traverseSectionInBox(int chunkXStart, int chunkXEnd, int chunkYStart, int chunkYEnd, int chunkZStart, int chunkZEnd, Function<EntitySection<T>, R> function) {
        for (int cx = chunkXStart; cx <= chunkXEnd; ++cx) {
            long xIndexStart = SectionPos.asLong((int)cx, (int)0, (int)0);
            long xIndexEnd = SectionPos.asLong((int)cx, (int)-1, (int)-1);
            LongBidirectionalIterator iterator = this.sectionIds.subSet(xIndexStart, xIndexEnd + 1L).iterator();
            while (iterator.hasNext()) {
                R result;
                EntitySection entityTrackingSection;
                long sectionPos = iterator.nextLong();
                int sectionY = SectionPos.y((long)sectionPos);
                int sectionZ = SectionPos.z((long)sectionPos);
                if (sectionY < chunkYStart || sectionY > chunkYEnd || sectionZ < chunkZStart || sectionZ > chunkZEnd || (entityTrackingSection = (EntitySection)this.sections.get(sectionPos)) == null || !entityTrackingSection.getStatus().isAccessible() || (result = function.apply(entityTrackingSection)) == null) continue;
                return result;
            }
        }
        return null;
    }
}

