/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.entity_sync;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEEntityTrackerEntry;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.imm_ptl.core.portal.Portal;

@Mixin(value={ServerEntity.class}, priority=1200)
public abstract class MixinServerEntity
implements IEEntityTrackerEntry {
    @Shadow
    @Final
    private Entity entity;
    @Shadow
    @Final
    private VecDeltaCodec positionCodec;
    @Shadow
    @Final
    private static Logger LOGGER;

    @Inject(method={"Lnet/minecraft/server/level/ServerEntity;sendChanges()V"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        PacketRedirection.validateForceRedirecting();
    }

    @Redirect(method={"removePairing"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;)V"))
    private void onSendRemoveEntityPacket(ServerGamePacketListenerImpl networkHandler, Packet packet) {
        if (IPGlobal.entityUntrackDebug) {
            LOGGER.info("Entity remove packet sent {} {}", (Object)this.entity.level().getGameTime(), (Object)this.entity);
        }
        PacketRedirection.sendRedirectedPacket(networkHandler, (Packet<ClientGamePacketListener>)packet, (ResourceKey<Level>)this.entity.level().dimension());
    }

    @Redirect(method={"addPairing"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;)V"))
    private void onSendAddEntityPacket(ServerGamePacketListenerImpl networkHandler, Packet packet) {
        if (IPGlobal.entityTrackDebug) {
            LOGGER.info("Entity add packet sent {} {}", (Object)this.entity.level().getGameTime(), (Object)this.entity);
        }
        PacketRedirection.sendRedirectedPacket(networkHandler, (Packet<ClientGamePacketListener>)packet, (ResourceKey<Level>)this.entity.level().dimension());
    }

    @Redirect(method={"Lnet/minecraft/server/level/ServerEntity;broadcastAndSend(Lnet/minecraft/network/protocol/Packet;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;)V"))
    private void onSendToWatcherAndSelf(ServerGamePacketListenerImpl serverPlayNetworkHandler, Packet packet) {
        PacketRedirection.sendRedirectedPacket(serverPlayNetworkHandler, (Packet<ClientGamePacketListener>)packet, (ResourceKey<Level>)this.entity.level().dimension());
    }

    @Inject(method={"sendChanges"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSendChanges(CallbackInfo ci) {
        if (this.entity instanceof Portal) {
            ci.cancel();
        }
    }

    @Override
    public void ip_updateTrackedEntityPosition() {
        this.positionCodec.setBase(this.entity.trackingPosition());
    }
}

