/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.collision;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.api.ImmPtlEntityExtension;
import qouteall.imm_ptl.core.collision.PortalCollisionHandler;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.portal.EndPortalEntity;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.CountDownInt;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements IEEntity,
ImmPtlEntityExtension {
    @Unique
    @Nullable
    private PortalCollisionHandler ip_portalCollisionHandler;
    @Shadow
    private Level level;
    @Shadow
    public int tickCount;
    @Shadow
    private Vec3 position;
    @Shadow
    private BlockPos blockPosition;
    @Shadow
    private ChunkPos chunkPosition;
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    @Nullable
    private BlockState inBlockState;
    @Unique
    private static final CountDownInt IMM_PTL_LOG_COUNTER;

    @Shadow
    protected abstract Vec3 collide(Vec3 var1);

    @Shadow
    public abstract Component getName();

    @Shadow
    public abstract double getX();

    @Shadow
    public abstract double getY();

    @Shadow
    public abstract double getZ();

    @Shadow
    protected abstract void unsetRemoved();

    @Redirect(method={"Lnet/minecraft/world/entity/Entity;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"))
    private Vec3 redirectHandleCollisions(Entity entity, Vec3 attemptedMove) {
        if (!IPGlobal.enableServerCollision && !entity.level().isClientSide()) {
            if (entity instanceof Player) {
                return attemptedMove;
            }
            return Vec3.ZERO;
        }
        if (attemptedMove.lengthSqr() > 3600.0) {
            if (IMM_PTL_LOG_COUNTER.tryDecrement()) {
                LOGGER.error("[ImmPtl] Skipping collision calculation because entity moves too fast {} {} {}", new Object[]{entity, attemptedMove, entity.level().getGameTime(), new Throwable()});
            }
            return Vec3.ZERO;
        }
        if (!IPGlobal.crossPortalCollision || this.ip_portalCollisionHandler == null || !this.ip_portalCollisionHandler.hasCollisionEntry()) {
            Vec3 normalCollisionResult = this.collide(attemptedMove);
            return normalCollisionResult;
        }
        Vec3 result = this.ip_portalCollisionHandler.handleCollision((Entity)this, attemptedMove);
        if (result.lengthSqr() > 400.0) {
            if (IMM_PTL_LOG_COUNTER.tryDecrement()) {
                LOGGER.error("[ImmPtl] cross portal collision result too large {} {} {}", new Object[]{this, attemptedMove, result});
            }
            return Vec3.ZERO;
        }
        return result;
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;fireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsFireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (this.ip_getCollidingPortal() instanceof EndPortalEntity) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Redirect(method={"Lnet/minecraft/world/entity/Entity;checkInsideBlocks()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getBoundingBox()Lnet/minecraft/world/phys/AABB;"))
    private AABB redirectBoundingBoxInCheckingBlockCollision(Entity entity) {
        return this.ip_getActiveCollisionBox(entity.getBoundingBox());
    }

    @Inject(method={"checkInsideBlocks"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/Entity;getBoundingBox()Lnet/minecraft/world/phys/AABB;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void onCheckInsideBlocks(CallbackInfo ci, AABB box) {
        if (box == null) {
            ci.cancel();
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;isInWall()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsInsideWall(CallbackInfoReturnable<Boolean> cir) {
        if (this.ip_isRecentlyCollidingWithPortal()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;setPosRaw(DDD)V"}, at={@At(value="HEAD")})
    private void onSetPos(double nx, double ny, double nz, CallbackInfo ci) {
        Entity this_ = (Entity)this;
        if (this_ instanceof Player && IPGlobal.teleportationDebugEnabled && (Math.abs(this.getX() - nx) > 10.0 || Math.abs(this.getY() - ny) > 10.0 || Math.abs(this.getZ() - nz) > 10.0)) {
            Helper.log(String.format("%s %s teleported from %s %s %s to %s %s %s", this.getName().getContents(), this.level.dimension(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), (int)nx, (int)ny, (int)nz));
            new Throwable().printStackTrace();
        }
    }

    @Inject(method={"getInBlockState"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetInBlockState(CallbackInfoReturnable<BlockState> cir) {
        Portal collidingPortal = this.ip_getCollidingPortal();
        Entity this_ = (Entity)this;
        if (collidingPortal != null && collidingPortal.getNormal().y > 0.0) {
            BlockState result;
            BlockPos remoteLandingPos = BlockPos.containing((Position)collidingPortal.transformPoint(this_.position()));
            Level destinationWorld = collidingPortal.getDestinationWorld();
            if (destinationWorld.hasChunkAt(remoteLandingPos) && !(result = destinationWorld.getBlockState(remoteLandingPos)).isAir()) {
                cir.setReturnValue((Object)result);
                cir.cancel();
            }
        }
    }

    @Override
    public Portal ip_getCollidingPortal() {
        if (this.ip_portalCollisionHandler == null) {
            return null;
        }
        if (this.ip_portalCollisionHandler.portalCollisions.isEmpty()) {
            return null;
        }
        return this.ip_portalCollisionHandler.portalCollisions.get((int)0).portal;
    }

    @Override
    public void ip_tickCollidingPortal() {
        Entity this_ = (Entity)this;
        if (this.ip_portalCollisionHandler != null) {
            this.ip_portalCollisionHandler.update(this_);
        }
        if (this.level.isClientSide) {
            IPMcHelper.onClientEntityTick(this_);
        }
    }

    @Override
    public void ip_notifyCollidingWithPortal(Entity portal) {
        Entity this_ = (Entity)this;
        if (this.ip_portalCollisionHandler == null) {
            this.ip_portalCollisionHandler = new PortalCollisionHandler();
        }
        this.ip_portalCollisionHandler.notifyCollidingWithPortal(this_, (Portal)portal);
    }

    @Override
    public boolean ip_isCollidingWithPortal() {
        if (this.ip_portalCollisionHandler == null) {
            return false;
        }
        return this.ip_portalCollisionHandler.hasCollisionEntry();
    }

    @Override
    public boolean ip_isRecentlyCollidingWithPortal() {
        if (this.ip_portalCollisionHandler == null) {
            return false;
        }
        return this.ip_portalCollisionHandler.isRecentlyCollidingWithPortal((Entity)this);
    }

    @Override
    public void ip_unsetRemoved() {
        this.unsetRemoved();
    }

    @Override
    @IPVanillaCopy
    public void ip_setPositionWithoutTriggeringCallback(Vec3 newPos) {
        double x = newPos.x;
        double y = newPos.y;
        double z = newPos.z;
        if (this.position.x != x || this.position.y != y || this.position.z != z) {
            this.position = new Vec3(x, y, z);
            int bx = Mth.floor((double)x);
            int by = Mth.floor((double)y);
            int bz = Mth.floor((double)z);
            if (bx != this.blockPosition.getX() || by != this.blockPosition.getY() || bz != this.blockPosition.getZ()) {
                this.blockPosition = new BlockPos(bx, by, bz);
                this.inBlockState = null;
                if (SectionPos.blockToSectionCoord((int)bx) != this.chunkPosition.x || SectionPos.blockToSectionCoord((int)bz) != this.chunkPosition.z) {
                    this.chunkPosition = new ChunkPos(this.blockPosition);
                }
            }
        }
    }

    @Override
    public void ip_clearCollidingPortal() {
        this.ip_portalCollisionHandler = null;
    }

    @Override
    @Nullable
    public AABB ip_getActiveCollisionBox(AABB originalBox) {
        Entity this_ = (Entity)this;
        if (this.ip_portalCollisionHandler == null) {
            return originalBox;
        }
        return this.ip_portalCollisionHandler.getActiveCollisionBox(this_, originalBox);
    }

    @Override
    @Nullable
    public PortalCollisionHandler ip_getPortalCollisionHandler() {
        return this.ip_portalCollisionHandler;
    }

    @Override
    public PortalCollisionHandler ip_getOrCreatePortalCollisionHandler() {
        if (this.ip_portalCollisionHandler == null) {
            this.ip_portalCollisionHandler = new PortalCollisionHandler();
        }
        return this.ip_portalCollisionHandler;
    }

    @Override
    public void ip_setPortalCollisionHandler(@Nullable PortalCollisionHandler handler) {
        this.ip_portalCollisionHandler = handler;
    }

    @Override
    public void ip_setWorld(Level world) {
        this.level = world;
    }

    private long ip_getStableTiming() {
        return this.tickCount;
    }

    static {
        IMM_PTL_LOG_COUNTER = new CountDownInt(20);
    }
}

