/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.chunk_sync;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTracking;

@Mixin(value={PlayerChunkSender.class})
public class MixinPlayerChunkSender {
    @Shadow
    @Final
    private static Logger LOGGER;

    @Overwrite
    public void markChunkPendingToSend(LevelChunk levelChunk) {
    }

    @Overwrite
    public void dropChunk(ServerPlayer serverPlayer, ChunkPos chunkPos) {
    }

    @Inject(method={"sendNextChunks"}, at={@At(value="HEAD")}, cancellable=true)
    public void sendNextChunks(ServerPlayer serverPlayer, CallbackInfo ci) {
        ImmPtlChunkTracking.getPlayerInfo(serverPlayer).doChunkSending(serverPlayer);
        ci.cancel();
    }

    @Overwrite
    public void onChunkBatchReceivedByClient(float f) {
    }

    @Overwrite
    public boolean isPending(long l) {
        LOGGER.error("This should not be called", new Throwable());
        return false;
    }
}

