/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.chunk_sync;

import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTracking;
import qouteall.imm_ptl.core.ducks.IEChunkMap;

@Mixin(value={ChunkMap.class}, priority=1100)
public abstract class MixinChunkMap_C
implements IEChunkMap {
    @Shadow
    @Final
    private ServerLevel level;
    @Shadow
    @Final
    private ThreadedLevelLightEngine lightEngine;

    @Shadow
    protected abstract ChunkHolder getVisibleChunkIfPresent(long var1);

    @Shadow
    abstract int getPlayerViewDistance(ServerPlayer var1);

    @Override
    public int ip_getPlayerViewDistance(ServerPlayer player) {
        return this.getPlayerViewDistance(player);
    }

    @Override
    public ServerLevel ip_getWorld() {
        return this.level;
    }

    @Override
    public ThreadedLevelLightEngine ip_getLightingProvider() {
        return this.lightEngine;
    }

    @Override
    public ChunkHolder ip_getChunkHolder(long chunkPosLong) {
        return this.getVisibleChunkIfPresent(chunkPosLong);
    }

    @Inject(method={"applyChunkTrackingView"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUpdateChunkTracking(ServerPlayer serverPlayer, ChunkTrackingView chunkTrackingView, CallbackInfo ci) {
        ci.cancel();
    }

    @Overwrite
    private void onChunkReadyToSend(LevelChunk chunk) {
        ImmPtlChunkTracking.onChunkProvidedDeferred(chunk);
    }

    @Overwrite
    public List<ServerPlayer> getPlayers(ChunkPos pos, boolean boundaryOnly) {
        return ImmPtlChunkTracking.getPlayersViewingChunk((ResourceKey<Level>)this.level.dimension(), pos.x, pos.z, boundaryOnly);
    }
}

