/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client.render.shader;

import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.Program;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.imm_ptl.core.render.ShaderCodeTransformation;

@Mixin(value={Program.class})
public class MixinProgram {
    private static final ThreadLocal<Program.Type> ip_programType = new ThreadLocal();
    private static final ThreadLocal<String> ip_programName = new ThreadLocal();

    @Inject(method={"compileShaderInternal"}, at={@At(value="HEAD")})
    private static void onBeginCompileShaderInternal(Program.Type type, String name, InputStream shaderData, String sourceName, GlslPreprocessor preprocessor, CallbackInfoReturnable<Integer> cir) {
        Validate.isTrue((ip_programType.get() == null ? 1 : 0) != 0);
        Validate.isTrue((ip_programName.get() == null ? 1 : 0) != 0);
        ip_programType.set(type);
        ip_programName.set(name);
    }

    @Inject(method={"compileShaderInternal"}, at={@At(value="RETURN")})
    private static void onEndCompileShaderInternal(Program.Type type, String name, InputStream shaderData, String sourceName, GlslPreprocessor preprocessor, CallbackInfoReturnable<Integer> cir) {
        Validate.isTrue((ip_programType.get() == type ? 1 : 0) != 0);
        Validate.isTrue((boolean)Objects.equals(ip_programName.get(), name));
        ip_programType.set(null);
        ip_programName.set(null);
    }

    @Redirect(method={"compileShaderInternal"}, at=@At(value="INVOKE", target="Lorg/apache/commons/io/IOUtils;toString(Ljava/io/InputStream;Ljava/nio/charset/Charset;)Ljava/lang/String;", remap=false))
    private static String redirectReadShaderSource(InputStream inputStream, Charset charset) throws IOException {
        String shaderCode = IOUtils.toString((InputStream)inputStream, (Charset)charset);
        Program.Type type = ip_programType.get();
        String name = ip_programName.get();
        Validate.notNull((Object)type);
        Validate.notNull((Object)name);
        String transformedShaderCode = ShaderCodeTransformation.transform(type, name, shaderCode);
        return transformedShaderCode;
    }
}

