/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client.render.optimization;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.render.context_management.CloudContext;
import qouteall.imm_ptl.core.render.context_management.RenderStates;

@Mixin(value={LevelRenderer.class})
public abstract class MixinLevelRenderer_Clouds {
    @Shadow
    private int prevCloudX;
    @Shadow
    private int prevCloudY;
    @Shadow
    private int prevCloudZ;
    @Shadow
    @Nullable
    private VertexBuffer cloudBuffer;
    @Shadow
    private ClientLevel level;
    @Shadow
    private boolean generateClouds;
    @Shadow
    private int ticks;

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")})
    private void onBeginRenderClouds(PoseStack poseStack, Matrix4f projectionMatrix, Matrix4f frustrumMatrix, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        if (RenderStates.getRenderedPortalNum() == 0) {
            return;
        }
        if (IPGlobal.cloudOptimization) {
            this.portal_onBeginCloudRendering(partialTick, camX, camY, camZ);
        }
    }

    @Inject(method={"renderClouds"}, at={@At(value="RETURN")})
    private void onEndRenderClouds(PoseStack poseStack, Matrix4f projectionMatrix, Matrix4f frustrumMatrix, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        if (RenderStates.getRenderedPortalNum() == 0) {
            return;
        }
        if (IPGlobal.cloudOptimization) {
            this.portal_onEndCloudRendering();
        }
    }

    private void portal_yieldCloudContext(CloudContext context) {
        Vec3 cloudsColor = this.level.getCloudColor(RenderStates.getPartialTick());
        context.lastCloudsBlockX = this.prevCloudX;
        context.lastCloudsBlockY = this.prevCloudY;
        context.lastCloudsBlockZ = this.prevCloudZ;
        context.cloudsBuffer = this.cloudBuffer;
        context.dimension = this.level.dimension();
        context.cloudColor = cloudsColor;
        this.cloudBuffer = null;
        this.generateClouds = true;
    }

    private void portal_loadCloudContext(CloudContext context) {
        Validate.isTrue((context.dimension == this.level.dimension() ? 1 : 0) != 0);
        this.prevCloudX = context.lastCloudsBlockX;
        this.prevCloudY = context.lastCloudsBlockY;
        this.prevCloudZ = context.lastCloudsBlockZ;
        this.cloudBuffer = context.cloudsBuffer;
        this.generateClouds = false;
    }

    @IPVanillaCopy
    private void portal_onBeginCloudRendering(float partialTick, double cameraX, double cameraY, double cameraZ) {
        int kz;
        int ky;
        float f = this.level.effects().getCloudHeight();
        float g = 12.0f;
        float h = 4.0f;
        double d = 2.0E-4;
        double e = ((float)this.ticks + partialTick) * 0.03f;
        double i = (cameraX + e) / 12.0;
        double j = f - (float)cameraY + 0.33f;
        double k = cameraZ / 12.0 + (double)0.33f;
        i -= (double)(Mth.floor((double)(i / 2048.0)) * 2048);
        k -= (double)(Mth.floor((double)(k / 2048.0)) * 2048);
        float l = (float)(i - (double)Mth.floor((double)i));
        float m = (float)(j / 4.0 - (double)Mth.floor((double)(j / 4.0))) * 4.0f;
        float n = (float)(k - (double)Mth.floor((double)k));
        Vec3 cloudsColor = this.level.getCloudColor(partialTick);
        int kx = (int)Math.floor(i);
        @Nullable CloudContext context = CloudContext.findAndTakeContext(kx, ky = (int)Math.floor(j / 4.0), kz = (int)Math.floor(k), (ResourceKey<Level>)this.level.dimension(), cloudsColor);
        if (context != null) {
            this.portal_loadCloudContext(context);
        }
    }

    private void portal_onEndCloudRendering() {
        if (!this.generateClouds) {
            CloudContext newContext = new CloudContext();
            this.portal_yieldCloudContext(newContext);
            CloudContext.appendContext(newContext);
        }
    }
}

