/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client.render;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.render.CrossPortalEntityRenderer;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.ImmPtlViewArea;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.VisibleSectionDiscovery;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;

@Mixin(value={LevelRenderer.class})
public abstract class MixinLevelRenderer
implements IEWorldRenderer {
    @Shadow
    private ClientLevel level;
    @Shadow
    @Final
    private EntityRenderDispatcher entityRenderDispatcher;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private ViewArea viewArea;
    @Shadow
    private PostChain transparencyChain;
    @Mutable
    @Shadow
    @Final
    private RenderBuffers renderBuffers;
    @Shadow
    private int lastViewDistance;
    @Shadow
    @Nullable
    private RenderTarget translucentTarget;
    @Shadow
    private Frustum cullingFrustum;
    @Shadow
    @Nullable
    private VertexBuffer starBuffer;
    @Shadow
    @Nullable
    private VertexBuffer skyBuffer;
    @Shadow
    @Nullable
    private VertexBuffer darkBuffer;
    @Shadow
    @Nullable
    private VertexBuffer cloudBuffer;
    @Shadow
    @Nullable
    private SectionRenderDispatcher sectionRenderDispatcher;
    @Shadow
    @Final
    @Mutable
    private ObjectArrayList<SectionRenderDispatcher.RenderSection> visibleSections;

    @Shadow
    protected abstract void renderEntity(Entity var1, double var2, double var4, double var6, float var8, PoseStack var9, MultiBufferSource var10);

    @Shadow
    protected abstract void deinitTransparency();

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/DimensionSpecialEffects;constantAmbientLight()Z")})
    private void onAfterCutoutRendering(DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f modelView, Matrix4f matrix4f2, CallbackInfo ci) {
        CrossPortalEntityRenderer.onBeginRenderingEntitiesAndBlockEntities(modelView);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/Sheets;translucentCullBlockSheet()Lnet/minecraft/client/renderer/RenderType;")})
    private void onMyBeforeTranslucentRendering(DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f modelView, Matrix4f matrix4f2, CallbackInfo ci) {
        IPCGlobal.renderer.onBeforeTranslucentRendering(modelView);
        MyGameRenderer.updateFogColor();
        MyGameRenderer.resetFogState();
        MyGameRenderer.resetDiffuseLighting();
        FrontClipping.disableClipping();
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;endLastBatch()V", ordinal=1, shift=At.Shift.AFTER)})
    @IPVanillaCopy
    private void onEndRenderingEntities(DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci, @Local PoseStack poseStack) {
        CrossPortalEntityRenderer.onEndRenderingEntitiesAndBlockEntities(poseStack);
    }

    @Inject(method={"renderLevel"}, at={@At(value="RETURN")})
    private void onAfterTranslucentRendering(DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f modelView, Matrix4f matrix4f2, CallbackInfo ci) {
        IPCGlobal.renderer.onAfterTranslucentRendering(modelView);
        Lighting.setupLevel();
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSectionLayer(Lnet/minecraft/client/renderer/RenderType;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V")})
    private void onBeforeRenderingLayer(DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f modelView, Matrix4f matrix4f2, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            FrontClipping.setupInnerClipping(PortalRendering.getActiveClippingPlane(), modelView, -0.01);
            if (PortalRendering.isRenderingOddNumberOfMirrors()) {
                MyRenderHelper.applyMirrorFaceCulling();
            }
            if (IPGlobal.enableDepthClampForPortalRendering) {
                CHelper.enableDepthClamp();
            }
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSectionLayer(Lnet/minecraft/client/renderer/RenderType;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V", shift=At.Shift.AFTER)})
    private void onAfterRenderingLayer(DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            FrontClipping.disableClipping();
            MyRenderHelper.recoverFaceCulling();
            if (IPGlobal.enableDepthClampForPortalRendering) {
                CHelper.disableDepthClamp();
            }
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetupTerrainBegin(Camera camera, Frustum frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        if (WorldRenderInfo.isRendering() && this.level.dimension() != RenderStates.originalPlayerDimension) {
            this.sectionRenderDispatcher.setCamera(camera.getPosition());
        }
        if (this.ip_allowOverrideTerrainSetup() && WorldRenderInfo.isRendering()) {
            this.level.getProfiler().push("ip_terrain_setup");
            VisibleSectionDiscovery.discoverVisibleSections(this.level, (ImmPtlViewArea)this.viewArea, camera, new Frustum(frustum).offsetToFullyIncludeCameraCube(8), this.visibleSections);
            this.level.getProfiler().pop();
            ci.cancel();
        }
    }

    private boolean ip_allowOverrideTerrainSetup() {
        return !SodiumInterface.invoker.isSodiumPresent() && !IrisInterface.invoker.isRenderingShadowMap();
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, at={@At(value="RETURN")}, cancellable=true)
    private void onSetupTerrainEnd(Camera camera, Frustum frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        if (!WorldRenderInfo.isRendering() && this.ip_allowOverrideTerrainSetup()) {
            if (MyGameRenderer.vanillaTerrainSetupOverride > 0) {
                --MyGameRenderer.vanillaTerrainSetupOverride;
                this.level.getProfiler().push("ip_terrain_setup");
                VisibleSectionDiscovery.discoverVisibleSections(this.level, (ImmPtlViewArea)this.viewArea, camera, new Frustum(frustum).offsetToFullyIncludeCameraCube(8), this.visibleSections);
                this.level.getProfiler().pop();
            } else if (IPGlobal.alwaysOverrideTerrainSetup) {
                this.level.getProfiler().push("ip_terrain_setup_debug");
                VisibleSectionDiscovery.discoverVisibleSections(this.level, (ImmPtlViewArea)this.viewArea, camera, new Frustum(frustum).offsetToFullyIncludeCameraCube(8), this.visibleSections);
                this.level.getProfiler().pop();
            }
        }
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;clear(IZ)V", remap=false))
    private void redirectClearing(int int_1, boolean boolean_1) {
        if (!IPCGlobal.renderer.replaceFrameBufferClearing()) {
            RenderSystem.clear((int)int_1, (boolean)boolean_1);
        }
    }

    @Redirect(method={"allChanged"}, at=@At(value="NEW", target="(Lnet/minecraft/client/renderer/chunk/SectionRenderDispatcher;Lnet/minecraft/world/level/Level;ILnet/minecraft/client/renderer/LevelRenderer;)Lnet/minecraft/client/renderer/ViewArea;"))
    private ViewArea redirectConstructingBuildChunkStorage(SectionRenderDispatcher chunkBuilder_1, Level world_1, int int_1, LevelRenderer worldRenderer_1) {
        if (IPCGlobal.useHackedChunkRenderDispatcher) {
            return new ImmPtlViewArea(chunkBuilder_1, world_1, int_1, worldRenderer_1);
        }
        return new ViewArea(chunkBuilder_1, world_1, int_1, worldRenderer_1);
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"))
    private void redirectRenderEntity(LevelRenderer worldRenderer, Entity entity, double cameraX, double cameraY, double cameraZ, float partialTick, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider) {
        CrossPortalEntityRenderer.beforeRenderingEntity(entity, matrixStack);
        this.renderEntity(entity, cameraX, cameraY, cameraZ, partialTick, matrixStack, vertexConsumerProvider);
        CrossPortalEntityRenderer.afterRenderingEntity(entity);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V")})
    private void beforeRenderingWeather(DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f modelView, Matrix4f matrix4f2, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            FrontClipping.setupInnerClipping(PortalRendering.getActiveClippingPlane(), modelView, 0.0);
            RenderStates.isRenderingPortalWeather = true;
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V", shift=At.Shift.AFTER)})
    private void afterRenderingWeather(DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            FrontClipping.disableClipping();
            RenderStates.isRenderingPortalWeather = false;
        }
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;shouldEntityAppearGlowing(Lnet/minecraft/world/entity/Entity;)Z"))
    private boolean redirectGlowing(Minecraft client, Entity entity) {
        if (WorldRenderInfo.isRendering()) {
            return false;
        }
        return client.shouldEntityAppearGlowing(entity);
    }

    @Inject(method={"allChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private void onReloadStarted(CallbackInfo ci) {
        if (WorldRenderInfo.isRendering()) {
            Helper.log("world renderer reloading cancelled during portal rendering");
            ci.cancel();
        }
    }

    @Inject(method={"allChanged"}, at={@At(value="TAIL")})
    private void onReloadFinished(CallbackInfo ci) {
        LevelRenderer this_ = (LevelRenderer)this;
        if (ClientWorldLoader.getIsCreatingClientWorld()) {
            return;
        }
        Validate.isTrue((Minecraft.getInstance().levelRenderer == this_ ? 1 : 0) != 0);
        ClientWorldLoader._onWorldRendererReloaded();
    }

    @Inject(method={"renderSky"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderSkyBegin(Matrix4f modelView, Matrix4f matrix4f, float partialTick, Camera camera, boolean isFoggy, Runnable runnable, CallbackInfo ci) {
        if (WorldRenderInfo.isRendering() && !WorldRenderInfo.getTopRenderInfo().doRenderSky && !IrisInterface.invoker.isShaders()) {
            ci.cancel();
        }
        if (PortalRendering.isRenderingOddNumberOfMirrors()) {
            MyRenderHelper.applyMirrorFaceCulling();
        }
    }

    @Inject(method={"renderSky"}, at={@At(value="RETURN")})
    private void onRenderSkyEnd(Matrix4f modelView, Matrix4f matrix4f, float f, Camera camera, boolean bl, Runnable runnable, CallbackInfo ci) {
        MyRenderHelper.recoverFaceCulling();
    }

    @Redirect(method={"renderSky"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"))
    private Vec3 redirectGetEyePositionInSkyRendering(LocalPlayer player, float partialTicks) {
        if (WorldRenderInfo.isRendering()) {
            return WorldRenderInfo.getCameraPos();
        }
        return player.getEyePosition(partialTicks);
    }

    @Redirect(method={"renderLevel"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;translucentTarget:Lcom/mojang/blaze3d/pipeline/RenderTarget;"))
    private RenderTarget redirectTranslucentFramebuffer(LevelRenderer this_) {
        if (PortalRendering.isRendering()) {
            return null;
        }
        return this.translucentTarget;
    }

    @ModifyVariable(method={"Lnet/minecraft/client/renderer/LevelRenderer;setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=1)
    private boolean modifyIsSpectator(boolean value) {
        if (WorldRenderInfo.isRendering()) {
            return true;
        }
        return value;
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;pollLightUpdates()V"))
    private void redirectRunQueuedChunkUpdates(ClientLevel world) {
        ClientWorldLoader.withSwitchedWorld(world, () -> ((ClientLevel)world).pollLightUpdates());
    }

    @Inject(method={"isSectionCompiled"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsChunkCompiled(BlockPos blockPos, CallbackInfoReturnable<Boolean> cir) {
        ViewArea viewArea;
        if (PortalRendering.isRendering() && !SodiumInterface.invoker.isSodiumPresent() && (viewArea = this.viewArea) instanceof ImmPtlViewArea) {
            ImmPtlViewArea immPtlViewArea = (ImmPtlViewArea)viewArea;
            cir.setReturnValue((Object)this.ip_isChunkCompiled(immPtlViewArea, blockPos));
        }
    }

    private boolean ip_isChunkCompiled(ImmPtlViewArea immPtlViewArea, BlockPos blockPos) {
        SectionPos sectionPos = SectionPos.of((BlockPos)blockPos);
        SectionRenderDispatcher.RenderSection renderChunk = immPtlViewArea.rawGet(sectionPos.x(), sectionPos.y(), sectionPos.z());
        return renderChunk != null && renderChunk.compiled.get() != SectionRenderDispatcher.CompiledSection.UNCOMPILED;
    }

    @Override
    public EntityRenderDispatcher ip_getEntityRenderDispatcher() {
        return this.entityRenderDispatcher;
    }

    @Override
    public ViewArea ip_getBuiltChunkStorage() {
        return this.viewArea;
    }

    @Override
    public void ip_myRenderEntity(Entity entity, double cameraX, double cameraY, double cameraZ, float partialTick, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider) {
        this.renderEntity(entity, cameraX, cameraY, cameraZ, partialTick, matrixStack, vertexConsumerProvider);
    }

    @Override
    public PostChain portal_getTransparencyShader() {
        return this.transparencyChain;
    }

    @Override
    public void portal_setTransparencyShader(PostChain arg) {
        this.transparencyChain = arg;
    }

    @Override
    public RenderBuffers ip_getRenderBuffers() {
        return this.renderBuffers;
    }

    @Override
    public void ip_setRenderBuffers(RenderBuffers arg) {
        this.renderBuffers = arg;
    }

    @Override
    public Frustum portal_getFrustum() {
        return this.cullingFrustum;
    }

    @Override
    public void portal_setFrustum(Frustum arg) {
        this.cullingFrustum = arg;
    }

    @Override
    public void portal_fullyDispose() {
        this.deinitTransparency();
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        if (this.skyBuffer != null) {
            this.skyBuffer.close();
        }
        if (this.darkBuffer != null) {
            this.darkBuffer.close();
        }
        if (this.cloudBuffer != null) {
            this.cloudBuffer.close();
        }
        this.level = null;
    }

    @Override
    public void portal_setChunkInfoList(ObjectArrayList<SectionRenderDispatcher.RenderSection> arg) {
        this.visibleSections = arg;
    }

    @Override
    public ObjectArrayList<SectionRenderDispatcher.RenderSection> portal_getChunkInfoList() {
        return this.visibleSections;
    }
}

