/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client.render;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEGameRenderer;
import qouteall.imm_ptl.core.portal.animation.ClientPortalAnimationManagement;
import qouteall.imm_ptl.core.portal.animation.StableClientTimer;
import qouteall.imm_ptl.core.render.CrossPortalViewRendering;
import qouteall.imm_ptl.core.render.GuiPortalRendering;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.renderer.PortalRenderer;
import qouteall.imm_ptl.core.teleportation.ClientTeleportationManager;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer
implements IEGameRenderer {
    @Shadow
    @Final
    @Mutable
    private LightTexture lightTexture;
    @Shadow
    private boolean renderHand;
    @Shadow
    @Final
    @Mutable
    private Camera mainCamera;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private boolean panoramicMode;
    @Shadow
    @Final
    private static Logger LOGGER;
    private static boolean portal_isRenderingHand;

    @Shadow
    public abstract void resetProjectionMatrix(Matrix4f var1);

    @Shadow
    protected abstract void bobView(PoseStack var1, float var2);

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onFarBeforeRendering(DeltaTracker deltaTracker, boolean renderWorldIn, CallbackInfo ci) {
        this.minecraft.getProfiler().push("ip_pre_total_render");
        IPGlobal.PRE_TOTAL_RENDER_TASK_LIST.processTasks();
        this.minecraft.getProfiler().pop();
        if (this.minecraft.level == null) {
            return;
        }
        if (!renderWorldIn) {
            return;
        }
        this.minecraft.getProfiler().push("ip_pre_render");
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(true);
        RenderStates.updatePreRenderInfo(partialTick);
        StableClientTimer.update(this.minecraft.level.getGameTime(), partialTick);
        ClientPortalAnimationManagement.update();
        ClientTeleportationManager.manageTeleportation(false);
        NeoForge.EVENT_BUS.post((Event)new IPGlobal.PreGameRenderEvent());
        if (IPCGlobal.earlyRemoteUpload) {
            MyRenderHelper.earlyRemoteUpload();
        }
        this.minecraft.getProfiler().pop();
        ++RenderStates.frameIndex;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(Lnet/minecraft/client/DeltaTracker;)V")})
    private void onBeforeRenderingCenter(DeltaTracker deltaTracker, boolean bl, CallbackInfo ci) {
        PortalRenderer.switchToCorrectRenderer();
        IPCGlobal.renderer.prepareRendering();
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(Lnet/minecraft/client/DeltaTracker;)V", shift=At.Shift.AFTER)})
    private void onAfterRenderingCenter(DeltaTracker deltaTracker, boolean bl, CallbackInfo ci) {
        IPCGlobal.renderer.finishRendering();
        RenderStates.onTotalRenderEnd();
        GuiPortalRendering._onGameRenderEnd();
        if (IPCGlobal.lateClientLightUpdate) {
            this.minecraft.getProfiler().push("ip_late_update_light");
            MyRenderHelper.lateUpdateLight();
            this.minecraft.getProfiler().pop();
        }
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(Lnet/minecraft/client/DeltaTracker;)V"))
    private void redirectRenderingWorld(GameRenderer gameRenderer, DeltaTracker deltaTracker) {
        if (CrossPortalViewRendering.renderCrossPortalView()) {
            return;
        }
        gameRenderer.renderLevel(deltaTracker);
    }

    @Inject(method={"renderLevel"}, at={@At(value="TAIL")})
    private void onRenderCenterEnded(DeltaTracker deltaTracker, CallbackInfo ci) {
        IPCGlobal.renderer.onHandRenderingEnded();
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V")})
    private void wrapRenderLevel(LevelRenderer instance, DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f modelView, Matrix4f projection, Operation<Void> original) {
        original.call(new Object[]{instance, deltaTracker, bl, camera, gameRenderer, lightTexture, modelView, projection});
        IPCGlobal.renderer.onBeforeHandRendering(modelView);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;resize(II)V"}, at={@At(value="RETURN")})
    private void onOnResized(int int_1, int int_2, CallbackInfo ci) {
        if (ClientWorldLoader.getIsInitialized()) {
            ClientWorldLoader.WORLD_RENDERER_MAP.values().stream().filter(worldRenderer -> worldRenderer != this.minecraft.levelRenderer).forEach(worldRenderer -> worldRenderer.resize(int_1, int_2));
        }
    }

    @Inject(method={"renderItemInHand"}, at={@At(value="HEAD")})
    private void onRenderHandBegins(Camera camera, float f, Matrix4f matrix4f, CallbackInfo ci) {
        portal_isRenderingHand = true;
    }

    @Inject(method={"renderItemInHand"}, at={@At(value="RETURN")})
    private void onRenderHandEnds(Camera camera, float f, Matrix4f matrix4f, CallbackInfo ci) {
        portal_isRenderingHand = false;
    }

    @ModifyArg(method={"bobView"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V"), index=0)
    private float modifyBobViewTranslateX(float f) {
        if (portal_isRenderingHand) {
            return f;
        }
        return (float)((double)f * RenderStates.getViewBobbingOffsetMultiplier());
    }

    @ModifyArg(method={"bobView"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V"), index=1)
    private float modifyBobViewTranslateY(float f) {
        if (portal_isRenderingHand) {
            return f;
        }
        return (float)((double)f * RenderStates.getViewBobbingOffsetMultiplier());
    }

    @ModifyArg(method={"bobView"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V"), index=2)
    private float modifyBobViewTranslateZ(float f) {
        if (portal_isRenderingHand) {
            return f;
        }
        return (float)((double)f * RenderStates.getViewBobbingOffsetMultiplier());
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;getProjectionMatrix(D)Lorg/joml/Matrix4f;", ordinal=0))
    private Matrix4f redirectGetBasicProjectionMatrix(GameRenderer instance, double fov) {
        if (PortalRendering.isRendering()) {
            if (RenderStates.basicProjectionMatrix != null) {
                return new Matrix4f((Matrix4fc)RenderStates.basicProjectionMatrix);
            }
            LOGGER.error("[iPortal] Projection matrix state abnormal");
        }
        Matrix4f result = instance.getProjectionMatrix(fov);
        RenderStates.basicProjectionMatrix = new Matrix4f((Matrix4fc)result);
        return result;
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lorg/joml/Matrix4f;rotation(Lorg/joml/Quaternionfc;)Lorg/joml/Matrix4f;", remap=false)})
    private Matrix4f wrapCameraTransformation(Matrix4f instance, Quaternionfc quat, Operation<Matrix4f> original) {
        Matrix4f r = (Matrix4f)original.call(new Object[]{instance, quat});
        return TransformationManager.processTransformation(this.mainCamera, r);
    }

    @Override
    public void ip_setLightmapTextureManager(LightTexture manager) {
        this.lightTexture = manager;
    }

    @Override
    public boolean ip_getDoRenderHand() {
        return this.renderHand;
    }

    @Override
    public void ip_setCamera(Camera camera_) {
        this.mainCamera = camera_;
    }

    @Override
    public void ip_setIsRenderingPanorama(boolean cond) {
        this.panoramicMode = cond;
    }

    static {
        portal_isRenderingHand = false;
    }
}

