/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.pipeline.RenderTarget;
import de.nick1st.imm_ptl.events.ClientCleanupEvent;
import de.nick1st.imm_ptl.events.ClientExitEvent;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.miscellaneous.ClientPerformanceMonitor;
import qouteall.imm_ptl.core.miscellaneous.IPortalInitialScreen;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.animation.ClientPortalAnimationManagement;
import qouteall.imm_ptl.core.portal.animation.StableClientTimer;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.imm_ptl.core.teleportation.ClientTeleportationManager;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraft
implements IEMinecraftClient {
    @Final
    @Shadow
    @Mutable
    private RenderTarget mainRenderTarget;
    @Shadow
    public Screen screen;
    @Mutable
    @Shadow
    @Final
    public LevelRenderer levelRenderer;
    @Shadow
    private static int fps;
    @Shadow
    @Nullable
    public ClientLevel level;
    @Mutable
    @Shadow
    @Final
    private RenderBuffers renderBuffers;
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    private Thread gameThread;

    @Shadow
    public abstract ProfilerFiller getProfiler();

    @WrapOperation(method={"Lnet/minecraft/client/Minecraft;run()V"}, at={@At(value="INVOKE", target="Ljava/lang/Thread;currentThread()Ljava/lang/Thread;")})
    private Thread testMixinExtra(Operation<Thread> original) {
        LOGGER.info("[ImmPtl] MixinExtra is working!");
        return (Thread)original.call(new Object[0]);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;tickEntities()V")})
    private void onBeforeTickingEntities(CallbackInfo ci) {
    }

    @Inject(method={"Lnet/minecraft/client/Minecraft;tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;tick(Ljava/util/function/BooleanSupplier;)V", shift=At.Shift.AFTER)})
    private void onAfterClientTick(CallbackInfo ci) {
        this.getProfiler().push("imm_ptl_client_tick");
        ClientWorldLoader.tick();
        RenderStates.setPartialTick(0.0f);
        StableClientTimer.tick();
        StableClientTimer.update(this.level.getGameTime(), RenderStates.getPartialTick());
        ClientPortalAnimationManagement.tick();
        ClientTeleportationManager.manageTeleportation(true);
        NeoForge.EVENT_BUS.post((Event)new IPGlobal.PostClientTickEvent());
        this.getProfiler().pop();
    }

    @Inject(method={"Lnet/minecraft/client/Minecraft;runTick(Z)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;fps:I", shift=At.Shift.AFTER)})
    private void onSnooperUpdate(boolean tick, CallbackInfo ci) {
        ClientPerformanceMonitor.updateEverySecond(fps);
    }

    @Inject(method={"Lnet/minecraft/client/Minecraft;updateLevelInEngines(Lnet/minecraft/client/multiplayer/ClientLevel;)V"}, at={@At(value="HEAD")})
    private void onSetWorld(ClientLevel clientLevel, CallbackInfo ci) {
        if (ClientWorldLoader.getIsInitialized()) {
            LOGGER.info("Client cleanup");
            NeoForge.EVENT_BUS.post((Event)new ClientCleanupEvent());
            if (clientLevel == null) {
                LOGGER.info("Client exit world");
                NeoForge.EVENT_BUS.post((Event)new ClientExitEvent());
            }
            ClientWorldLoader.cleanUp();
        } else {
            LOGGER.info("Client world updated but not counted as cleanup");
        }
    }

    @Inject(method={"Lnet/minecraft/client/Minecraft;useShaderTransparency()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onIsFabulousGraphicsOrBetter(CallbackInfoReturnable<Boolean> cir) {
        if (WorldRenderInfo.isRendering()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"addInitialScreens"}, at={@At(value="RETURN")})
    private void onAddInitialScreens(List<Function<Runnable, Screen>> output, CallbackInfo ci) {
        IPConfig config = IPConfig.getConfig();
        if (!config.initialScreenShown) {
            output.add(IPortalInitialScreen::new);
        }
    }

    @Override
    public void ip_setFrameBuffer(RenderTarget buffer) {
        this.mainRenderTarget = buffer;
    }

    @Override
    public Screen ip_getCurrentScreen() {
        return this.screen;
    }

    @Override
    public void ip_setWorldRenderer(LevelRenderer r) {
        this.levelRenderer = r;
    }

    @Override
    public void ip_setRenderBuffers(RenderBuffers arg) {
        this.renderBuffers = arg;
    }

    @Override
    public Thread ip_getRunningThread() {
        return this.gameThread;
    }
}

