/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.miscellaneous;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import qouteall.imm_ptl.core.platform_specific.IPConfig;

public class IPortalInitialScreen
extends Screen {
    private static final int PAGE_NUM = 4;
    private final Runnable onClose;
    private final Button prevButton;
    private final StringWidget pageNumberWidget;
    private final Button iKnowButton;
    private final ImageWidget iconWidget;
    private final StringWidget titleWidget;
    private final MultiLineTextWidget contentWidget;
    private int currentPageIndex = 0;

    public IPortalInitialScreen(Runnable onClose) {
        super((Component)Component.empty());
        this.onClose = onClose;
        this.minecraft = Minecraft.getInstance();
        this.font = this.minecraft.font;
        this.prevButton = Button.builder((Component)Component.translatable((String)"iportal.initial_screen.prev"), button -> this.onPrevious()).build();
        this.pageNumberWidget = new StringWidget((Component)Component.empty(), this.font);
        this.iKnowButton = Button.builder((Component)Component.translatable((String)"iportal.initial_screen.i_know"), button -> this.onIKnow()).build();
        this.iconWidget = ImageWidget.texture((int)30, (int)30, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"immersive_portals", (String)"icon.png"), (int)30, (int)30);
        this.titleWidget = new StringWidget((Component)Component.translatable((String)"iportal.initial_screen.title"), this.font).alignCenter();
        this.contentWidget = new MultiLineTextWidget((Component)Component.empty(), this.font);
    }

    private void onPrevious() {
        if (this.currentPageIndex > 0) {
            --this.currentPageIndex;
            this.updateUiStatus(this.currentPageIndex);
        }
    }

    private void onIKnow() {
        if (this.currentPageIndex == 3) {
            IPConfig config = IPConfig.getConfig();
            config.initialScreenShown = true;
            config.saveConfigFile();
            this.onClose();
        } else {
            ++this.currentPageIndex;
            this.updateUiStatus(this.currentPageIndex);
        }
    }

    private void updateUiStatus(int newPageIndex) {
        this.currentPageIndex = newPageIndex;
        this.prevButton.visible = newPageIndex > 0;
        this.pageNumberWidget.setMessage((Component)Component.literal((String)"%d / %d".formatted(newPageIndex + 1, 4)));
        this.contentWidget.setMessage((Component)Component.translatable((String)("iportal.initial_screen.content." + newPageIndex)));
    }

    public void onClose() {
        this.onClose.run();
    }

    public void init() {
        this.contentWidget.setMaxWidth(this.width - 40);
        this.pageNumberWidget.setWidth(50);
        this.pageNumberWidget.setHeight(this.iKnowButton.getHeight());
        this.pageNumberWidget.alignCenter();
        this.titleWidget.setHeight(this.iconWidget.getHeight());
        this.addRenderableWidget((GuiEventListener)this.prevButton);
        this.addRenderableWidget((GuiEventListener)this.pageNumberWidget);
        this.addRenderableWidget((GuiEventListener)this.iKnowButton);
        this.addRenderableWidget((GuiEventListener)this.iconWidget);
        this.addRenderableWidget((GuiEventListener)this.titleWidget);
        this.addRenderableWidget((GuiEventListener)this.contentWidget);
        HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 60, 33);
        LinearLayout headerLayout = (LinearLayout)layout.addToHeader((LayoutElement)LinearLayout.horizontal());
        headerLayout.addChild((LayoutElement)this.iconWidget, headerLayout.defaultCellSetting().padding(5));
        headerLayout.addChild((LayoutElement)this.titleWidget, headerLayout.defaultCellSetting().padding(5));
        LinearLayout contentLayout = (LinearLayout)layout.addToContents((LayoutElement)LinearLayout.vertical());
        contentLayout.addChild((LayoutElement)this.contentWidget, headerLayout.defaultCellSetting().padding(5));
        LinearLayout footerLayout = (LinearLayout)layout.addToFooter((LayoutElement)LinearLayout.horizontal());
        footerLayout.addChild((LayoutElement)this.prevButton, footerLayout.defaultCellSetting().padding(5));
        footerLayout.addChild((LayoutElement)this.pageNumberWidget, footerLayout.defaultCellSetting().padding(5));
        footerLayout.addChild((LayoutElement)this.iKnowButton, footerLayout.defaultCellSetting().padding(5));
        layout.arrangeElements();
        this.updateUiStatus(this.currentPageIndex);
    }
}

