/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mc_utils;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;

@IPVanillaCopy
public class MyNbtTextFormatter
implements TagVisitor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int field_33271 = 8;
    private static final ByteCollection SINGLE_LINE_ELEMENT_TYPES = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private static final ChatFormatting NAME_COLOR = ChatFormatting.AQUA;
    private static final ChatFormatting STRING_COLOR = ChatFormatting.GREEN;
    private static final ChatFormatting NUMBER_COLOR = ChatFormatting.GOLD;
    private static final ChatFormatting TYPE_SUFFIX_COLOR = ChatFormatting.RED;
    private static final Pattern SIMPLE_NAME = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String KEY_VALUE_SEPARATOR = String.valueOf(':');
    private static final String ENTRY_SEPARATOR = String.valueOf(',');
    private static final String SQUARE_OPEN_BRACKET = "[";
    private static final String SQUARE_CLOSE_BRACKET = "]";
    private static final String SEMICOLON = ";";
    private static final String SPACE = " ";
    private static final String CURLY_OPEN_BRACKET = "{";
    private static final String CURLY_CLOSE_BRACKET = "}";
    private static final String NEW_LINE = "\n";
    private final String prefix;
    private final int indentationLevel;
    private Component result = Component.literal((String)"");

    public MyNbtTextFormatter(String prefix, int indentationLevel) {
        this.prefix = prefix;
        this.indentationLevel = indentationLevel;
    }

    public Component apply(Tag element) {
        element.accept((TagVisitor)this);
        return this.result;
    }

    public void visitString(StringTag element) {
        String string = StringTag.quoteAndEscape((String)element.getAsString());
        String string2 = string.substring(0, 1);
        MutableComponent text = Component.literal((String)string.substring(1, string.length() - 1)).withStyle(STRING_COLOR);
        this.result = Component.literal((String)string2).append((Component)text).append(string2);
    }

    public void visitByte(ByteTag element) {
        if (element.getAsByte() == 0) {
            this.result = Component.literal((String)"false").withStyle(NUMBER_COLOR);
            return;
        }
        if (element.getAsByte() == 1) {
            this.result = Component.literal((String)"true").withStyle(NUMBER_COLOR);
            return;
        }
        MutableComponent text = Component.literal((String)"b").withStyle(TYPE_SUFFIX_COLOR);
        this.result = Component.literal((String)String.valueOf(element.getAsNumber())).append((Component)text).withStyle(NUMBER_COLOR);
    }

    public void visitShort(ShortTag element) {
        MutableComponent text = Component.literal((String)"s").withStyle(TYPE_SUFFIX_COLOR);
        this.result = Component.literal((String)String.valueOf(element.getAsNumber())).append((Component)text).withStyle(NUMBER_COLOR);
    }

    public void visitInt(IntTag element) {
        this.result = Component.literal((String)String.valueOf(element.getAsNumber())).withStyle(NUMBER_COLOR);
    }

    public void visitLong(LongTag element) {
        MutableComponent text = Component.literal((String)"L").withStyle(TYPE_SUFFIX_COLOR);
        this.result = Component.literal((String)String.valueOf(element.getAsNumber())).append((Component)text).withStyle(NUMBER_COLOR);
    }

    public void visitFloat(FloatTag element) {
        MutableComponent text = Component.literal((String)"f").withStyle(TYPE_SUFFIX_COLOR);
        this.result = Component.literal((String)String.valueOf(element.getAsFloat())).append((Component)text).withStyle(NUMBER_COLOR);
    }

    public void visitDouble(DoubleTag element) {
        MutableComponent text = Component.literal((String)"d").withStyle(TYPE_SUFFIX_COLOR);
        this.result = Component.literal((String)String.valueOf(element.getAsDouble())).append((Component)text).withStyle(NUMBER_COLOR);
    }

    public void visitByteArray(ByteArrayTag element) {
        MutableComponent text = Component.literal((String)"B").withStyle(TYPE_SUFFIX_COLOR);
        MutableComponent mutableText = Component.literal((String)SQUARE_OPEN_BRACKET).append((Component)text).append(SEMICOLON);
        byte[] bs = element.getAsByteArray();
        for (int i = 0; i < bs.length; ++i) {
            MutableComponent mutableText2 = Component.literal((String)String.valueOf(bs[i])).withStyle(NUMBER_COLOR);
            mutableText.append(SPACE).append((Component)mutableText2).append((Component)text);
            if (i == bs.length - 1) continue;
            mutableText.append(ENTRY_SEPARATOR);
        }
        mutableText.append(SQUARE_CLOSE_BRACKET);
        this.result = mutableText;
    }

    public void visitIntArray(IntArrayTag element) {
        MutableComponent text = Component.literal((String)"I").withStyle(TYPE_SUFFIX_COLOR);
        MutableComponent mutableText = Component.literal((String)SQUARE_OPEN_BRACKET).append((Component)text).append(SEMICOLON);
        int[] is = element.getAsIntArray();
        for (int i = 0; i < is.length; ++i) {
            mutableText.append(SPACE).append((Component)Component.literal((String)String.valueOf(is[i])).withStyle(NUMBER_COLOR));
            if (i == is.length - 1) continue;
            mutableText.append(ENTRY_SEPARATOR);
        }
        mutableText.append(SQUARE_CLOSE_BRACKET);
        this.result = mutableText;
    }

    public void visitLongArray(LongArrayTag element) {
        MutableComponent text = Component.literal((String)"L").withStyle(TYPE_SUFFIX_COLOR);
        MutableComponent mutableText = Component.literal((String)SQUARE_OPEN_BRACKET).append((Component)text).append(SEMICOLON);
        long[] ls = element.getAsLongArray();
        for (int i = 0; i < ls.length; ++i) {
            MutableComponent text2 = Component.literal((String)String.valueOf(ls[i])).withStyle(NUMBER_COLOR);
            mutableText.append(SPACE).append((Component)text2).append((Component)text);
            if (i == ls.length - 1) continue;
            mutableText.append(ENTRY_SEPARATOR);
        }
        mutableText.append(SQUARE_CLOSE_BRACKET);
        this.result = mutableText;
    }

    public void visitList(ListTag element) {
        if (element.isEmpty()) {
            this.result = Component.literal((String)"[]");
            return;
        }
        if (SINGLE_LINE_ELEMENT_TYPES.contains(element.getElementType()) && element.size() <= 8) {
            String string = ENTRY_SEPARATOR + SPACE;
            MutableComponent mutableText = Component.literal((String)SQUARE_OPEN_BRACKET);
            for (int i = 0; i < element.size(); ++i) {
                if (i != 0) {
                    mutableText.append(string);
                }
                mutableText.append(new MyNbtTextFormatter(this.prefix, this.indentationLevel).apply(element.get(i)));
            }
            mutableText.append(SQUARE_CLOSE_BRACKET);
            this.result = mutableText;
            return;
        }
        MutableComponent string = Component.literal((String)SQUARE_OPEN_BRACKET);
        for (int mutableText = 0; mutableText < element.size(); ++mutableText) {
            MutableComponent i = Component.literal((String)Strings.repeat((String)this.prefix, (int)(this.indentationLevel + 1)));
            i.append(new MyNbtTextFormatter(this.prefix, this.indentationLevel + 1).apply(element.get(mutableText)));
            if (mutableText != element.size() - 1) {
                i.append(ENTRY_SEPARATOR).append(SPACE);
            }
            string.append((Component)i);
        }
        if (!this.prefix.isEmpty()) {
            string.append(NEW_LINE).append(Strings.repeat((String)this.prefix, (int)this.indentationLevel));
        }
        string.append(SQUARE_CLOSE_BRACKET);
        this.result = string;
    }

    public void visitCompound(CompoundTag compound) {
        if (compound.isEmpty()) {
            this.result = Component.literal((String)"{}");
            return;
        }
        MutableComponent mutableText = Component.literal((String)CURLY_OPEN_BRACKET);
        Collection collection = compound.getAllKeys();
        ArrayList list = Lists.newArrayList((Iterable)compound.getAllKeys());
        Collections.sort(list);
        collection = list;
        if (!this.prefix.isEmpty()) {
            mutableText.append(NEW_LINE);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            MutableComponent mutableText2 = Component.literal((String)Strings.repeat((String)this.prefix, (int)(this.indentationLevel + 1))).append(MyNbtTextFormatter.escapeName(string)).append(KEY_VALUE_SEPARATOR).append(SPACE).append(new MyNbtTextFormatter(this.prefix, this.indentationLevel + 1).apply(compound.get(string)));
            if (iterator.hasNext()) {
                mutableText2.append(ENTRY_SEPARATOR).append(this.prefix.isEmpty() ? SPACE : NEW_LINE);
            }
            mutableText.append((Component)mutableText2);
        }
        if (!this.prefix.isEmpty()) {
            mutableText.append(NEW_LINE).append(Strings.repeat((String)this.prefix, (int)this.indentationLevel));
        }
        mutableText.append(CURLY_CLOSE_BRACKET);
        this.result = mutableText;
    }

    protected static Component escapeName(String name) {
        if (SIMPLE_NAME.matcher(name).matches()) {
            return Component.literal((String)name).withStyle(NAME_COLOR);
        }
        String string = StringTag.quoteAndEscape((String)name);
        String string2 = string.substring(0, 1);
        MutableComponent text = Component.literal((String)string.substring(1, string.length() - 1)).withStyle(NAME_COLOR);
        return Component.literal((String)string2).append((Component)text).append(string2);
    }

    public void visitEnd(EndTag element) {
    }
}

