/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat;

import com.mojang.logging.LogUtils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.MyTaskList;

public class IPModInfoChecking {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean IS_TEST = false;
    @Nullable
    private static List<String> incompatibleShaderpacks;
    @Nullable
    private static String lastShaderpackName;

    @Nullable
    public static ImmPtlInfo fetchImmPtlInfoFromInternet() {
        String url = O_O.getImmPtlModInfoUrl();
        if (url == null) {
            LOGGER.info("Not fetching iPortal mod info");
            return null;
        }
        try {
            HttpResponse<String> response = HttpClient.newHttpClient().send(HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", "Immersive Portals mod").build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                LOGGER.error("Failed to fetch iPortal mod info {}", (Object)response.statusCode());
                return null;
            }
            String jsonStr = response.body();
            ImmPtlInfo immPtlInfo = (ImmPtlInfo)Helper.gson.fromJson(jsonStr, ImmPtlInfo.class);
            LOGGER.info("iPortal mod info fetched");
            return immPtlInfo;
        }
        catch (Throwable e) {
            LOGGER.error("Failed to fetch iPortal mod info", e);
            return null;
        }
    }

    public static void initClient() {
        Util.backgroundExecutor().execute(() -> {
            if (!IPGlobal.checkModInfoFromInternet) {
                return;
            }
            ImmPtlInfo immPtlInfo = IPModInfoChecking.fetchImmPtlInfoFromInternet();
            if (immPtlInfo == null) {
                return;
            }
            incompatibleShaderpacks = immPtlInfo.incompatibleShaderpacks;
            List<MutableComponent> severeIncompatWarningText = IPModInfoChecking.getSevereIncompatWarningText(immPtlInfo);
            if (!severeIncompatWarningText.isEmpty()) {
                MutableComponent mutableComponent = severeIncompatWarningText.stream().reduce(Component.empty(), (a, b) -> a.append("\n").append((Component)b));
            }
            IPGlobal.CLIENT_TASK_LIST.addTask(MyTaskList.withDelayCondition(() -> Minecraft.getInstance().level == null, MyTaskList.oneShotTask(() -> {
                MutableComponent text1;
                ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
                if (IPGlobal.enableUpdateNotification && O_O.shouldUpdateImmPtl(immPtlInfo.latestReleaseVersion)) {
                    text1 = Component.translatable((String)"imm_ptl.new_version_available", (Object[])new Object[]{immPtlInfo.latestReleaseVersion});
                    text1.append((Component)McHelper.getLinkText(O_O.getModDownloadLink()));
                    text1.append((Component)Component.literal((String)"  "));
                    text1.append(IPMcHelper.getDisableUpdateCheckText());
                    texts.add(text1);
                }
                if (IPConfig.getConfig().shouldDisplayWarning("preview") && immPtlInfo.previewVersions.contains(O_O.getImmPtlVersionStr())) {
                    text1 = Component.translatable((String)"imm_ptl.preview_warning").append((Component)McHelper.getLinkText(O_O.getIssueLink())).append(" ").append(IPMcHelper.getDisableWarningText("preview"));
                    texts.add(text1);
                }
                texts.addAll(severeIncompatWarningText);
                for (ModIncompatInfo modIncompatInfo : immPtlInfo.incompatible) {
                    if (modIncompatInfo == null || !modIncompatInfo.isModLoadedWithinVersion() || !IPConfig.getConfig().shouldDisplayWarning(modIncompatInfo.modId)) continue;
                    MutableComponent text12 = Component.translatable((String)"imm_ptl.incompatible", (Object[])new Object[]{modIncompatInfo.modName, modIncompatInfo.modId}).withStyle(ChatFormatting.RED).append(IPMcHelper.getDisableWarningText(modIncompatInfo.modId));
                    if (modIncompatInfo.desc != null) {
                        text12.append((Component)Component.literal((String)(" " + modIncompatInfo.desc + " ")));
                    }
                    if (modIncompatInfo.link != null) {
                        text12.append((Component)McHelper.getLinkText(" " + modIncompatInfo.link));
                    }
                    texts.add(text12);
                }
                for (Component component : texts) {
                    CHelper.printChat(component);
                }
            })));
        });
        IPGlobal.CLIENT_TASK_LIST.addTask(MyTaskList.withDelayCondition(() -> Minecraft.getInstance().level == null, MyTaskList.oneShotTask(() -> {
            List topLevelMods;
            if (IPConfig.getConfig().shouldDisplayWarning("many_mods") && FMLEnvironment.production && (topLevelMods = ModList.get().getSortedMods()).size() > 20) {
                CHelper.printChat((Component)Component.literal((String)"[Immersive Portals] WARNING: You are using many mods. It's likely that one of them has compatibility issues with Immersive Portals. If you are sure that there is no compatibility issue, disable this warning.").withStyle(ChatFormatting.RED).append(IPMcHelper.getDisableWarningText("many_mods")));
            }
        })));
    }

    private static List<MutableComponent> getSevereIncompatWarningText(ImmPtlInfo immPtlInfo) {
        ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
        for (ModIncompatInfo info : immPtlInfo.severelyIncompatible) {
            if (info == null || !info.isModLoadedWithinVersion()) continue;
            MutableComponent text1 = info.startVersion != null || info.endVersion != null ? Component.translatable((String)"imm_ptl.severely_incompatible_within_version", (Object[])new Object[]{info.modName, info.modId, info.getVersionRangeStr()}).withStyle(ChatFormatting.RED) : Component.translatable((String)"imm_ptl.severely_incompatible", (Object[])new Object[]{info.modName, info.modId}).withStyle(ChatFormatting.RED);
            if (info.desc != null) {
                text1.append((Component)Component.literal((String)(" " + info.desc + " ")));
            }
            if (info.link != null) {
                text1.append((Component)Component.literal((String)" "));
                text1.append((Component)McHelper.getLinkText(info.link));
            }
            texts.add(text1);
        }
        return texts;
    }

    public static void initDedicatedServer() {
        NeoForge.EVENT_BUS.addListener(ServerStartedEvent.class, event -> {
            MinecraftServer server = event.getServer();
            if (!IPGlobal.checkModInfoFromInternet) {
                return;
            }
            ImmPtlInfo immPtlInfo = IPModInfoChecking.fetchImmPtlInfoFromInternet();
            if (immPtlInfo == null) {
                return;
            }
            ServerTaskList.of(server).addOneShotTask(() -> {
                MutableComponent text1;
                if (IPGlobal.enableUpdateNotification && O_O.shouldUpdateImmPtl(immPtlInfo.latestReleaseVersion)) {
                    LOGGER.info("[Immersive Portals] A new version is available. It is recommended to update to " + immPtlInfo.latestReleaseVersion);
                }
                for (ModIncompatInfo mod : immPtlInfo.severelyIncompatible) {
                    if (mod == null || !mod.isModLoadedWithinVersion()) continue;
                    if (mod.startVersion != null || mod.endVersion != null) {
                        text1 = Component.translatable((String)"imm_ptl.severely_incompatible_within_version", (Object[])new Object[]{mod.modName, mod.modId, mod.getVersionRangeStr()}).withStyle(ChatFormatting.RED);
                        LOGGER.error("[Immersive Portals] Detected an incompatible mod: {} {} version range: {} description: {} link: {}", new Object[]{mod.modName, mod.modId, mod.getVersionRangeStr(), mod.desc, mod.link});
                    } else {
                        text1 = Component.translatable((String)"imm_ptl.severely_incompatible", (Object[])new Object[]{mod.modName, mod.modId}).withStyle(ChatFormatting.RED);
                        LOGGER.error("[Immersive Portals] Detected an incompatible mod: {} {} description: {} link: {}", new Object[]{mod.modName, mod.modId, mod.desc, mod.link});
                    }
                    if (mod.desc != null) {
                        text1.append((Component)Component.literal((String)(" " + mod.desc + " ")));
                    }
                    if (mod.link != null) {
                        text1.append((Component)Component.literal((String)" "));
                        text1.append((Component)McHelper.getLinkText(mod.link));
                    }
                    McHelper.sendMessageToFirstLoggedPlayer(server, (Component)Component.translatable((String)"imm_ptl.message_from_server").append((Component)text1));
                }
                for (ModIncompatInfo mod : immPtlInfo.incompatible) {
                    if (mod == null || !mod.isModLoadedWithinVersion() || !IPConfig.getConfig().shouldDisplayWarning(mod.modId)) continue;
                    text1 = Component.translatable((String)"imm_ptl.incompatible", (Object[])new Object[]{mod.modName, mod.modId}).withStyle(ChatFormatting.RED);
                    if (mod.desc != null) {
                        text1.append((Component)Component.literal((String)(" " + mod.desc + " ")));
                    }
                    if (mod.link != null) {
                        text1.append((Component)McHelper.getLinkText(" " + mod.link));
                    }
                    LOGGER.error("[Immersive Portals] Detected a mildly incompatible mod: {} {} description: {} link: {}", new Object[]{mod.modName, mod.modId, mod.desc, mod.link});
                    McHelper.sendMessageToFirstLoggedPlayer(server, (Component)Component.translatable((String)"imm_ptl.message_from_server").append((Component)text1));
                }
            });
        });
    }

    public static void checkShaderpack() {
        if (!IPConfig.getConfig().shaderpackWarning) {
            return;
        }
        String shaderpackName = IrisInterface.invoker.getShaderpackName();
        if (!Objects.equals(lastShaderpackName, shaderpackName)) {
            boolean incompatible;
            lastShaderpackName = shaderpackName;
            if (shaderpackName != null && incompatibleShaderpacks != null && (incompatible = incompatibleShaderpacks.stream().anyMatch(n -> shaderpackName.toLowerCase().contains(n.toLowerCase())))) {
                CHelper.printChat((Component)Component.translatable((String)"imm_ptl.incompatible_shaderpack").withStyle(ChatFormatting.RED));
            }
        }
    }

    public static final class ImmPtlInfo {
        public String latestReleaseVersion;
        public List<String> previewVersions;
        public List<ModIncompatInfo> severelyIncompatible;
        public List<ModIncompatInfo> incompatible;
        public List<String> incompatibleShaderpacks;

        public ImmPtlInfo(String latestReleaseVersion, List<ModIncompatInfo> severelyIncompatible, List<ModIncompatInfo> incompatible) {
            this.latestReleaseVersion = latestReleaseVersion;
            this.severelyIncompatible = severelyIncompatible;
            this.incompatible = incompatible;
        }

        public String toString() {
            return "ImmPtlInfo{latestReleaseVersion='" + this.latestReleaseVersion + "', severelyIncompatible=" + String.valueOf(this.severelyIncompatible) + ", incompatible=" + String.valueOf(this.incompatible) + "}";
        }
    }

    public record ModIncompatInfo(String modId, String modName, @Nullable String startVersion, @Nullable String endVersion, @Nullable String desc, @Nullable String link) {
        boolean isModLoadedWithinVersion() {
            return O_O.isModLoadedWithinVersion(this.modId, this.startVersion, this.endVersion);
        }

        String getVersionRangeStr() {
            if (this.startVersion != null) {
                if (this.endVersion != null) {
                    return this.startVersion + "-" + this.endVersion;
                }
                return this.startVersion + "+";
            }
            Validate.notNull((Object)this.endVersion, (String)"invalid version range", (Object[])new Object[0]);
            return "-" + this.endVersion;
        }
    }
}

