/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat;

import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.q_misc_util.my_util.DQuaternion;

public class GravityChangerInterface {
    public static Invoker invoker = new Invoker();
    private static boolean warned = false;

    private static void warnGravityChangerNotPresent() {
        if (!warned) {
            warned = true;
            CHelper.printChat((Component)Component.translatable((String)"imm_ptl.missing_gravity_changer").append((Component)McHelper.getLinkText("https://modrinth.com/mod/gravity-api-fork")));
        }
    }

    public static class Invoker {
        public boolean isGravityChangerPresent() {
            return false;
        }

        public Vec3 getEyeOffset(Entity entity) {
            return new Vec3(0.0, (double)entity.getEyeHeight(), 0.0);
        }

        public Direction getGravityDirection(Entity entity) {
            return Direction.DOWN;
        }

        public Direction getBaseGravityDirection(Entity entity) {
            return Direction.DOWN;
        }

        public void setClientPlayerGravityDirection(Player player, Direction direction) {
            GravityChangerInterface.warnGravityChangerNotPresent();
        }

        public void setBaseGravityDirectionServer(Entity entity, Direction direction) {
        }

        @Nullable
        public DQuaternion getExtraCameraRotation(Direction gravityDirection) {
            return null;
        }

        public Vec3 getWorldVelocity(Entity entity) {
            return entity.getDeltaMovement();
        }

        public void setWorldVelocity(Entity entity, Vec3 newVelocity) {
            entity.setDeltaMovement(newVelocity);
        }

        public Vec3 transformPlayerToWorld(Direction gravity, Vec3 vec3d) {
            return vec3d;
        }

        public Vec3 transformWorldToPlayer(Direction gravity, Vec3 vec3d) {
            return vec3d;
        }

        public Direction transformDirPlayerToWorld(Direction gravity, Direction direction) {
            return direction;
        }

        public Direction transformDirWorldToPlayer(Direction gravity, Direction direction) {
            return direction;
        }
    }

    public static class OnGravityChangerPresent
    extends Invoker {
        @Override
        public boolean isGravityChangerPresent() {
            return true;
        }

        @Override
        public Vec3 getEyeOffset(Entity entity) {
            return new Vec3(0.0, (double)entity.getEyeHeight(), 0.0);
        }

        @Override
        public Direction getGravityDirection(Entity entity) {
            return Direction.DOWN;
        }

        @Override
        public Direction getBaseGravityDirection(Entity entity) {
            return Direction.DOWN;
        }

        @Override
        public void setBaseGravityDirectionServer(Entity entity, Direction direction) {
        }

        @Override
        public void setClientPlayerGravityDirection(Player player, Direction direction) {
            this.setClientPlayerGravityDirectionClientOnly(player, direction);
        }

        private void setClientPlayerGravityDirectionClientOnly(Player player, Direction direction) {
        }

        @Override
        @Nullable
        public DQuaternion getExtraCameraRotation(Direction gravityDirection) {
            return null;
        }

        @Override
        public Vec3 getWorldVelocity(Entity entity) {
            return entity.getDeltaMovement();
        }

        @Override
        public void setWorldVelocity(Entity entity, Vec3 newVelocity) {
        }

        @Override
        public Vec3 transformPlayerToWorld(Direction gravity, Vec3 vec3d) {
            return vec3d;
        }

        @Override
        public Vec3 transformWorldToPlayer(Direction gravity, Vec3 vec3d) {
            return vec3d;
        }

        @Override
        public Direction transformDirPlayerToWorld(Direction gravity, Direction direction) {
            return direction;
        }

        @Override
        public Direction transformDirWorldToPlayer(Direction gravity, Direction direction) {
            return direction;
        }
    }
}

