/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.profiling.ActiveProfiler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.example.ExampleGuiPortalRendering;
import qouteall.imm_ptl.core.chunk_loading.ChunkVisibility;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTickets;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTracking;
import qouteall.imm_ptl.core.chunk_loading.PlayerChunkLoading;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.ducks.IEDistanceManager;
import qouteall.imm_ptl.core.ducks.IEServerChunkCache;
import qouteall.imm_ptl.core.ducks.IEServerWorld;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.mixin.common.chunk_sync.IEChunkMap_Accessor;
import qouteall.imm_ptl.core.mixin.common.mc_util.IELevelEntityGetterAdapter;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.shape.PortalShape;
import qouteall.imm_ptl.core.portal.shape.SpecialFlatPortalShape;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.MyTaskList;

public class PortalDebugCommands {
    private static final Logger LOGGER = LogUtils.getLogger();

    static void registerDebugCommands(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.literal((String)"gui_portal").then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3((boolean)false)).executes(context -> {
            ExampleGuiPortalRendering.onCommandExecuted(((CommandSourceStack)context.getSource()).getPlayerOrException(), DimensionArgument.getDimension((CommandContext)context, (String)"dim"), Vec3Argument.getVec3((CommandContext)context, (String)"pos"));
            return 0;
        }))));
        builder.then(Commands.literal((String)"isometric_enable").then(Commands.argument((String)"viewLength", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            float viewLength = FloatArgumentType.getFloat((CommandContext)context, (String)"viewLength");
            Validate.isTrue(((double)Math.abs(viewLength) > 0.1 ? 1 : 0) != 0);
            McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.render.TransformationManager.RemoteCallables.enableIsometricView", Float.valueOf(viewLength));
            return 0;
        })));
        builder.then(Commands.literal((String)"isometric_disable").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.render.TransformationManager.RemoteCallables.disableIsometricView", new Object[0]);
            return 0;
        }));
        builder.then(Commands.literal((String)"align").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            Vec3 pos = player.position();
            Vec3 newPos = new Vec3((double)Math.round(pos.x * 2.0) / 2.0, (double)Math.round(pos.y * 2.0) / 2.0, (double)Math.round(pos.z * 2.0) / 2.0);
            player.connection.teleport(newPos.x, newPos.y, newPos.z, 45.0f, 30.0f);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"profile").then(((LiteralArgumentBuilder)Commands.literal((String)"set_lag_logging_threshold").requires(serverCommandSource -> serverCommandSource.hasPermission(4))).then(Commands.argument((String)"ms", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int ms = IntegerArgumentType.getInteger((CommandContext)context, (String)"ms");
            ActiveProfiler.WARNING_TIME_NANOS = Duration.ofMillis(ms).toNanos();
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"gc").requires(serverCommandSource -> serverCommandSource.hasPermission(4))).executes(context -> {
            System.gc();
            long l = Runtime.getRuntime().maxMemory();
            long m = Runtime.getRuntime().totalMemory();
            long n = Runtime.getRuntime().freeMemory();
            long o = m - n;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("Memory: % 2d%% %03d/%03dMB", o * 100L / l, PortalDebugCommands.toMiB(o), PortalDebugCommands.toMiB(l))), false);
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"create_command_stick").requires(serverCommandSource -> serverCommandSource.hasPermission(2))).then(Commands.argument((String)"command", (ArgumentType)StringArgumentType.string()).executes(context -> {
            PortalCommand.createCommandStickCommandSignal.emit(((CommandSourceStack)context.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)context, (String)"command"));
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"accelerate").requires(PortalCommand::canUsePortalCommand)).then(Commands.argument((String)"v", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            double v = DoubleArgumentType.getDouble((CommandContext)context, (String)"v");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            Vec3 vec = player.getViewVector(1.0f).scale(v / 20.0);
            McRemoteProcedureCall.tellClientToInvoke(((CommandSourceStack)context.getSource()).getPlayerOrException(), "qouteall.imm_ptl.core.commands.PortalCommand.RemoteCallables.clientAccelerate", vec);
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"accelerate_along").requires(PortalCommand::canUsePortalCommand)).then(Commands.argument((String)"vec", (ArgumentType)Vec3Argument.vec3((boolean)false)).executes(context -> {
            Vec3 vec = Vec3Argument.getVec3((CommandContext)context, (String)"vec");
            McRemoteProcedureCall.tellClientToInvoke(((CommandSourceStack)context.getSource()).getPlayerOrException(), "qouteall.imm_ptl.core.commands.PortalCommand.RemoteCallables.clientAccelerate", vec.scale(0.05));
            return 0;
        })));
        builder.then(Commands.literal((String)"test").executes(context -> 0));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"erase_chunk").requires(serverCommandSource -> serverCommandSource.hasPermission(3))).then(((RequiredArgumentBuilder)Commands.argument((String)"rChunks", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ChunkPos center = new ChunkPos(BlockPos.containing((Position)player.position()));
            PortalDebugCommands.invokeEraseChunk(player.level(), center, IntegerArgumentType.getInteger((CommandContext)context, (String)"rChunks"), McHelper.getMinY((LevelAccessor)player.level()), McHelper.getMaxYExclusive((LevelAccessor)player.level()));
            return 0;
        })).then(Commands.argument((String)"downY", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"upY", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ChunkPos center = new ChunkPos(BlockPos.containing((Position)player.position()));
            PortalDebugCommands.invokeEraseChunk(player.level(), center, IntegerArgumentType.getInteger((CommandContext)context, (String)"rChunks"), IntegerArgumentType.getInteger((CommandContext)context, (String)"downY"), IntegerArgumentType.getInteger((CommandContext)context, (String)"upY"));
            return 0;
        })))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"report_chunk_loaders").requires(serverCommandSource -> serverCommandSource.hasPermission(3))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ChunkVisibility.foreachBaseChunkLoaders(player, loader -> McHelper.serverLog(player, loader.toString()));
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"report_server_entities_nearby").requires(serverCommandSource -> serverCommandSource.hasPermission(3))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            List entities = player.level().getEntitiesOfClass(Entity.class, new AABB(player.position(), player.position()).inflate(32.0), e -> true);
            McHelper.serverLog(player, entities.stream().map(Entity::toString).collect(Collectors.joining("\n")));
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"report_loaded_portals").requires(serverCommandSource -> serverCommandSource.hasPermission(3))).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            MinecraftServer server = source.getServer();
            for (ServerLevel world : server.getAllLevels()) {
                for (Entity entity : world.getAllEntities()) {
                    if (!(entity instanceof Portal)) continue;
                    Portal portal = (Portal)entity;
                    source.sendSuccess(() -> Component.literal((String)entity.toString()), true);
                }
            }
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"is_chunk_loaded").requires(serverCommandSource -> serverCommandSource.hasPermission(2))).then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"chunkX", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"chunkZ", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int chunkX = IntegerArgumentType.getInteger((CommandContext)context, (String)"chunkX");
            int chunkZ = IntegerArgumentType.getInteger((CommandContext)context, (String)"chunkZ");
            ServerLevel world = DimensionArgument.getDimension((CommandContext)context, (String)"dim");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            PortalDebugCommands.doReportChunkStatus(chunkX, chunkZ, world, player);
            return 0;
        })))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"report_chunk_at").requires(serverCommandSource -> serverCommandSource.hasPermission(2))).then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            ServerLevel world = DimensionArgument.getDimension((CommandContext)context, (String)"dim");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            BlockPos pos = BlockPosArgument.getBlockPos((CommandContext)context, (String)"pos");
            ChunkPos chunkPos = new ChunkPos(pos);
            PortalDebugCommands.doReportChunkStatus(chunkPos.x, chunkPos.z, world, player);
            return 0;
        }))));
        builder.then(Commands.literal((String)"report_player_status").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            CHelper.printChat(String.format("On Server %s %s removal:%s added:%s age:%s", player.level().dimension().location(), player.blockPosition(), player.getRemovalReason(), player.level().getEntity(player.getId()) != null, player.tickCount));
            McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.reportClientPlayerStatus", new Object[0]);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"list_portals").requires(serverCommandSource -> serverCommandSource.hasPermission(3))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            StringBuilder result = new StringBuilder();
            result.append("Server Portals\n");
            for (ServerLevel world : MiscHelper.getServer().getAllLevels()) {
                result.append(String.valueOf(world.dimension().location()) + "\n");
                for (Entity entity : world.getAllEntities()) {
                    for (Entity e : world.getAllEntities()) {
                        if (!(e instanceof Portal)) continue;
                        result.append(e);
                        result.append("\n");
                    }
                }
            }
            McHelper.serverLog(player, result.toString());
            McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.doListPortals", new Object[0]);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"report_resource_consumption").requires(serverCommandSource -> serverCommandSource.hasPermission(2))).executes(context -> {
            StringBuilder str = new StringBuilder();
            str.append("Server Tracked Chunks:\n");
            MiscHelper.getServer().getAllLevels().forEach(world -> str.append(PortalDebugCommands.getServerWorldResourceConsumption(world)));
            McHelper.serverLog(((CommandSourceStack)context.getSource()).getPlayerOrException(), str.toString());
            McRemoteProcedureCall.tellClientToInvoke(((CommandSourceStack)context.getSource()).getPlayerOrException(), "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.reportResourceConsumption", new Object[0]);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"report_chunk_ticket_stat").requires(serverCommandSource -> serverCommandSource.hasPermission(2))).executes(context -> {
            ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
            Iterable<ChunkHolder> chunkHolders = ((IEChunkMap_Accessor)world.getChunkSource().chunkMap).ip_getChunks();
            Object2IntOpenHashMap stat = new Object2IntOpenHashMap();
            for (ChunkHolder chunkHolder : chunkHolders) {
                long chunkPos = chunkHolder.getPos().toLong();
                SortedArraySet<Ticket<?>> chunkTickets = ((IEDistanceManager)ImmPtlChunkTickets.getDistanceManager(world)).portal_getTicketSet(chunkPos);
                for (Ticket ticket : chunkTickets) {
                    stat.addTo((Object)ticket.getType(), 1);
                }
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)""), false);
            for (Object2IntMap.Entry entry : stat.object2IntEntrySet()) {
                TicketType ticketType = (TicketType)entry.getKey();
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(ticketType.toString() + " " + entry.getIntValue())), false);
            }
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"report_per_player_chunk_loading").requires(serverCommandSource -> serverCommandSource.hasPermission(2))).executes(context -> {
            List players = MiscHelper.getServer().getPlayerList().getPlayers();
            for (ServerPlayer player : players) {
                PlayerChunkLoading playerInfo = ImmPtlChunkTracking.getPlayerInfo(player);
                String text = "%s %d".formatted(player.getName().getString(), playerInfo.loadedChunks);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)text), true);
            }
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"save_all_chunks").requires(serverCommandSource -> serverCommandSource.hasPermission(2))).executes(context -> {
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            server.saveAllChunks(true, true, false);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"simplify_portal_mesh").requires(serverCommandSource -> serverCommandSource.hasPermission(2))).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalShape portalShape = portal.getPortalShape();
            if (portalShape instanceof SpecialFlatPortalShape) {
                SpecialFlatPortalShape s = (SpecialFlatPortalShape)portalShape;
                s.mesh.simplifySteps(1);
                portal.reloadPortal();
            }
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"check_biome_registry").requires(serverCommandSource -> serverCommandSource.hasPermission(3))).executes(context -> {
            RegistryAccess.Frozen registryAccess = MiscHelper.getServer().registryAccess();
            Registry biomes = registryAccess.registryOrThrow(Registries.BIOME);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Map.Entry entry : biomes.entrySet()) {
                String strId = ((ResourceKey)entry.getKey()).location().toString();
                int intId = biomes.getId((Object)((Biome)entry.getValue()));
                map.put(strId, intId);
            }
            McRemoteProcedureCall.tellClientToInvoke(((CommandSourceStack)context.getSource()).getPlayerOrException(), "qouteall.imm_ptl.core.ClientWorldLoader.RemoteCallables.checkBiomeRegistry", map);
            return 0;
        }));
        builder.then(Commands.literal((String)"nofog_enable").executes(context -> {
            McRemoteProcedureCall.tellClientToInvoke(((CommandSourceStack)context.getSource()).getPlayerOrException(), "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.setNoFog", true);
            return 0;
        }));
        builder.then(Commands.literal((String)"nofog_disable").executes(context -> {
            McRemoteProcedureCall.tellClientToInvoke(((CommandSourceStack)context.getSource()).getPlayerOrException(), "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.setNoFog", false);
            return 0;
        }));
        builder.then(Commands.literal((String)"report_air").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            BlockState blockState = player.level().getBlockState(player.blockPosition());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> blockState.getBlock().getName(), false);
            return 0;
        }));
        builder.then(Commands.literal((String)"test_invalid_rpc").executes(context -> {
            McRemoteProcedureCall.tellClientToInvoke(((CommandSourceStack)context.getSource()).getPlayerOrException(), "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.testInvalidRPC", new Object[0]);
            return 0;
        }));
    }

    private static void doReportChunkStatus(int chunkX, int chunkZ, ServerLevel world, ServerPlayer player) {
        LevelChunk chunk = McHelper.getServerChunkIfPresent(world, chunkX, chunkZ);
        boolean loaded = chunk != null && !(chunk instanceof EmptyLevelChunk);
        long longChunkPos = ChunkPos.asLong((int)chunkX, (int)chunkZ);
        if (loaded) {
            boolean shouldTickEntities = ImmPtlChunkTickets.getDistanceManager(world).inEntityTickingRange(longChunkPos);
            if (shouldTickEntities) {
                McHelper.serverLog(player, "Server chunk loaded and entity tickable");
            } else {
                McHelper.serverLog(player, "Server chunk loaded but entity not tickable");
            }
        } else {
            McHelper.serverLog(player, "Server chunk not loaded");
        }
        ChunkHolder chunkHolder = McHelper.getIEChunkMap((ResourceKey<Level>)world.dimension()).ip_getChunkHolder(longChunkPos);
        if (chunkHolder == null) {
            McHelper.serverLog(player, "no chunk holder");
        } else {
            McHelper.serverLog(player, String.format("chunk holder level:%s %s", chunkHolder.getTicketLevel(), chunk == null ? "" : chunk.getFullStatus()));
            DistanceManager distanceManager = ((IEServerChunkCache)world.getChunkSource()).ip_getDistanceManager();
            SortedArraySet<Ticket<?>> tickets = ((IEDistanceManager)distanceManager).portal_getTicketSet(longChunkPos);
            for (Ticket ticket : tickets) {
                McHelper.serverLog(player, ticket.toString());
            }
        }
        McRemoteProcedureCall.tellClientToInvoke(player, "qouteall.imm_ptl.core.commands.ClientDebugCommand.RemoteCallables.reportClientChunkLoadStatus", world.dimension(), chunkX, chunkZ);
    }

    public static String getServerWorldResourceConsumption(ServerLevel world) {
        StringBuilder subStr = new StringBuilder();
        ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
        LevelEntityGetter<Entity> entityLookup = ((IEWorld)world).portal_getEntityLookup();
        subStr.append(String.format("%s:\nImmPtl Tracked Chunks: %s\nImmPtl Loading Ticket:%s\nChunks: %s\nEntities:%s Entity Sections:%s\n", world.dimension().location(), ImmPtlChunkTracking.getLoadedChunkNum((ResourceKey<Level>)world.dimension()), dimTicketManager.getLoadedChunkNum(), world.getChunkSource().chunkMap.size(), ((IELevelEntityGetterAdapter)entityLookup).getIndex().count(), ((IELevelEntityGetterAdapter)entityLookup).getCache().count()));
        PersistentEntitySectionManager<Entity> entityManager = ((IEServerWorld)world).ip_getEntityManager();
        entityManager.saveAll();
        subStr.append(String.format("Entity Manager: %s\n", entityManager.gatherStats()));
        subStr.append("\n");
        String result = subStr.toString();
        return result;
    }

    public static long toMiB(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public static void invokeEraseChunk(Level world, ChunkPos center, int r, int downY, int upY) {
        ArrayList<ChunkPos> poses = new ArrayList<ChunkPos>();
        for (int x = -r; x <= r; ++x) {
            for (int z = -r; z <= r; ++z) {
                poses.add(new ChunkPos(x + center.x, z + center.z));
            }
        }
        poses.sort(Comparator.comparingDouble(c -> Vec3.atLowerCornerOf((Vec3i)center.getWorldPosition()).distanceTo(Vec3.atLowerCornerOf((Vec3i)c.getWorldPosition()))));
        ServerTaskList.of(world.getServer()).addTask(MyTaskList.chainTasks(poses.stream().map(chunkPos -> () -> {
            PortalDebugCommands.eraseChunk(chunkPos, world, downY, upY);
            return true;
        }).iterator()));
    }

    public static void eraseChunk(ChunkPos chunkPos, Level world, int yStart, int yEnd) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = yStart; y < yEnd; ++y) {
                    world.setBlockAndUpdate(new BlockPos(chunkPos.getMinBlockX() + x, y, chunkPos.getMinBlockZ() + z), Blocks.AIR.defaultBlockState());
                }
            }
        }
    }
}

