/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.commands.AxisArgumentType;
import qouteall.imm_ptl.core.commands.PortalAnimationCommand;
import qouteall.imm_ptl.core.commands.PortalDebugCommands;
import qouteall.imm_ptl.core.commands.SubCommandArgumentType;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.PortalUtils;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.global_portals.BorderBarrierFiller;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.imm_ptl.core.portal.global_portals.WorldWrappingPortal;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalMatcher;
import qouteall.imm_ptl.core.portal.shape.BoxPortalShape;
import qouteall.imm_ptl.core.portal.shape.PortalShape;
import qouteall.imm_ptl.core.portal.shape.SpecialFlatPortalShape;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.GeometryUtil;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.Mesh2D;
import qouteall.q_misc_util.my_util.MyTaskList;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.RayTraceResult;
import qouteall.q_misc_util.my_util.SignalBiArged;
import qouteall.q_misc_util.my_util.Vec2d;
import qouteall.q_misc_util.my_util.WithDim;

public class PortalCommand {
    public static final SignalBiArged<ServerPlayer, String> createCommandStickCommandSignal = new SignalBiArged();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext ctx) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"portal").requires(PortalCommand::canUsePortalCommand);
        PortalCommand.registerPortalTargetedCommands((LiteralArgumentBuilder<CommandSourceStack>)builder, ctx);
        LiteralArgumentBuilder animation = Commands.literal((String)"animation");
        PortalAnimationCommand.registerPortalAnimationCommands((LiteralArgumentBuilder<CommandSourceStack>)animation);
        builder.then((ArgumentBuilder)animation);
        PortalCommand.registerCBPortalCommands((LiteralArgumentBuilder<CommandSourceStack>)builder);
        PortalCommand.registerUtilityCommands((LiteralArgumentBuilder<CommandSourceStack>)builder);
        LiteralArgumentBuilder global = (LiteralArgumentBuilder)Commands.literal((String)"global").requires(commandSource -> commandSource.hasPermission(2));
        PortalCommand.registerGlobalPortalCommands((LiteralArgumentBuilder<CommandSourceStack>)global);
        builder.then((ArgumentBuilder)global);
        LiteralArgumentBuilder debugBuilder = (LiteralArgumentBuilder)Commands.literal((String)"debug").requires(PortalCommand::canUsePortalCommand);
        PortalDebugCommands.registerDebugCommands((LiteralArgumentBuilder<CommandSourceStack>)debugBuilder);
        builder.then((ArgumentBuilder)debugBuilder);
        LiteralArgumentBuilder euler = Commands.literal((String)"euler");
        PortalCommand.registerEulerCommands((LiteralArgumentBuilder<CommandSourceStack>)euler);
        builder.then((ArgumentBuilder)euler);
        dispatcher.register(builder);
    }

    public static boolean canUsePortalCommand(CommandSourceStack commandSource) {
        Entity entity = commandSource.getEntity();
        if (entity instanceof ServerPlayer && IPGlobal.easeCreativePermission && ((ServerPlayer)entity).isCreative()) {
            return true;
        }
        return commandSource.hasPermission(2);
    }

    private static void registerGlobalPortalCommands(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.literal((String)"create_inward_wrapping").then(Commands.argument((String)"p1", (ArgumentType)ColumnPosArgument.columnPos()).then(Commands.argument((String)"p2", (ArgumentType)ColumnPosArgument.columnPos()).executes(context -> {
            ColumnPos p1 = ColumnPosArgument.getColumnPos((CommandContext)context, (String)"p1");
            ColumnPos p2 = ColumnPosArgument.getColumnPos((CommandContext)context, (String)"p2");
            WorldWrappingPortal.invokeAddWrappingZone(((CommandSourceStack)context.getSource()).getLevel(), p1.x(), p1.z(), p2.x(), p2.z(), true, text -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> text, false));
            return 0;
        }))));
        builder.then(Commands.literal((String)"create_outward_wrapping").then(Commands.argument((String)"p1", (ArgumentType)ColumnPosArgument.columnPos()).then(Commands.argument((String)"p2", (ArgumentType)ColumnPosArgument.columnPos()).executes(context -> {
            ColumnPos p1 = ColumnPosArgument.getColumnPos((CommandContext)context, (String)"p1");
            ColumnPos p2 = ColumnPosArgument.getColumnPos((CommandContext)context, (String)"p2");
            WorldWrappingPortal.invokeAddWrappingZone(((CommandSourceStack)context.getSource()).getLevel(), p1.x(), p1.z(), p2.x(), p2.z(), false, text -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> text, false));
            return 0;
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"remove_wrapping_zone").executes(context -> {
            WorldWrappingPortal.invokeRemoveWrappingZone(((CommandSourceStack)context.getSource()).getLevel(), ((CommandSourceStack)context.getSource()).getPosition(), text -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> text, false));
            return 0;
        })).then(Commands.argument((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int id = IntegerArgumentType.getInteger((CommandContext)context, (String)"id");
            WorldWrappingPortal.invokeRemoveWrappingZone(((CommandSourceStack)context.getSource()).getLevel(), id, text -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> text, false));
            return 0;
        })));
        builder.then(Commands.literal((String)"view_wrapping_zones").executes(context -> {
            WorldWrappingPortal.invokeViewWrappingZones(((CommandSourceStack)context.getSource()).getLevel(), text -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> text, false));
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"clear_wrapping_border").executes(context -> {
            BorderBarrierFiller.onCommandExecuted(((CommandSourceStack)context.getSource()).getPlayerOrException());
            return 0;
        })).then(Commands.argument((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int id = IntegerArgumentType.getInteger((CommandContext)context, (String)"id");
            BorderBarrierFiller.onCommandExecuted(((CommandSourceStack)context.getSource()).getPlayerOrException(), id);
            return 0;
        })));
        builder.then(Commands.literal((String)"connect_floor").then(Commands.argument((String)"from", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"to", (ArgumentType)DimensionArgument.dimension()).executes(context -> {
            ResourceKey from = DimensionArgument.getDimension((CommandContext)context, (String)"from").dimension();
            ResourceKey to = DimensionArgument.getDimension((CommandContext)context, (String)"to").dimension();
            VerticalConnectingPortal.connect((ResourceKey<Level>)from, VerticalConnectingPortal.ConnectorType.floor, (ResourceKey<Level>)to);
            return 0;
        }))));
        builder.then(Commands.literal((String)"connect_ceil").then(Commands.argument((String)"from", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"to", (ArgumentType)DimensionArgument.dimension()).executes(context -> {
            ResourceKey from = DimensionArgument.getDimension((CommandContext)context, (String)"from").dimension();
            ResourceKey to = DimensionArgument.getDimension((CommandContext)context, (String)"to").dimension();
            VerticalConnectingPortal.connect((ResourceKey<Level>)from, VerticalConnectingPortal.ConnectorType.ceil, (ResourceKey<Level>)to);
            return 0;
        }))));
        builder.then(Commands.literal((String)"connection_floor_remove").then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).executes(context -> {
            ResourceKey dim = DimensionArgument.getDimension((CommandContext)context, (String)"dim").dimension();
            VerticalConnectingPortal.removeConnectingPortal(VerticalConnectingPortal.ConnectorType.floor, (ResourceKey<Level>)dim);
            return 0;
        })));
        builder.then(Commands.literal((String)"connection_ceil_remove").then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).executes(context -> {
            ResourceKey dim = DimensionArgument.getDimension((CommandContext)context, (String)"dim").dimension();
            VerticalConnectingPortal.removeConnectingPortal(VerticalConnectingPortal.ConnectorType.ceil, (ResourceKey<Level>)dim);
            return 0;
        })));
        builder.then(Commands.literal((String)"view_global_portals").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, Helper.myToString(GlobalPortalStorage.getGlobalPortals(player.level()).stream()));
            return 0;
        }));
        builder.then(Commands.literal((String)"convert_normal_portal_to_global_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, GlobalPortalStorage::convertNormalPortalIntoGlobalPortal)));
        builder.then(Commands.literal((String)"convert_global_portal_to_normal_portal").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            Portal portal = PortalCommand.getPlayerPointingPortal(player, true);
            if (portal == null) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"You are not pointing to any portal"), false);
                return 0;
            }
            if (!portal.getIsGlobal()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"You are not pointing to a global portal"), false);
                return 0;
            }
            if (player.position().distanceTo(portal.getOriginPos()) > 64.0) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("You are too far away from the portal's center " + String.valueOf(portal))), false);
                return 0;
            }
            GlobalPortalStorage.convertGlobalPortalIntoNormalPortal(portal);
            return 0;
        }));
        builder.then(Commands.literal((String)"delete_global_portal").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            Portal portal = PortalCommand.getPlayerPointingPortal(player, true);
            if (portal == null) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"You are not pointing to any portal"), false);
                return 0;
            }
            if (!portal.getIsGlobal()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"You are not pointing to a global portal"), false);
                return 0;
            }
            GlobalPortalStorage.get((ServerLevel)portal.level()).removePortal(portal);
            return 0;
        }));
    }

    private static void registerPortalTargetedCommands(LiteralArgumentBuilder<CommandSourceStack> builder, CommandBuildContext ctx) {
        builder.then(Commands.literal((String)"view_portal_data").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.sendPortalInfo((CommandContext<CommandSourceStack>)context, portal))));
        builder.then(Commands.literal((String)"set_portal_custom_name").then(Commands.argument((String)"name", (ArgumentType)ComponentArgument.textComponent((CommandBuildContext)ctx)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Component name = ComponentArgument.getComponent((CommandContext)context, (String)"name");
            portal.setCustomName(name);
        }))));
        builder.then(Commands.literal((String)"delete_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "deleted " + String.valueOf(portal));
            portal.remove(Entity.RemovalReason.KILLED);
        })));
        builder.then(Commands.literal((String)"set_portal_nbt").then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            CompoundTag newNbt = CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt");
            PortalCommand.invokeSetPortalNbt((CommandContext<CommandSourceStack>)context, portal, newNbt);
        }))));
        builder.then(Commands.literal((String)"nbt").then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            CompoundTag newNbt = CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt");
            PortalCommand.invokeSetPortalNbt((CommandContext<CommandSourceStack>)context, portal, newNbt);
        }))));
        builder.then(Commands.literal((String)"set_portal_destination").then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"dest", (ArgumentType)Vec3Argument.vec3((boolean)false)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalCommand.sendEditBiWayPortalWarning((CommandContext<CommandSourceStack>)context, portal);
            portal.setDestDim((ResourceKey<Level>)DimensionArgument.getDimension((CommandContext)context, (String)"dim").dimension());
            portal.setDestination(Vec3Argument.getVec3((CommandContext)context, (String)"dest"));
            PortalCommand.reloadPortal(portal);
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, portal.toString());
        })))));
        PortalCommand.registerPortalTargetedCommandWithRotationArgument(builder, "set_portal_rotation", (p, r) -> p.setRotation((DQuaternion)r));
        PortalCommand.registerPortalTargetedCommandWithRotationArgument(builder, "rotate_portal_body", (p, r) -> {
            if (r != null) {
                PortalManipulation.rotatePortalBody(p, r);
            }
        });
        PortalCommand.registerPortalTargetedCommandWithRotationArgument(builder, "rotate_portal_rotation", (portal, rot) -> {
            if (rot != null) {
                DQuaternion rotation = portal.getRotation();
                if (rotation == null) {
                    portal.setRotation((DQuaternion)rot);
                } else {
                    portal.setRotation(rotation.hamiltonProduct((DQuaternion)rot));
                }
            }
        });
        builder.then(Commands.literal((String)"complete_bi_way_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.invokeCompleteBiWayPortal((CommandContext<CommandSourceStack>)context, portal))));
        builder.then(Commands.literal((String)"complete_bi_faced_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.invokeCompleteBiFacedPortal((CommandContext<CommandSourceStack>)context, portal))));
        builder.then(Commands.literal((String)"complete_bi_way_bi_faced_portal").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.invokeCompleteBiWayBiFacedPortal((CommandContext<CommandSourceStack>)context, portal))));
        builder.then(Commands.literal((String)"remove_connected_portals").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalExtension.get((Portal)portal).bindCluster = false;
            PortalCommand.reloadPortal(portal);
            PortalManipulation.removeConnectedPortals(portal, p -> PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "Removed " + String.valueOf(p)));
        })));
        builder.then(Commands.literal((String)"eradicate_portal_clutter").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalManipulation.removeConnectedPortals(portal, p -> PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "Removed " + String.valueOf(p)));
            portal.remove(Entity.RemovalReason.KILLED);
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "Deleted " + String.valueOf(portal));
        })));
        builder.then(Commands.literal((String)"eradicate_portal_cluster").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            HashSet<Portal> removed = new HashSet<Portal>();
            PortalManipulation.removeConnectedPortals(portal, removed::add);
            portal.remove(Entity.RemovalReason.KILLED);
            removed.add(portal);
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "Deleted %d portal entities".formatted(removed.size()));
        })));
        builder.then(Commands.literal((String)"move_portal").then(Commands.argument((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            try {
                PortalCommand.sendEditBiWayPortalWarning((CommandContext<CommandSourceStack>)context, portal);
                double distance = DoubleArgumentType.getDouble((CommandContext)context, (String)"distance");
                ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
                Vec3 viewVector = player.getLookAngle();
                Direction facing = Direction.getNearest((double)viewVector.x, (double)viewVector.y, (double)viewVector.z);
                Vec3 offset = Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale(distance);
                portal.setPos(portal.getX() + offset.x, portal.getY() + offset.y, portal.getZ() + offset.z);
                PortalCommand.reloadPortal(portal);
            }
            catch (CommandSyntaxException e) {
                PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "This command can only be invoked by player");
            }
        }))));
        builder.then(Commands.literal((String)"move_portal_destination").then(Commands.argument((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            try {
                PortalCommand.sendEditBiWayPortalWarning((CommandContext<CommandSourceStack>)context, portal);
                double distance = DoubleArgumentType.getDouble((CommandContext)context, (String)"distance");
                ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
                Vec3 viewVector = player.getLookAngle();
                Direction facing = Direction.getNearest((double)viewVector.x, (double)viewVector.y, (double)viewVector.z);
                Vec3 offset = Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale(distance);
                portal.setDestination(portal.getDestPos().add(portal.transformLocalVecNonScale(offset)));
                PortalCommand.reloadPortal(portal);
            }
            catch (CommandSyntaxException e) {
                PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "This command can only be invoked by player");
            }
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"set_portal_specific_accessor").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.removeSpecificAccessor((CommandContext<CommandSourceStack>)context, portal)))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.setSpecificAccessor((CommandContext<CommandSourceStack>)context, portal, EntityArgument.getEntity((CommandContext)context, (String)"player"))))));
        builder.then(Commands.literal((String)"multidest").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.removeMultidestEntry((CommandContext<CommandSourceStack>)context, portal, EntityArgument.getPlayer((CommandContext)context, (String)"player"))))).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"destination", (ArgumentType)Vec3Argument.vec3((boolean)false)).then(Commands.argument((String)"isBiFaced", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"isBiWay", (ArgumentType)BoolArgumentType.bool()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.setMultidestEntry((CommandContext<CommandSourceStack>)context, portal, EntityArgument.getPlayer((CommandContext)context, (String)"player"), (ResourceKey<Level>)DimensionArgument.getDimension((CommandContext)context, (String)"dimension").dimension(), Vec3Argument.getVec3((CommandContext)context, (String)"destination"), BoolArgumentType.getBool((CommandContext)context, (String)"isBiFaced"), BoolArgumentType.getBool((CommandContext)context, (String)"isBiWay"))))))))));
        builder.then(Commands.literal((String)"make_portal_round").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalManipulation.makePortalRound(portal, 30);
            PortalCommand.reloadPortal(portal);
        })));
        builder.then(Commands.literal((String)"set_portal_scale").then(Commands.argument((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            portal.setScaling(scale);
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(Commands.literal((String)"multiply_portal_scale").then(Commands.argument((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            portal.setScaling(portal.getScaling() * scale);
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(Commands.literal((String)"divide_portal_scale").then(Commands.argument((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            portal.setScaling(portal.getScaling() / scale);
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(Commands.literal((String)"set_portal_destination_to").then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Entity entity = EntityArgument.getEntity((CommandContext)context, (String)"entity");
            portal.setDestDim((ResourceKey<Level>)entity.level().dimension());
            portal.setDestination(entity.position());
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(Commands.literal((String)"set_portal_position").then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3((boolean)false)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            ServerLevel targetWorld = DimensionArgument.getDimension((CommandContext)context, (String)"dim");
            Vec3 pos = Vec3Argument.getVec3((CommandContext)context, (String)"pos");
            if (targetWorld == portal.level()) {
                portal.setOriginPos(pos);
                PortalCommand.reloadPortal(portal);
            } else {
                ServerTeleportationManager.teleportEntityGeneral(portal, pos, targetWorld);
            }
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, portal.toString());
        })))));
        builder.then(Commands.literal((String)"set_portal_position_to").then(Commands.argument((String)"targetEntity", (ArgumentType)EntityArgument.entity()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Entity targetEntity = EntityArgument.getEntity((CommandContext)context, (String)"targetEntity");
            if (targetEntity.level() == portal.level()) {
                portal.setOriginPos(targetEntity.position());
                PortalCommand.reloadPortal(portal);
            } else {
                ServerTeleportationManager.teleportEntityGeneral(portal, targetEntity.position(), (ServerLevel)targetEntity.level());
            }
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, portal.toString());
        }))));
        builder.then(Commands.literal((String)"reset_portal_orientation").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            UnilateralPortalState thisSideState = portal.getThisSideState();
            portal.setThisSideState(new UnilateralPortalState.Builder().from(thisSideState).orientation(DQuaternion.identity).build());
            PortalCommand.reloadPortal(portal);
        })));
        builder.then(Commands.literal((String)"relatively_move_portal").then(Commands.argument((String)"offset", (ArgumentType)Vec3Argument.vec3((boolean)false)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Vec3 offset = Vec3Argument.getVec3((CommandContext)context, (String)"offset");
            Vec3 offsetTransformed = portal.transformLocalVec(offset);
            portal.setOriginPos(portal.getOriginPos().add(offsetTransformed));
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(Commands.literal((String)"relatively_move_portal_destination").then(Commands.argument((String)"offset", (ArgumentType)Vec3Argument.vec3((boolean)false)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Vec3 offset = Vec3Argument.getVec3((CommandContext)context, (String)"offset");
            portal.setDestination(portal.getDestPos().add(portal.transformLocalVec(portal.getAxisW()).scale(offset.x)).add(portal.transformLocalVec(portal.getAxisH()).scale(offset.y)).add(portal.transformLocalVec(portal.getNormal()).scale(offset.z)));
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(Commands.literal((String)"set_portal_size").then(Commands.argument((String)"width", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(Commands.argument((String)"height", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            portal.setWidth(width);
            portal.setHeight(height);
            portal.setPortalShapeToDefault();
            PortalCommand.reloadPortal(portal);
        })))));
        builder.then(Commands.literal((String)"adjust_portal_to_fit_square_frame").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            PortalCommand.adjustPortalAreaToFitFrame(portal);
            PortalCommand.reloadPortal(portal);
        })));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"add_command_on_teleported").requires(serverCommandSource -> serverCommandSource.hasPermission(2))).then(Commands.argument((String)"subCommand", (ArgumentType)SubCommandArgumentType.instance).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            String subCommand = SubCommandArgumentType.get(context, "subCommand");
            if (portal.getCommandsOnTeleported() == null) {
                portal.setCommandsOnTeleported(new ArrayList<String>());
            }
            portal.getCommandsOnTeleported().add(subCommand);
            portal.reloadAndSyncToClient();
            PortalCommand.sendPortalInfo((CommandContext<CommandSourceStack>)context, portal);
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"remove_command_on_teleported_at").requires(serverCommandSource -> serverCommandSource.hasPermission(2))).then(Commands.argument((String)"indexStartingFromZero", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            if (portal.getCommandsOnTeleported() == null) {
                return;
            }
            int index = IntegerArgumentType.getInteger((CommandContext)context, (String)"indexStartingFromZero");
            if (index >= portal.getCommandsOnTeleported().size()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Index out of range"));
                return;
            }
            portal.getCommandsOnTeleported().remove(index);
            portal.reloadAndSyncToClient();
            PortalCommand.sendPortalInfo((CommandContext<CommandSourceStack>)context, portal);
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"set_command_on_teleported_at").requires(serverCommandSource -> serverCommandSource.hasPermission(2))).then(Commands.argument((String)"indexStartingFromZero", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).then(Commands.argument((String)"subCommand", (ArgumentType)SubCommandArgumentType.instance).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            if (portal.getCommandsOnTeleported() == null) {
                return;
            }
            int index = IntegerArgumentType.getInteger((CommandContext)context, (String)"indexStartingFromZero");
            if (index >= portal.getCommandsOnTeleported().size()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Index out of range"));
                return;
            }
            String subCommand = SubCommandArgumentType.get(context, "subCommand");
            portal.getCommandsOnTeleported().set(index, subCommand);
            portal.reloadAndSyncToClient();
            PortalCommand.sendPortalInfo((CommandContext<CommandSourceStack>)context, portal);
        })))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"clear_commands_on_teleported").requires(serverCommandSource -> serverCommandSource.hasPermission(2))).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            portal.setCommandsOnTeleported(null);
            portal.reloadAndSyncToClient();
            PortalCommand.sendPortalInfo((CommandContext<CommandSourceStack>)context, portal);
        })));
        builder.then(Commands.literal((String)"turn_info_fake_enterable_mirror").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.invokeTurnIntoFakeEnterableMirror((CommandContext<CommandSourceStack>)context, portal))));
        LiteralArgumentBuilder shapeBuilder = Commands.literal((String)"shape");
        shapeBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"sculpt").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.invokeSculpt((CommandContext<CommandSourceStack>)context, portal, true)))).then(Commands.argument((String)"adjustPortalBounds", (ArgumentType)BoolArgumentType.bool()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            boolean adjustPortalBounds = BoolArgumentType.getBool((CommandContext)context, (String)"adjustPortalBounds");
            PortalCommand.invokeSculpt((CommandContext<CommandSourceStack>)context, portal, adjustPortalBounds);
        }))));
        shapeBuilder.then(Commands.literal((String)"reset").executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            portal.setPortalShapeToDefault();
            PortalCommand.reloadPortal(portal);
        })));
        builder.then((ArgumentBuilder)shapeBuilder);
        LiteralArgumentBuilder toggleBuilder = Commands.literal((String)"toggle");
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<CommandSourceStack>)toggleBuilder, "interactable", Portal::isInteractable, Portal::setInteractable);
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<CommandSourceStack>)toggleBuilder, "teleportable", Portal::isTeleportable, Portal::setTeleportable);
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<CommandSourceStack>)toggleBuilder, "teleportChangesScale", Portal::isTeleportChangesScale, Portal::setTeleportChangesScale);
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<CommandSourceStack>)toggleBuilder, "teleportChangesGravity", Portal::isTeleportChangesGravity, Portal::setTeleportChangesGravity);
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<CommandSourceStack>)toggleBuilder, "fuseView", Portal::isFuseView, Portal::setFuseView);
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<CommandSourceStack>)toggleBuilder, "visible", Portal::isVisible, Portal::setIsVisible);
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<CommandSourceStack>)toggleBuilder, "crossPortalCollisionEnabled", Portal::isCrossPortalCollisionEnabled, Portal::setCrossPortalCollisionEnabled);
        PortalCommand.registerToggleCommand((LiteralArgumentBuilder<CommandSourceStack>)toggleBuilder, "doRenderPayer", Portal::getDoRenderPlayer, Portal::setDoRenderPlayer);
        builder.then((ArgumentBuilder)toggleBuilder);
    }

    private static void registerToggleCommand(LiteralArgumentBuilder<CommandSourceStack> builder, String property, Function<Portal, Boolean> getter, BiConsumer<Portal, Boolean> setter) {
        builder.then(Commands.literal((String)property).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            boolean newValue = (Boolean)getter.apply(portal) == false;
            setter.accept(portal, newValue);
            PortalCommand.reloadPortal(portal);
            PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "Set %s to %s".formatted(property, newValue));
        })));
    }

    private static void invokeSetPortalNbt(CommandContext<CommandSourceStack> context, Portal portal, CompoundTag newNbt) {
        if (newNbt.contains("commandsOnTeleported") && !((CommandSourceStack)context.getSource()).hasPermission(2)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You do not have the permission to set commandsOnTeleported"));
            return;
        }
        if (newNbt.contains("dimensionTo")) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Cannot change tag dimensionTo. use command /portal set_portal_destination"));
            return;
        }
        portal.updatePortalFromNbt(newNbt);
        PortalCommand.reloadPortal(portal);
        PortalCommand.sendPortalInfo(context, portal);
    }

    private static void adjustPortalAreaToFitFrame(Portal portal) {
        portal.setPortalShapeToDefault();
        BlockPos origin = BlockPos.containing((Position)portal.getOriginPos());
        Direction portalNormalDirection = Direction.getNearest((double)portal.getNormal().x, (double)portal.getNormal().y, (double)portal.getNormal().z);
        Level world = portal.level();
        IntBox boxArea = Helper.expandRectangle(origin, pos -> world.getBlockState(pos).isAir(), portalNormalDirection.getAxis());
        AABB portalBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (Direction direction : Direction.values()) {
            IntBox outerSurface = boxArea.getSurfaceLayer(direction).getMoved(direction.getNormal());
            AABB collisionBox = McHelper.getWallBox(world, outerSurface);
            if (collisionBox == null) {
                collisionBox = outerSurface.toRealNumberBox();
            }
            portalBox = Helper.replaceBoxCoordinate(portalBox, direction, Helper.getBoxCoordinate(collisionBox, direction.getOpposite()));
        }
        double portalNormalCoordinate = Helper.getCoordinate(portal.getOriginPos(), portalNormalDirection.getAxis());
        portalBox = Helper.replaceBoxCoordinate(portalBox, portalNormalDirection, portalNormalCoordinate);
        portalBox = Helper.replaceBoxCoordinate(portalBox, portalNormalDirection.getOpposite(), portalNormalCoordinate);
        PortalAPI.setPortalOrthodoxShape(portal, portalNormalDirection, portalBox);
    }

    public static void reloadPortal(Portal portal) {
        portal.reloadPortal();
    }

    private static void registerPortalTargetedCommandWithRotationArgument(LiteralArgumentBuilder<CommandSourceStack> builder, String literal, BiConsumer<Portal, DQuaternion> func) {
        builder.then(Commands.literal((String)literal).then(Commands.argument((String)"rotatingAxis", (ArgumentType)Vec3Argument.vec3((boolean)false)).then(Commands.argument((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Vec3 rotatingAxis = Vec3Argument.getVec3((CommandContext)context, (String)"rotatingAxis").normalize();
            PortalCommand.doInvokeRotationCommandWithAngleArgument(func, (CommandContext<CommandSourceStack>)context, portal, rotatingAxis);
        })))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)(literal + "_along")).then(Commands.literal((String)"x").then(Commands.argument((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.doInvokeRotationCommandWithAngleArgument(func, (CommandContext<CommandSourceStack>)context, portal, new Vec3(1.0, 0.0, 0.0))))))).then(Commands.literal((String)"y").then(Commands.argument((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.doInvokeRotationCommandWithAngleArgument(func, (CommandContext<CommandSourceStack>)context, portal, new Vec3(0.0, 1.0, 0.0))))))).then(Commands.literal((String)"z").then(Commands.argument((String)"angleDegrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> PortalCommand.doInvokeRotationCommandWithAngleArgument(func, (CommandContext<CommandSourceStack>)context, portal, new Vec3(0.0, 0.0, 1.0)))))));
    }

    private static void doInvokeRotationCommandWithAngleArgument(BiConsumer<Portal, DQuaternion> func, CommandContext<CommandSourceStack> context, Portal portal, Vec3 rotatingAxis) {
        PortalCommand.sendEditBiWayPortalWarning(context, portal);
        double angleDegrees = DoubleArgumentType.getDouble(context, (String)"angleDegrees");
        DQuaternion rot = angleDegrees != 0.0 ? DQuaternion.rotationByDegrees(rotatingAxis, (float)angleDegrees) : null;
        func.accept(portal, rot);
        PortalCommand.reloadPortal(portal);
    }

    private static void registerCBPortalCommands(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.literal((String)"cb_make_portal").then(Commands.argument((String)"width", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"height", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"from", (ArgumentType)EntityArgument.entity()).then(((RequiredArgumentBuilder)Commands.argument((String)"to", (ArgumentType)EntityArgument.entity()).executes(context -> {
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            Entity fromEntity = EntityArgument.getEntity((CommandContext)context, (String)"from");
            Entity toEntity = EntityArgument.getEntity((CommandContext)context, (String)"to");
            PortalCommand.invokeCbMakePortal(width, height, fromEntity, toEntity, "");
            return 0;
        })).then(Commands.argument((String)"portalName", (ArgumentType)StringArgumentType.string()).executes(context -> {
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            Entity fromEntity = EntityArgument.getEntity((CommandContext)context, (String)"from");
            Entity toEntity = EntityArgument.getEntity((CommandContext)context, (String)"to");
            String portalName = StringArgumentType.getString((CommandContext)context, (String)"portalName");
            PortalCommand.invokeCbMakePortal(width, height, fromEntity, toEntity, portalName);
            return 0;
        })))))));
    }

    private static void invokeCbMakePortal(double width, double height, Entity fromEntity, Entity toEntity, String portalName) {
        Portal portal = (Portal)Portal.ENTITY_TYPE.create(fromEntity.level());
        portal.setPos(fromEntity.getX(), fromEntity.getY(), fromEntity.getZ());
        portal.setDestDim((ResourceKey<Level>)toEntity.level().dimension());
        portal.setDestination(toEntity.position());
        portal.setWidth(width);
        portal.setHeight(height);
        Vec3 normal = fromEntity.getViewVector(1.0f);
        Vec3 rightVec = PortalCommand.getRightVec(fromEntity);
        Vec3 axisH = rightVec.cross(normal).normalize();
        portal.setAxisW(rightVec);
        portal.setAxisH(axisH);
        portal.setCustomName((Component)Component.literal((String)portalName));
        McHelper.spawnServerEntity(portal);
    }

    private static void registerUtilityCommands(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpme").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(context -> {
            Entity entity = EntityArgument.getEntity((CommandContext)context, (String)"target");
            ServerTeleportationManager.of(((CommandSourceStack)context.getSource()).getServer()).forceTeleportPlayer(((CommandSourceStack)context.getSource()).getPlayerOrException(), (ResourceKey<Level>)entity.level().dimension(), entity.position());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"imm_ptl.command.tpme.success", (Object[])new Object[]{entity.getDisplayName()}), true);
            return 1;
        }))).then(Commands.argument((String)"dest", (ArgumentType)Vec3Argument.vec3()).executes(context -> {
            Vec3 dest = Vec3Argument.getVec3((CommandContext)context, (String)"dest");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ServerTeleportationManager.of(((CommandSourceStack)context.getSource()).getServer()).forceTeleportPlayer(player, (ResourceKey<Level>)player.level().dimension(), dest);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"imm_ptl.command.tpme.success", (Object[])new Object[]{dest.toString()}), true);
            return 1;
        }))).then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"dest", (ArgumentType)Vec3Argument.vec3()).executes(context -> {
            ResourceKey dim = DimensionArgument.getDimension((CommandContext)context, (String)"dim").dimension();
            Vec3 dest = Vec3Argument.getVec3((CommandContext)context, (String)"dest");
            ServerTeleportationManager.of(((CommandSourceStack)context.getSource()).getServer()).forceTeleportPlayer(((CommandSourceStack)context.getSource()).getPlayerOrException(), (ResourceKey<Level>)dim, dest);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"imm_ptl.command.tpme.success", (Object[])new Object[]{McHelper.dimensionTypeId((ResourceKey<Level>)dim).toString() + dest.toString()}), true);
            return 1;
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"tp").requires(commandSource -> commandSource.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"from", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"to", (ArgumentType)EntityArgument.entity()).executes(context -> {
            Collection entities = EntityArgument.getEntities((CommandContext)context, (String)"from");
            Entity target = EntityArgument.getEntity((CommandContext)context, (String)"to");
            int numTeleported = PortalCommand.teleport(entities, (ResourceKey<Level>)target.level().dimension(), target.position());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"imm_ptl.command.tp.success", (Object[])new Object[]{numTeleported, target.getDisplayName()}), true);
            return numTeleported;
        }))).then(Commands.argument((String)"dest", (ArgumentType)Vec3Argument.vec3()).executes(context -> {
            Collection entities = EntityArgument.getEntities((CommandContext)context, (String)"from");
            Vec3 dest = Vec3Argument.getVec3((CommandContext)context, (String)"dest");
            int numTeleported = PortalCommand.teleport(entities, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).getLevel().dimension(), dest);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"imm_ptl.command.tp.success", (Object[])new Object[]{numTeleported, dest.toString()}), true);
            return numTeleported;
        }))).then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"dest", (ArgumentType)Vec3Argument.vec3()).executes(context -> {
            Collection entities = EntityArgument.getEntities((CommandContext)context, (String)"from");
            ResourceKey dim = DimensionArgument.getDimension((CommandContext)context, (String)"dim").dimension();
            Vec3 dest = Vec3Argument.getVec3((CommandContext)context, (String)"dest");
            int numTeleported = PortalCommand.teleport(entities, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).getLevel().dimension(), dest);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"imm_ptl.command.tp.success", (Object[])new Object[]{numTeleported, McHelper.dimensionTypeId((ResourceKey<Level>)dim).toString() + dest.toString()}), true);
            return numTeleported;
        })))));
        builder.then(Commands.literal((String)"make_portal").then(Commands.argument((String)"width", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"height", (ArgumentType)DoubleArgumentType.doubleArg()).then(((RequiredArgumentBuilder)Commands.argument((String)"to", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"dest", (ArgumentType)Vec3Argument.vec3((boolean)false)).executes(PortalCommand::placePortalAbsolute))).then(Commands.literal((String)"shift").then(Commands.argument((String)"dist", (ArgumentType)DoubleArgumentType.doubleArg()).executes(PortalCommand::placePortalShift)))))));
        builder.then(Commands.literal((String)"goback").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ServerTeleportationManager serverTeleportationManager = ServerTeleportationManager.of(((CommandSourceStack)context.getSource()).getServer());
            WithDim<Vec3> lastPos = serverTeleportationManager.lastPosition.get(player);
            if (lastPos == null) {
                PortalCommand.sendMessage((CommandContext<CommandSourceStack>)context, "You haven't teleported");
            } else {
                serverTeleportationManager.forceTeleportPlayer(player, lastPos.dimension(), lastPos.value());
            }
            return 0;
        }));
        builder.then(Commands.literal((String)"create_small_inward_wrapping").then(Commands.argument((String)"p1", (ArgumentType)Vec3Argument.vec3((boolean)false)).then(Commands.argument((String)"p2", (ArgumentType)Vec3Argument.vec3((boolean)false)).executes(context -> {
            Vec3 p1 = Vec3Argument.getVec3((CommandContext)context, (String)"p1");
            Vec3 p2 = Vec3Argument.getVec3((CommandContext)context, (String)"p2");
            AABB box = new AABB(p1, p2);
            ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
            PortalCommand.addSmallWorldWrappingPortals(box, world, true);
            return 0;
        }))));
        builder.then(Commands.literal((String)"create_small_outward_wrapping").then(Commands.argument((String)"p1", (ArgumentType)Vec3Argument.vec3((boolean)false)).then(Commands.argument((String)"p2", (ArgumentType)Vec3Argument.vec3((boolean)false)).executes(context -> {
            Vec3 p1 = Vec3Argument.getVec3((CommandContext)context, (String)"p1");
            Vec3 p2 = Vec3Argument.getVec3((CommandContext)context, (String)"p2");
            AABB box = new AABB(p1, p2);
            ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
            PortalCommand.addSmallWorldWrappingPortals(box, world, false);
            return 0;
        }))));
        builder.then(Commands.literal((String)"create_scaled_box_view").then(Commands.argument((String)"p1", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"p2", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"placeTargetEntity", (ArgumentType)EntityArgument.entity()).then(((RequiredArgumentBuilder)Commands.argument((String)"biWay", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            PortalCommand.invokeOldCreateScaledViewCommand((CommandContext<CommandSourceStack>)context, false, false, false, false, BoolArgumentType.getBool((CommandContext)context, (String)"biWay"));
            return 0;
        })).then(Commands.argument((String)"teleportChangesScale", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean teleportChangesScale = BoolArgumentType.getBool((CommandContext)context, (String)"teleportChangesScale");
            PortalCommand.invokeOldCreateScaledViewCommand((CommandContext<CommandSourceStack>)context, teleportChangesScale, false, false, false, BoolArgumentType.getBool((CommandContext)context, (String)"biWay"));
            return 0;
        }))))))));
        builder.then(Commands.literal((String)"create_scaled_box_view_optimized").then(Commands.argument((String)"p1", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"p2", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"placeTargetEntity", (ArgumentType)EntityArgument.entity()).executes(context -> {
            BlockPos bp1 = BlockPosArgument.getSpawnablePos((CommandContext)context, (String)"p1");
            BlockPos bp2 = BlockPosArgument.getSpawnablePos((CommandContext)context, (String)"p2");
            IntBox intBox = new IntBox(bp1, bp2);
            Entity placeTargetEntity = EntityArgument.getEntity((CommandContext)context, (String)"placeTargetEntity");
            ServerLevel boxWorld = (ServerLevel)placeTargetEntity.level();
            AABB area = intBox.toRealNumberBox();
            ServerLevel areaWorld = ((CommandSourceStack)context.getSource()).getLevel();
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            double thisSideWidth = area.getXsize() / scale;
            double thisSideHeight = area.getYsize() / scale;
            double thisSideThickness = area.getZsize() / scale;
            Portal portal = (Portal)Portal.ENTITY_TYPE.create((Level)boxWorld);
            assert (portal != null);
            portal.setDestinationDimension((ResourceKey<Level>)areaWorld.dimension());
            portal.setOriginPos(placeTargetEntity.position().add(0.0, thisSideHeight / 2.0, 0.0));
            portal.setDestination(area.getCenter());
            portal.setOrientationRotation(DQuaternion.identity);
            portal.setPortalSize(thisSideWidth, thisSideHeight, thisSideThickness);
            portal.setPortalShape(BoxPortalShape.FACING_OUTWARDS);
            portal.setScaleTransformation(scale);
            portal.setFuseView(true);
            portal.setTeleportChangesScale(false);
            McHelper.spawnServerEntity(portal);
            Portal reverse = PortalAPI.createReversePortal(portal);
            McHelper.spawnServerEntity(reverse);
            return 0;
        }))))));
        builder.then(Commands.literal((String)"create_connected_rooms").then(Commands.literal((String)"roomSize").then(Commands.argument((String)"roomSize", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.literal((String)"roomNumber").then(Commands.argument((String)"roomNumber", (ArgumentType)IntegerArgumentType.integer((int)2, (int)500)).executes(context -> {
            BlockPos roomSize = BlockPosArgument.getSpawnablePos((CommandContext)context, (String)"roomSize");
            int roomNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"roomNumber");
            PortalCommand.createConnectedRooms(((CommandSourceStack)context.getSource()).getLevel(), BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition()), roomSize, roomNumber, text -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> text, false));
            return 0;
        }))))));
        builder.then(Commands.literal((String)"create_cube_surface_unwrapping").then(Commands.argument((String)"boxL", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"boxH", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"length", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(context -> {
            BlockPos boxL = BlockPosArgument.getSpawnablePos((CommandContext)context, (String)"boxL");
            BlockPos boxH = BlockPosArgument.getSpawnablePos((CommandContext)context, (String)"boxH");
            IntBox box = new IntBox(boxL, boxH);
            int length = IntegerArgumentType.getInteger((CommandContext)context, (String)"length");
            BlockPos size = box.getSize();
            PortalCommand.createCubeSurfaceUnwrapping(((CommandSourceStack)context.getSource()).getLevel(), box.toRealNumberBox(), length);
            return 0;
        })))));
        builder.then(Commands.literal((String)"adjust_rotation_to_connect").then(Commands.argument((String)"portal1", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"portal2", (ArgumentType)EntityArgument.entity()).executes(context -> {
            Entity e1 = EntityArgument.getEntity((CommandContext)context, (String)"portal1");
            Entity e2 = EntityArgument.getEntity((CommandContext)context, (String)"portal2");
            if (!(e1 instanceof Portal)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"portal1 is not a portal entity"));
                return 0;
            }
            if (!(e2 instanceof Portal)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"portal2 is not a portal entity"));
                return 0;
            }
            Portal portal1 = (Portal)e1;
            Portal portal2 = (Portal)e2;
            portal1.setDestination(portal2.getOriginPos());
            portal2.setDestination(portal1.getOriginPos());
            PortalManipulation.adjustRotationToConnect(portal1, portal2);
            portal1.reloadAndSyncToClient();
            portal2.reloadAndSyncToClient();
            return 0;
        }))));
        builder.then(Commands.literal((String)"rotate_portals_around").then(Commands.argument((String)"portals", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"origin", (ArgumentType)Vec3Argument.vec3()).then(Commands.argument((String)"axis", (ArgumentType)Vec3Argument.vec3((boolean)false)).then(Commands.argument((String)"angle", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            Portal portal;
            Collection portals = EntityArgument.getEntities((CommandContext)context, (String)"portals");
            Vec3 origin = Vec3Argument.getVec3((CommandContext)context, (String)"origin");
            Vec3 axis = Vec3Argument.getVec3((CommandContext)context, (String)"axis").normalize();
            double angle = DoubleArgumentType.getDouble((CommandContext)context, (String)"angle");
            DQuaternion quaternion = DQuaternion.rotationByDegrees(axis, angle);
            for (Entity entity : portals) {
                if (entity instanceof Portal) {
                    portal = (Portal)entity;
                    Vec3 offset = portal.getOriginPos().subtract(origin);
                    Vec3 offsetRotated = quaternion.rotate(offset);
                    portal.setOriginPos(offsetRotated.add(origin));
                    portal.setAxisW(quaternion.rotate(portal.getAxisW()));
                    portal.setAxisH(quaternion.rotate(portal.getAxisH()));
                    portal.setRotationTransformationD(portal.getRotationD().hamiltonProduct(quaternion.getConjugated()));
                    continue;
                }
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"the entity is not a portal"));
            }
            for (Entity entity : portals) {
                if (!(entity instanceof Portal)) continue;
                portal = (Portal)entity;
                PortalCommand.reloadPortal(portal);
            }
            return 0;
        }))))));
        builder.then(Commands.literal((String)"scale_portals_relative_to_point").then(Commands.argument((String)"portals", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"origin", (ArgumentType)Vec3Argument.vec3()).then(Commands.argument((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            Collection portals = EntityArgument.getEntities((CommandContext)context, (String)"portals");
            Vec3 origin = Vec3Argument.getVec3((CommandContext)context, (String)"origin");
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            ArrayList<Portal> portalsToReload = new ArrayList<Portal>();
            for (Entity entity : portals) {
                if (entity instanceof Portal) {
                    Portal portal = (Portal)entity;
                    Vec3 offset = portal.getOriginPos().subtract(origin);
                    Vec3 newOrigin = offset.scale(scale).add(origin);
                    PortalExtension extension = PortalExtension.get(portal);
                    if (extension.reversePortal != null) {
                        extension.reversePortal.setDestination(newOrigin);
                        extension.reversePortal.setScaling(extension.reversePortal.getScaling() / scale);
                        portalsToReload.add(extension.reversePortal);
                        continue;
                    }
                    portal.setOriginPos(newOrigin);
                    portal.setWidth(portal.getWidth() * scale);
                    portal.setHeight(portal.getHeight() * scale);
                    portalsToReload.add(portal);
                    continue;
                }
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"the entity is not a portal"));
            }
            for (Portal portal : portalsToReload) {
                PortalCommand.reloadPortal(portal);
            }
            return 0;
        })))));
        builder.then(Commands.literal((String)"create_diagonal_portal").then(Commands.argument((String)"fromPos", (ArgumentType)Vec3Argument.vec3((boolean)false)).then(Commands.argument((String)"toPos", (ArgumentType)Vec3Argument.vec3((boolean)false)).then(Commands.argument((String)"axis", (ArgumentType)AxisArgumentType.instance).executes(context -> {
            Vec3 fromPos = Vec3Argument.getVec3((CommandContext)context, (String)"fromPos");
            Vec3 toPos = Vec3Argument.getVec3((CommandContext)context, (String)"toPos");
            Direction.Axis axis = AxisArgumentType.getAxis(context, "axis");
            Vec3 axisVec = Vec3.atLowerCornerOf((Vec3i)Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).getNormal());
            Vec3 delta = toPos.subtract(fromPos);
            Vec3 vecAlongAxis = axisVec.scale(delta.dot(axisVec));
            Vec3 vecNotAlongAxis = delta.subtract(vecAlongAxis);
            Vec3 center = fromPos.add(toPos).scale(0.5);
            Portal portal = (Portal)Portal.ENTITY_TYPE.create((Level)((CommandSourceStack)context.getSource()).getLevel());
            assert (portal != null);
            portal.setOriginPos(center);
            portal.setOrientation(vecAlongAxis.normalize(), vecNotAlongAxis.normalize());
            portal.setWidth(vecAlongAxis.length());
            portal.setHeight(vecNotAlongAxis.length());
            portal.setDestination(center.add(0.0, 10.0, 0.0));
            portal.setDestinationDimension((ResourceKey<Level>)((CommandSourceStack)context.getSource()).getLevel().dimension());
            if (portal.getWidth() > 64.0 || portal.getHeight() > 64.0) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"portal size is too large"));
                return 0;
            }
            McHelper.spawnServerEntity(portal);
            Portal flippedPortal = PortalManipulation.createFlippedPortal(portal, Portal.ENTITY_TYPE);
            McHelper.spawnServerEntity(flippedPortal);
            return 0;
        })))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"dimension_stack").requires(commandSource -> commandSource.hasPermission(2))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            DimStackManagement.onDimensionStackCommandExecute(player);
            return 0;
        }));
        builder.then(Commands.literal((String)"wiki").executes(context -> {
            ((CommandSourceStack)context.getSource()).getPlayerOrException().sendSystemMessage((Component)McHelper.getLinkText("https://qouteall.fun/immptl/wiki/Commands-Reference"));
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"create_command_stick").requires(serverCommandSource -> serverCommandSource.hasPermission(2))).then(Commands.argument((String)"command", (ArgumentType)SubCommandArgumentType.instance).executes(context -> {
            createCommandStickCommandSignal.emit(((CommandSourceStack)context.getSource()).getPlayerOrException(), SubCommandArgumentType.get(context, "command"));
            return 0;
        })));
    }

    private static void createCubeSurfaceUnwrapping(ServerLevel world, AABB box, double length) {
        Vec3 boxSize = Helper.getBoxSize(box);
        Vec3 boxCenter = box.getCenter();
        for (Direction face : Direction.values()) {
            Vec3 facingVec = Vec3.atLowerCornerOf((Vec3i)face.getNormal());
            for (Direction sideDirection : Helper.getAnotherFourDirections(face.getAxis())) {
                Vec3 sideDirectionVec = Vec3.atLowerCornerOf((Vec3i)sideDirection.getNormal());
                Vec3 edgeCenter = facingVec.scale(0.5).add(sideDirectionVec.scale(0.5)).multiply(boxSize).add(boxCenter);
                Vec3 portalOrigin = edgeCenter.add(facingVec.scale(length / 2.0));
                Vec3 portalDestination = edgeCenter.add(sideDirectionVec.scale(length / 2.0));
                Vec3 portalWAxis = sideDirectionVec.cross(facingVec);
                Vec3 portalHAxis = facingVec;
                double width = Math.abs(boxSize.dot(portalWAxis));
                double height = length;
                DQuaternion rotationTransform = DQuaternion.getRotationBetween(facingVec, sideDirectionVec);
                Portal portal = (Portal)Portal.ENTITY_TYPE.create((Level)world);
                portal.setOriginPos(portalOrigin);
                portal.setDestination(portalDestination);
                portal.setDestinationDimension((ResourceKey<Level>)world.dimension());
                portal.setOrientationAndSize(portalWAxis, portalHAxis, width, height);
                portal.setRotationTransformationD(rotationTransform);
                portal.setTeleportChangesGravity(true);
                portal.portalTag = "imm_ptl:cube_surface_unwrapping";
                McHelper.spawnServerEntity(portal);
            }
        }
    }

    private static void createConnectedRooms(ServerLevel world, BlockPos startingPos, BlockPos roomSize, int roomNumber, Consumer<Component> feedbackSender) {
        BlockPos roomAreaSize = roomSize.offset(2, 2, 2);
        ArrayList roomAreaList = new ArrayList();
        Helper.SimpleBox<BlockPos> currentSearchingCenter = new Helper.SimpleBox<BlockPos>(startingPos);
        ServerTaskList.of(world.getServer()).addTask(MyTaskList.chainTask(MyTaskList.repeat(roomNumber, () -> MyTaskList.withDelay(20, MyTaskList.oneShotTask(() -> {
            currentSearchingCenter.obj = ((BlockPos)currentSearchingCenter.obj).offset((Vec3i)PortalCommand.getRandomShift(20));
            IntBox airCube = NetherPortalMatcher.findCubeAirAreaAtAnywhere(roomAreaSize.offset(6, 6, 6), (LevelAccessor)world, (BlockPos)currentSearchingCenter.obj, 128);
            if (airCube == null) {
                feedbackSender.accept((Component)Component.literal((String)"Cannot find space for placing room"));
                return;
            }
            airCube = airCube.getSubBoxInCenter(roomAreaSize);
            PortalCommand.fillRoomFrame(world, airCube, PortalCommand.getRandomBlock());
            roomAreaList.add(airCube);
        }))), MyTaskList.oneShotTask(() -> {
            Stream<IntBox> roomsStream = Stream.concat(roomAreaList.stream(), Stream.of((IntBox)roomAreaList.get(0)));
            Helper.wrapAdjacentAndMap(roomsStream, Pair::new).forEach(pair -> {
                IntBox room1Area = (IntBox)pair.getFirst();
                IntBox room2Area = (IntBox)pair.getSecond();
                IntBox room1 = room1Area.getAdjusted(1, 1, 1, -1, -1, -1);
                IntBox room2 = room2Area.getAdjusted(1, 1, 1, -1, -1, -1);
                Portal portal = (Portal)Portal.ENTITY_TYPE.create((Level)world);
                Validate.notNull((Object)portal);
                portal.setOriginPos(room1.getCenterVec().add((double)roomSize.getX() / 4.0, 0.0, 0.0));
                portal.setDestinationDimension((ResourceKey<Level>)world.dimension());
                portal.setDestination(room2.getCenterVec().add((double)roomSize.getX() / 4.0, 0.0, 0.0));
                portal.setOrientationAndSize(new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), (double)roomSize.getX() / 2.0, roomSize.getY());
                portal.portalTag = "imm_ptl:room_connection";
                McHelper.spawnServerEntity(portal);
                Portal reversePortal = PortalAPI.createReversePortal(portal);
                McHelper.spawnServerEntity(reversePortal);
            });
            feedbackSender.accept((Component)Component.literal((String)"finished"));
        })));
    }

    private static BlockState getRandomBlock() {
        Block block;
        BlockState state;
        while (!(state = (block = (Block)((Holder.Reference)BuiltInRegistries.BLOCK.getRandom(RandomSource.create()).get()).value()).defaultBlockState()).isSolid()) {
        }
        return state;
    }

    private static void fillRoomFrame(ServerLevel world, IntBox roomArea, BlockState blockState) {
        for (Direction direction : Direction.values()) {
            IntBox surface = roomArea.getSurfaceLayer(direction);
            surface.fastStream().forEach(blockPos -> world.setBlockAndUpdate(blockPos, blockState));
        }
    }

    private static void invokeOldCreateScaledViewCommand(CommandContext<CommandSourceStack> context, boolean teleportChangesScale, boolean outerFuseView, boolean outerRenderingMergable, boolean innerRenderingMergable, boolean isBiWay) throws CommandSyntaxException {
        BlockPos bp1 = BlockPosArgument.getSpawnablePos(context, (String)"p1");
        BlockPos bp2 = BlockPosArgument.getSpawnablePos(context, (String)"p2");
        IntBox intBox = new IntBox(bp1, bp2);
        Entity placeTargetEntity = EntityArgument.getEntity(context, (String)"placeTargetEntity");
        ServerLevel boxWorld = (ServerLevel)placeTargetEntity.level();
        Vec3 boxBottomCenter = placeTargetEntity.position();
        AABB area = intBox.toRealNumberBox();
        ServerLevel areaWorld = ((CommandSourceStack)context.getSource()).getLevel();
        double scale = DoubleArgumentType.getDouble(context, (String)"scale");
        PortalManipulation.createScaledBoxView(areaWorld, area, boxWorld, boxBottomCenter, scale, isBiWay, teleportChangesScale, outerFuseView, outerRenderingMergable, innerRenderingMergable, false);
    }

    private static void addSmallWorldWrappingPortals(AABB box, ServerLevel world, boolean isInward) {
        for (Direction direction : Direction.values()) {
            Portal portal = (Portal)Portal.ENTITY_TYPE.create((Level)world);
            WorldWrappingPortal.initWrappingPortal(world, box, direction, isInward, portal);
            McHelper.spawnServerEntity(portal);
        }
    }

    private static int processPortalArgumentedCBCommand(CommandContext<CommandSourceStack> context, PortalConsumerThrowsCommandSyntaxException invoker) throws CommandSyntaxException {
        Collection entities = EntityArgument.getEntities(context, (String)"portal");
        for (Entity portalEntity : entities) {
            if (portalEntity instanceof Portal) {
                Portal portal = (Portal)portalEntity;
                invoker.accept(portal);
                continue;
            }
            PortalCommand.sendMessage(context, "The target should be portal");
        }
        return 0;
    }

    private static void sendEditBiWayPortalWarning(CommandContext<CommandSourceStack> context, Portal portal) {
        if (!PortalExtension.get((Portal)portal).bindCluster && PortalManipulation.findReversePortal(portal) != null) {
            PortalCommand.sendMessage(context, "You are editing a bi-way portal. It's recommended to enable bindCluster or you will get unlinked portal entities. Use command /portal set_portal_nbt {bindCluster:true}");
        }
        if (portal instanceof BreakablePortalEntity) {
            BreakablePortalEntity breakablePortalEntity = (BreakablePortalEntity)portal;
            if (!breakablePortalEntity.unbreakable) {
                PortalCommand.sendMessage(context, "You are editing a breakable portal. It may break if its state is abnormal. It's recommended to make it unbreakable by /portal set_portal_nbt {unbreakable:true}");
            }
        }
    }

    private static void invokeCompleteBiWayBiFacedPortal(CommandContext<CommandSourceStack> context, Portal portal) {
        PortalExtension.get((Portal)portal).bindCluster = true;
        PortalCommand.reloadPortal(portal);
        PortalManipulation.completeBiWayBiFacedPortal(portal, p -> PortalCommand.sendMessage(context, "Removed " + String.valueOf(p)), p -> PortalCommand.sendMessage(context, "Added " + String.valueOf(p)), Portal.ENTITY_TYPE);
    }

    private static void invokeCompleteBiFacedPortal(CommandContext<CommandSourceStack> context, Portal portal) {
        PortalManipulation.removeOverlappedPortals((Level)((ServerLevel)portal.level()), portal.getOriginPos(), portal.getNormal().scale(-1.0), p -> Objects.equals(portal.specificPlayerId, p.specificPlayerId), p -> PortalCommand.sendMessage(context, "Removed " + String.valueOf(p)));
        PortalExtension.get((Portal)portal).bindCluster = true;
        PortalCommand.reloadPortal(portal);
        Portal result = PortalManipulation.completeBiFacedPortal(portal, Portal.ENTITY_TYPE);
        PortalCommand.sendMessage(context, "Added " + String.valueOf(result));
    }

    private static void invokeCompleteBiWayPortal(CommandContext<CommandSourceStack> context, Portal portal) {
        PortalManipulation.removeOverlappedPortals((Level)MiscHelper.getServer().getLevel(portal.getDestDim()), portal.getDestPos(), portal.transformLocalVecNonScale(portal.getNormal().scale(-1.0)), p -> Objects.equals(portal.specificPlayerId, p.specificPlayerId), p -> PortalCommand.sendMessage(context, "Removed " + String.valueOf(p)));
        PortalExtension.get((Portal)portal).bindCluster = true;
        PortalCommand.reloadPortal(portal);
        Portal result = PortalManipulation.completeBiWayPortal(portal, Portal.ENTITY_TYPE);
        PortalCommand.sendMessage(context, "Added " + String.valueOf(result));
    }

    private static void removeSpecificAccessor(CommandContext<CommandSourceStack> context, Portal portal) {
        portal.specificPlayerId = null;
        PortalCommand.sendMessage(context, "This portal can be accessed by all players now");
        PortalCommand.sendMessage(context, portal.toString());
    }

    private static void setSpecificAccessor(CommandContext<CommandSourceStack> context, Portal portal, Entity player) {
        portal.specificPlayerId = player.getUUID();
        PortalCommand.sendMessage(context, "This portal can only be accessed by " + String.valueOf(player.getName().getContents()) + " now");
        PortalCommand.sendMessage(context, portal.toString());
    }

    private static void removeMultidestEntry(CommandContext<CommandSourceStack> context, Portal pointedPortal, ServerPlayer player) {
        PortalManipulation.getPortalCluster(pointedPortal.level(), pointedPortal.getOriginPos(), pointedPortal.getNormal(), p -> true).stream().filter(portal -> player.getUUID().equals(portal.specificPlayerId) || portal.specificPlayerId == null).forEach(portal -> {
            PortalManipulation.removeConnectedPortals(portal, p -> PortalCommand.sendMessage(context, "removed " + p.toString()));
            PortalCommand.sendMessage(context, "removed " + portal.toString());
            portal.remove(Entity.RemovalReason.KILLED);
        });
    }

    private static void setMultidestEntry(CommandContext<CommandSourceStack> context, Portal pointedPortal, ServerPlayer player, ResourceKey<Level> dimension, Vec3 destination, boolean biFaced, boolean biWay) {
        Portal newPortal = PortalManipulation.copyPortal(pointedPortal, Portal.ENTITY_TYPE);
        PortalCommand.removeMultidestEntry(context, pointedPortal, player);
        newPortal.setDestDim(dimension);
        newPortal.setDestination(destination);
        newPortal.specificPlayerId = player.getUUID();
        McHelper.spawnServerEntity(newPortal);
        PortalCommand.configureBiWayBiFaced(newPortal, biWay, biFaced);
    }

    private static void configureBiWayBiFaced(Portal newPortal, boolean biWay, boolean biFaced) {
        if (biFaced && biWay) {
            PortalManipulation.completeBiWayBiFacedPortal(newPortal, p -> {}, p -> {}, Portal.ENTITY_TYPE);
        } else if (biFaced) {
            PortalManipulation.completeBiFacedPortal(newPortal, Portal.ENTITY_TYPE);
        } else if (biWay) {
            PortalManipulation.completeBiWayPortal(newPortal, Portal.ENTITY_TYPE);
        }
    }

    public static void sendPortalInfo(CommandContext<CommandSourceStack> context, Portal portal) {
        PortalCommand.sendPortalInfo((Component c) -> {
            PortalCommand.sendMessage(context, c);
            Helper.log(c.getString());
        }, portal);
    }

    public static void sendPortalInfo(Consumer<Component> func, Portal portal) {
        func.accept(McHelper.compoundTagToTextSorted(portal.saveWithoutId(new CompoundTag()), " ", 0));
        func.accept((Component)Component.literal((String)portal.toString()));
        func.accept((Component)Component.literal((String)String.format("Orientation: %s", PortalAPI.getPortalOrientationQuaternion(portal))));
        if (portal.getRotation() != null) {
            func.accept((Component)Component.literal((String)String.format("Rotating Transformation: %s", portal.getRotation())));
        }
    }

    public static void sendMessage(CommandContext<CommandSourceStack> context, Component component) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> component, false);
    }

    public static void sendMessage(CommandContext<CommandSourceStack> context, String message) {
        PortalCommand.sendMessage(context, (Component)Component.literal((String)message));
    }

    private static Component getMakePortalSuccess(Portal portal) {
        return Component.translatable((String)"imm_ptl.command.make_portal.success", (Object[])new Object[]{Double.toString(portal.getWidth()), Double.toString(portal.getHeight()), McHelper.dimensionTypeId((ResourceKey<Level>)portal.level().dimension()).toString(), portal.getOriginPos().toString(), McHelper.dimensionTypeId(portal.getDestDim()).toString(), portal.getDestPos().toString()});
    }

    private static int placePortalAbsolute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        double width = DoubleArgumentType.getDouble(context, (String)"width");
        double height = DoubleArgumentType.getDouble(context, (String)"height");
        ResourceKey to = DimensionArgument.getDimension(context, (String)"to").dimension();
        Vec3 dest = Vec3Argument.getVec3(context, (String)"dest");
        Portal portal = PortalManipulation.placePortal(width, height, (Entity)((CommandSourceStack)context.getSource()).getPlayerOrException());
        if (portal == null) {
            return 0;
        }
        portal.setDestDim((ResourceKey<Level>)to);
        portal.setDestination(dest);
        McHelper.spawnServerEntity(portal);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> PortalCommand.getMakePortalSuccess(portal), true);
        return 1;
    }

    private static int placePortalShift(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        double width = DoubleArgumentType.getDouble(context, (String)"width");
        double height = DoubleArgumentType.getDouble(context, (String)"height");
        ResourceKey to = DimensionArgument.getDimension(context, (String)"to").dimension();
        double dist = DoubleArgumentType.getDouble(context, (String)"dist");
        Portal portal = PortalManipulation.placePortal(width, height, (Entity)((CommandSourceStack)context.getSource()).getPlayerOrException());
        if (portal == null) {
            return 0;
        }
        portal.setDestDim((ResourceKey<Level>)to);
        portal.setDestination(portal.getOriginPos().add(portal.getAxisW().cross(portal.getAxisH()).scale(-dist)));
        McHelper.spawnServerEntity(portal);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> PortalCommand.getMakePortalSuccess(portal), true);
        return 1;
    }

    public static int teleport(Collection<? extends Entity> entities, ResourceKey<Level> targetDim, Vec3 targetPos) {
        ServerLevel targetWorld = MiscHelper.getServer().getLevel(targetDim);
        int numTeleported = 0;
        for (Entity entity : entities) {
            ServerTeleportationManager.teleportEntityGeneral(entity, targetPos, targetWorld);
            ++numTeleported;
        }
        return numTeleported;
    }

    public static BlockPos getRandomShift(int len) {
        Random rand = new Random();
        return BlockPos.containing((double)((rand.nextDouble() * 2.0 - 1.0) * (double)len), (double)((rand.nextDouble() * 2.0 - 1.0) * (double)len), (double)((rand.nextDouble() * 2.0 - 1.0) * (double)len));
    }

    public static int processPortalTargetedCommand(CommandContext<CommandSourceStack> context, PortalConsumerThrowsCommandSyntaxException processCommand) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Portal portal = PortalCommand.getPlayerPointingPortal(player, false);
            if (portal == null) {
                source.sendSuccess(() -> Component.literal((String)"You are not pointing to any non-global portal. (This command cannot process global portals)"), false);
                return 0;
            }
            processCommand.accept(portal);
        } else if (entity instanceof Portal) {
            processCommand.accept((Portal)entity);
        } else {
            source.sendSuccess(() -> Component.literal((String)"The command executor should be either a player or a portal entity"), false);
        }
        return 0;
    }

    @Deprecated
    public static Portal getPlayerPointingPortal(ServerPlayer player, boolean includeGlobalPortal) {
        return PortalCommand.getPlayerPointingPortalRaw((Player)player, 1.0f, 100.0, includeGlobalPortal).map(Pair::getFirst).orElse(null);
    }

    @Deprecated
    public static Optional<Pair<Portal, Vec3>> getPlayerPointingPortalRaw(Player player, float partialTick, double maxDistance, boolean includeGlobalPortal) {
        return PortalUtils.raytracePortalFromEntityView((Entity)player, partialTick, maxDistance, includeGlobalPortal, p -> true).map(p -> Pair.of((Object)((Portal)p.getFirst()), (Object)((RayTraceResult)p.getSecond()).hitPos()));
    }

    public static Optional<Pair<Portal, Vec3>> raytracePortals(Level world, Vec3 from, Vec3 to, boolean includeGlobalPortal) {
        return PortalUtils.raytracePortals(world, from, to, includeGlobalPortal, p -> true).map(p -> Pair.of((Object)((Portal)p.getFirst()), (Object)((RayTraceResult)p.getSecond()).hitPos()));
    }

    private static Vec3 getRightVec(Entity entity) {
        float yaw = entity.getYRot() + 90.0f;
        float radians = -yaw * ((float)Math.PI / 180);
        return new Vec3(Math.sin(radians), 0.0, Math.cos(radians));
    }

    private static void updateEntityFullNbt(Entity entity, CompoundTag nbt) {
        nbt.remove("id");
        nbt.remove("UUID");
        CompoundTag result = entity.saveWithoutId(new CompoundTag());
        result.merge(nbt);
        entity.load(result);
    }

    private static void registerEulerCommands(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"make_portal").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"origin", (ArgumentType)Vec3Argument.vec3((boolean)false)).then(Commands.argument((String)"rotation", (ArgumentType)RotationArgument.rotation()).then(Commands.argument((String)"width", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(Commands.argument((String)"height", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(Commands.argument((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> {
            Vec3 origin = Vec3Argument.getVec3((CommandContext)context, (String)"origin");
            Vec2 rotation = RotationArgument.getRotation((CommandContext)context, (String)"rotation").getRotation((CommandSourceStack)context.getSource());
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            double scale = DoubleArgumentType.getDouble((CommandContext)context, (String)"scale");
            CompoundTag nbt = CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt");
            ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
            Portal portal = (Portal)Portal.ENTITY_TYPE.create((Level)world);
            Validate.notNull((Object)portal);
            portal.setOriginPos(origin);
            portal.setDestination(origin.add(0.0, 10.0, 0.0));
            portal.setDestinationDimension((ResourceKey<Level>)world.dimension());
            DQuaternion orientationRotation = DQuaternion.fromEulerAngle(new Vec3((double)rotation.x, (double)rotation.y, 0.0));
            portal.setOrientationRotation(orientationRotation);
            portal.setWidth(width);
            portal.setHeight(height);
            portal.setScaleTransformation(scale);
            PortalCommand.updateEntityFullNbt(portal, nbt);
            McHelper.spawnServerEntity(portal);
            return 0;
        }))))))));
        builder.then(Commands.literal((String)"set_orientation").then(Commands.argument((String)"rotation", (ArgumentType)RotationArgument.rotation()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Vec2 rotation = RotationArgument.getRotation((CommandContext)context, (String)"rotation").getRotation((CommandSourceStack)context.getSource());
            DQuaternion orientationRotation = DQuaternion.fromEulerAngle(new Vec3((double)rotation.x, (double)rotation.y, 0.0));
            portal.setOrientationRotation(orientationRotation);
            PortalCommand.reloadPortal(portal);
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"set_this_side").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"origin", (ArgumentType)Vec3Argument.vec3((boolean)false)).then(Commands.argument((String)"rotation", (ArgumentType)RotationArgument.rotation()).then(Commands.argument((String)"width", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(Commands.argument((String)"height", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Vec3 origin = Vec3Argument.getVec3((CommandContext)context, (String)"origin");
            Vec2 rotation = RotationArgument.getRotation((CommandContext)context, (String)"rotation").getRotation((CommandSourceStack)context.getSource());
            double width = DoubleArgumentType.getDouble((CommandContext)context, (String)"width");
            double height = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            CompoundTag nbt = CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt");
            portal.setOriginPos(origin);
            DQuaternion orientationRotation = DQuaternion.fromEulerAngle(new Vec3((double)rotation.x, (double)rotation.y, 0.0));
            portal.setOrientationRotation(orientationRotation);
            portal.setWidth(width);
            portal.setHeight(height);
            PortalCommand.updateEntityFullNbt(portal, nbt);
            PortalCommand.reloadPortal(portal);
        }))))))));
        builder.then(Commands.literal((String)"set_other_side").then(Commands.argument((String)"destination", (ArgumentType)Vec3Argument.vec3((boolean)false)).then(Commands.argument((String)"rotation", (ArgumentType)RotationArgument.rotation()).executes(context -> PortalCommand.processPortalTargetedCommand((CommandContext<CommandSourceStack>)context, portal -> {
            Vec3 destination = Vec3Argument.getVec3((CommandContext)context, (String)"destination");
            Vec2 rotation = RotationArgument.getRotation((CommandContext)context, (String)"rotation").getRotation((CommandSourceStack)context.getSource());
            portal.setDestination(destination);
            portal.setDestinationDimension((ResourceKey<Level>)((CommandSourceStack)context.getSource()).getLevel().dimension());
            DQuaternion otherSideRotation = DQuaternion.fromEulerAngle(new Vec3((double)rotation.x, (double)rotation.y, 0.0));
            PortalState portalState = portal.getPortalState();
            UnilateralPortalState thisSide = UnilateralPortalState.extractThisSide(portalState);
            UnilateralPortalState otherSide = UnilateralPortalState.extractOtherSide(portalState);
            UnilateralPortalState newOtherSide = new UnilateralPortalState.Builder().from(otherSide).orientation(otherSideRotation).build();
            PortalState newPortalState = UnilateralPortalState.combine(thisSide, newOtherSide);
            portal.setPortalState(newPortalState);
            PortalCommand.reloadPortal(portal);
        })))));
    }

    private static void invokeTurnIntoFakeEnterableMirror(CommandContext<CommandSourceStack> context, Portal portal) {
        if (portal instanceof Mirror) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"This command targets non-mirror portals"));
            return;
        }
        PortalState portalState = portal.getPortalState();
        assert (portalState != null);
        UnilateralPortalState thisSideState = UnilateralPortalState.extractThisSide(portalState);
        UnilateralPortalState otherSideState = UnilateralPortalState.extractOtherSide(portalState);
        Level fromWorld = portal.level();
        Level toWorld = portal.getDestinationWorld();
        PortalShape specialShape = portal.getPortalShape();
        DQuaternion spacialRotation = portal.getRotationD();
        PortalManipulation.removeConnectedPortals(portal, p -> {});
        portal.remove(Entity.RemovalReason.KILLED);
        Mirror thisSideMirror = (Mirror)Mirror.ENTITY_TYPE.create(fromWorld);
        assert (thisSideMirror != null);
        thisSideMirror.setDestDim((ResourceKey<Level>)thisSideMirror.level().dimension());
        thisSideMirror.setOriginPos(thisSideState.position());
        thisSideMirror.setOrientationRotation(thisSideState.orientation());
        thisSideMirror.setDestination(thisSideState.position());
        thisSideMirror.setWidth(thisSideState.width());
        thisSideMirror.setHeight(thisSideState.height());
        thisSideMirror.setPortalShape(specialShape);
        thisSideMirror.setRotationTransformationForMirror(spacialRotation);
        Mirror otherSideMirror = (Mirror)Mirror.ENTITY_TYPE.create(toWorld);
        assert (otherSideMirror != null);
        otherSideMirror.setDestDim((ResourceKey<Level>)otherSideMirror.level().dimension());
        otherSideMirror.setOriginPos(otherSideState.position());
        otherSideMirror.setOrientationRotation(otherSideState.orientation());
        otherSideMirror.setDestination(otherSideState.position());
        otherSideMirror.setWidth(otherSideState.width());
        otherSideMirror.setHeight(otherSideState.height());
        otherSideMirror.setPortalShape(specialShape.getFlipped());
        otherSideMirror.setRotationTransformationForMirror(spacialRotation.getConjugated());
        McHelper.spawnServerEntity(thisSideMirror);
        McHelper.spawnServerEntity(otherSideMirror);
        Portal invisiblePortal = (Portal)Portal.ENTITY_TYPE.create(fromWorld);
        assert (invisiblePortal != null);
        invisiblePortal.setDestDim((ResourceKey<Level>)toWorld.dimension());
        invisiblePortal.setPortalState(UnilateralPortalState.combine(thisSideState, otherSideState));
        invisiblePortal.setPortalShape(specialShape);
        invisiblePortal.setIsVisible(false);
        invisiblePortal.setOriginPos(invisiblePortal.getOriginPos().add(portal.getNormal().scale(0.001)));
        invisiblePortal.setDestination(invisiblePortal.getDestPos().add(portal.getContentDirection().scale(0.001)));
        Portal reverseInvisiblePortal = PortalManipulation.createReversePortal(invisiblePortal, Portal.ENTITY_TYPE);
        McHelper.spawnServerEntity(invisiblePortal);
        McHelper.spawnServerEntity(reverseInvisiblePortal);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"The portal has been turned into a fake enterable mirror. You need to manually make the two sides symmetric. Two invisible portal entities are generated. If you want to remove that, don't forget to remove the invisible portals."), false);
    }

    private static void invokeSculpt(CommandContext<CommandSourceStack> context, Portal portal, boolean adjustPortalBounds) {
        Mesh2D mesh2D;
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        @Nullable ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        ObjectArrayList<AABB> boxes = PortalCommand.gatherCollisionBoxesTouching(portal);
        if (boxes.size() > 40000) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Too many collision boxes to sculpt"));
            return;
        }
        PortalShape originalPortalShape = portal.getPortalShape();
        if (originalPortalShape instanceof SpecialFlatPortalShape) {
            SpecialFlatPortalShape s = (SpecialFlatPortalShape)originalPortalShape;
            mesh2D = s.mesh.copy();
        } else {
            mesh2D = Mesh2D.createNewFullQuadMesh();
        }
        double halfWidth = portal.getWidth() / 2.0;
        double halfHeight = portal.getHeight() / 2.0;
        Vec3 axisW = portal.getAxisW();
        Vec3 axisH = portal.getAxisH();
        Plane plane = new Plane(portal.getOriginPos(), portal.getNormal());
        double areaBefore = mesh2D.getArea() * halfWidth * halfHeight;
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            int count = 0;
            for (AABB box : boxes) {
                ObjectArrayList<Vec2d> polygonVertexes = GeometryUtil.getSlicePolygonOfCube(box, plane, axisW, axisH, halfWidth, halfHeight);
                mesh2D.subtractPolygon(polygonVertexes);
                if (++count % 10000 != 0) continue;
                mesh2D.compact();
            }
            mesh2D.simplify();
            mesh2D.compact();
        }, Util.backgroundExecutor());
        future.thenRun(() -> server.execute(() -> {
            if (portal.isRemoved()) {
                return;
            }
            double meshArea = mesh2D.getArea();
            double areaAfter = meshArea * halfWidth * halfHeight;
            if (Math.abs(4.0 - meshArea) < 1.0E-5) {
                portal.setPortalShapeToDefault();
                if (player != null) {
                    player.sendSystemMessage((Component)Component.literal((String)"Portal shape is still rectangular now."));
                }
                return;
            }
            if (Math.abs(meshArea) < 1.0E-5) {
                if (player != null) {
                    player.sendSystemMessage((Component)Component.literal((String)"Sculpt failed because the blocks fully cover the portal."));
                }
                return;
            }
            PortalCommand.setPortalShapeByMesh(portal, mesh2D, adjustPortalBounds);
            portal.getDefaultAnimation().setDisableUntil(portal.level().getGameTime() + 5L);
            PortalCommand.reloadPortal(portal);
            if (player != null) {
                player.sendSystemMessage((Component)Component.translatable((String)"imm_ptl.sculpted", (Object[])new Object[]{String.format("%.4f", areaBefore - areaAfter), String.format("%.4f", areaBefore), String.format("%.4f", areaAfter)}));
            }
        }));
        future.exceptionally(throwable -> {
            LOGGER.error("Error when sculpting portal {}", (Object)portal, throwable);
            if (player != null) {
                player.sendSystemMessage((Component)Component.literal((String)"Failed to sculpt the portal. See the server log for detail."));
            }
            return null;
        });
        ServerTaskList.of(server).addTask(MyTaskList.withDelay(5, MyTaskList.oneShotTask(() -> {
            if (!future.isDone() && player != null) {
                player.sendSystemMessage((Component)Component.translatable((String)"imm_ptl.sculpting_in_progress"));
            }
        })));
    }

    private static void setPortalShapeByMesh(Portal portal, Mesh2D mesh2D, boolean adjustPortalBounds) {
        if (adjustPortalBounds) {
            Mesh2D.Rect boundingBox = mesh2D.getBoundingBox();
            double centerLX = (boundingBox.minX() + boundingBox.maxX()) / 2.0;
            double centerLY = (boundingBox.minY() + boundingBox.maxY()) / 2.0;
            double lWidth = boundingBox.maxX() - boundingBox.minX();
            double lHeight = boundingBox.maxY() - boundingBox.minY();
            mesh2D.transformPoints(input -> new Vec2d((input.x() - centerLX) / (lWidth / 2.0), (input.y() - centerLY) / (lHeight / 2.0)));
            double oldHalfWidth = portal.getWidth() / 2.0;
            double oldHalfHeight = portal.getHeight() / 2.0;
            double newPortalWidth = oldHalfWidth * lWidth;
            double newPortalHeight = oldHalfHeight * lHeight;
            Vec3 centerOffset = portal.getAxisW().scale(centerLX * oldHalfWidth).add(portal.getAxisH().scale(centerLY * oldHalfHeight));
            Vec3 otherSideCenterOffset = portal.transformLocalVec(centerOffset);
            portal.setOriginPos(portal.getOriginPos().add(centerOffset));
            portal.setDestination(portal.getDestPos().add(otherSideCenterOffset));
            portal.setWidth(newPortalWidth);
            portal.setHeight(newPortalHeight);
        }
        portal.setPortalShape(new SpecialFlatPortalShape(mesh2D));
    }

    @NotNull
    private static ObjectArrayList<AABB> gatherCollisionBoxesTouching(Portal portal) {
        AABB areaBox = portal.getBoundingBox();
        ObjectArrayList boxes = new ObjectArrayList();
        for (VoxelShape blockCollision : portal.level().getBlockCollisions((Entity)portal, areaBox)) {
            if (blockCollision.isEmpty()) continue;
            boxes.addAll((Collection)blockCollision.toAabbs());
        }
        return boxes;
    }

    public static interface PortalConsumerThrowsCommandSyntaxException {
        public void accept(Portal var1) throws CommandSyntaxException;
    }

    public static class RemoteCallables {
        public static void clientAccelerate(Vec3 vec) {
            Minecraft client = Minecraft.getInstance();
            LocalPlayer player = client.player;
            McHelper.setWorldVelocity((Entity)player, vec);
        }
    }
}

