/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.commands;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.RegisterEvent;

public class AxisArgumentType
implements ArgumentType<Direction.Axis> {
    public static final AxisArgumentType instance = new AxisArgumentType();
    public static final DynamicCommandExceptionType exceptionType = new DynamicCommandExceptionType(object -> Component.literal((String)("Invalid Axis " + String.valueOf(object))));

    public static <S> Direction.Axis getAxis(CommandContext<S> context, String argName) {
        return (Direction.Axis)context.getArgument(argName, Direction.Axis.class);
    }

    public Direction.Axis parse(StringReader reader) throws CommandSyntaxException {
        String s;
        return switch (s = reader.readUnquotedString()) {
            case "x", "X" -> Direction.Axis.X;
            case "y", "Y" -> Direction.Axis.Y;
            case "z", "Z" -> Direction.Axis.Z;
            default -> throw exceptionType.createWithContext((ImmutableStringReader)reader, (Object)s);
        };
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest((Iterable)Arrays.stream(Direction.Axis.values()).map(Enum::name).collect(Collectors.toList()), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Arrays.stream(Direction.Axis.values()).map(Enum::toString).collect(Collectors.toList());
    }

    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(RegisterEvent.class, registerEvent -> registerEvent.register(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.key(), ResourceLocation.parse((String)"imm_ptl:axis"), () -> ArgumentTypeInfos.registerByClass(AxisArgumentType.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(() -> instance))));
    }
}

