/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.collision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.collision.CollisionHelper;
import qouteall.imm_ptl.core.collision.PortalCollisionEntry;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Range;

public class PortalCollisionHandler {
    private static final int maxCollidingPortals = 6;
    public long lastActiveTime;
    public final List<PortalCollisionEntry> portalCollisions = new ArrayList<PortalCollisionEntry>();

    public boolean isRecentlyCollidingWithPortal(Entity entity) {
        return (long)PortalCollisionHandler.getTiming(entity) - this.lastActiveTime < 20L;
    }

    public void update(Entity entity) {
        this.portalCollisions.removeIf(p -> {
            if (p.portal.level() != entity.level()) {
                return true;
            }
            AABB stretchedBoundingBox = CollisionHelper.getStretchedBoundingBox(entity);
            if (!stretchedBoundingBox.inflate(0.5).intersects(p.portal.getBoundingBox())) {
                return true;
            }
            if (Math.abs((long)PortalCollisionHandler.getTiming(entity) - p.activeTime) >= 3L) {
                return true;
            }
            return !CollisionHelper.mayEntityCollideWithPortal(entity, p.portal, entity.getEyePosition(0.0f), entity.getBoundingBox());
        });
    }

    private static int getTiming(Entity entity) {
        return entity.tickCount;
    }

    public Vec3 handleCollision(Entity entity, Vec3 attemptedMove) {
        if (this.portalCollisions.isEmpty()) {
            return attemptedMove;
        }
        entity.level().getProfiler().push("cross_portal_collision");
        this.portalCollisions.sort(Comparator.comparingLong(p -> p.activeTime).reversed());
        Vec3 result = PortalCollisionHandler.doHandleCollision(entity, attemptedMove, 1, this.portalCollisions, entity.getBoundingBox());
        entity.level().getProfiler().pop();
        return result;
    }

    private static Vec3 doHandleCollision(Entity entity, Vec3 attemptedMove, int portalLayer, List<PortalCollisionEntry> portalCollisions, AABB originalBoundingBox) {
        Vec3 currentMove = attemptedMove;
        currentMove = PortalCollisionHandler.handleThisSideMove(entity, currentMove, originalBoundingBox, portalCollisions);
        for (PortalCollisionEntry portalCollision : portalCollisions) {
            Portal portal = portalCollision.portal;
            Vec3 eyePos = entity.getEyePosition(0.0f);
            currentMove = PortalCollisionHandler.handleOtherSideMove(entity, currentMove, portal, originalBoundingBox, portal.transformPoint(eyePos), portalLayer);
        }
        Vec3 r = new Vec3(CollisionHelper.fixCoordinateFloatingPointError(attemptedMove.x, currentMove.x), CollisionHelper.fixCoordinateFloatingPointError(attemptedMove.y, currentMove.y), CollisionHelper.fixCoordinateFloatingPointError(attemptedMove.z, currentMove.z));
        return r;
    }

    private static Vec3 handleOtherSideMove(Entity entity, Vec3 attemptedMove, Portal collidingPortal, AABB originalBoundingBox, Vec3 transformedEyePos, int portalLayer) {
        if (!collidingPortal.getHasCrossPortalCollision()) {
            return attemptedMove;
        }
        if (portalLayer >= 5) {
            return attemptedMove;
        }
        Vec3 transformedAttemptedMove = collidingPortal.transformLocalVec(attemptedMove);
        AABB boxOtherSide = CollisionHelper.transformBox(collidingPortal, originalBoundingBox);
        if (boxOtherSide == null) {
            return attemptedMove;
        }
        if (PortalCollisionHandler.isBoxTooBig(boxOtherSide)) {
            return attemptedMove;
        }
        Level destinationWorld = collidingPortal.getDestWorld();
        if (!destinationWorld.hasChunkAt(BlockPos.containing((Position)boxOtherSide.getCenter()))) {
            if (portalLayer <= 1) {
                return PortalCollisionHandler.handleOtherSideChunkNotLoaded(entity, attemptedMove, collidingPortal, originalBoundingBox);
            }
            return attemptedMove;
        }
        List<Portal> indirectCollidingPortals = McHelper.findEntitiesByBox(Portal.class, collidingPortal.getDestinationWorld(), boxOtherSide.expandTowards(transformedAttemptedMove), IPGlobal.maxNormalPortalRadius, p -> CollisionHelper.mayEntityCollideWithPortal(entity, p, transformedEyePos, boxOtherSide) && collidingPortal.isOnDestinationSide(p.getOriginPos(), 0.1));
        Direction transformedGravityDirection = collidingPortal.getTransformedGravityDirection(GravityChangerInterface.invoker.getGravityDirection(entity));
        Plane innerClipping = collidingPortal.getInnerClipping();
        Vec3 collided = transformedAttemptedMove;
        collided = CollisionHelper.handleCollisionWithShapeProcessor(entity, boxOtherSide, destinationWorld, collided, shape -> {
            VoxelShape current;
            VoxelShape voxelShape = current = innerClipping == null ? shape : CollisionHelper.clipVoxelShape(shape, innerClipping.pos(), innerClipping.normal());
            if (current == null) {
                return null;
            }
            if (!indirectCollidingPortals.isEmpty()) {
                current = PortalCollisionHandler.processThisSideCollisionShape(current, indirectCollidingPortals);
            }
            return current;
        }, transformedGravityDirection, collidingPortal.getScale());
        if (!indirectCollidingPortals.isEmpty()) {
            for (Portal indirectCollidingPortal : indirectCollidingPortals) {
                collided = PortalCollisionHandler.handleOtherSideMove(entity, collided, indirectCollidingPortal, boxOtherSide, collidingPortal.transformPoint(transformedEyePos), portalLayer + 1);
            }
        }
        collided = new Vec3(CollisionHelper.fixCoordinateFloatingPointError(transformedAttemptedMove.x, collided.x), CollisionHelper.fixCoordinateFloatingPointError(transformedAttemptedMove.y, collided.y), CollisionHelper.fixCoordinateFloatingPointError(transformedAttemptedMove.z, collided.z));
        Vec3 result = collidingPortal.inverseTransformLocalVec(collided);
        return result;
    }

    private static Vec3 handleOtherSideChunkNotLoaded(Entity entity, Vec3 attemptedMove, Portal collidingPortal, AABB originalBoundingBox) {
        if (entity instanceof Player && entity.level().isClientSide()) {
            CollisionHelper.informClientStagnant();
        }
        return collidingPortal.getPortalShape().getMovementForPushingEntityOutOfPortal(collidingPortal, collidingPortal.getThisSideState(), entity, attemptedMove);
    }

    private static Vec3 handleThisSideMove(Entity entity, Vec3 attemptedMove, AABB originalBoundingBox, List<PortalCollisionEntry> portalCollisions) {
        Direction gravity = GravityChangerInterface.invoker.getGravityDirection(entity);
        return CollisionHelper.handleCollisionWithShapeProcessor(entity, entity.getBoundingBox(), entity.level(), attemptedMove, shape -> PortalCollisionHandler.processThisSideCollisionShape(shape, Helper.mappedListView(portalCollisions, e -> e.portal)), gravity, 1.0);
    }

    @Nullable
    private static VoxelShape processThisSideCollisionShape(VoxelShape originalShape, List<Portal> portalCollisions) {
        VoxelShape shape = originalShape;
        if (shape.isEmpty()) {
            return shape;
        }
        AABB shapeBounds = shape.bounds();
        for (int i = 0; i < portalCollisions.size(); ++i) {
            VoxelShape exclusion;
            boolean boxFullyBehindPlane;
            Portal portal = portalCollisions.get(i);
            Plane clipping = portal.getPortalShape().getOuterClipping(portal.getThisSideState());
            if (clipping != null && !(boxFullyBehindPlane = CollisionHelper.isBoxFullyBehindPlane(clipping.pos(), clipping.normal(), shapeBounds)) || (exclusion = portal.getThisSideCollisionExclusion()) == null || exclusion.isEmpty()) continue;
            if (Helper.boxContains(exclusion.bounds(), shapeBounds)) {
                return null;
            }
            if ((shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)exclusion, (BooleanOp)BooleanOp.ONLY_FIRST)).isEmpty()) {
                return shape;
            }
            shapeBounds = shape.bounds();
        }
        return shape;
    }

    @Nullable
    public AABB getActiveCollisionBox(Entity entity, AABB rawBoundingBox) {
        AABB currentBox = rawBoundingBox;
        for (PortalCollisionEntry portalCollision : this.portalCollisions) {
            Portal portal = portalCollision.portal;
            AABB newBox = portal.getPortalShape().transformEntityActiveCollisionBox(portal, currentBox, entity);
            if (newBox == null) {
                return null;
            }
            currentBox = newBox;
        }
        return currentBox;
    }

    public static void updateCollidingPortalAfterTeleportation(Entity entity, Vec3 newEyePos, Vec3 newLastTickEyePos, float partialTicks) {
        ((IEEntity)entity).ip_clearCollidingPortal();
        McHelper.findEntitiesByBox(Portal.class, entity.level(), CollisionHelper.getStretchedBoundingBox(entity), IPGlobal.maxNormalPortalRadius, p -> true).forEach(p -> CollisionHelper.notifyCollidingPortals(p, partialTicks));
        McHelper.setEyePos(entity, newEyePos, newLastTickEyePos);
        McHelper.updateBoundingBox(entity);
    }

    public boolean hasCollisionEntry() {
        return !this.portalCollisions.isEmpty();
    }

    public void notifyCollidingWithPortal(Entity entity, Portal portal) {
        if (this.portalCollisions.size() >= 6) {
            return;
        }
        long timing = PortalCollisionHandler.getTiming(entity);
        int i = Helper.indexOf(this.portalCollisions, p -> p.portal == portal);
        if (i == -1) {
            this.portalCollisions.add(new PortalCollisionEntry(portal, timing));
        } else {
            this.portalCollisions.get((int)i).activeTime = timing;
        }
        portal.onCollidingWithEntity(entity);
        this.lastActiveTime = timing;
    }

    public List<Portal> getCollidingPortals() {
        return Helper.mappedListView(this.portalCollisions, p -> p.portal);
    }

    public static Vec3 getOffsetForPushingBoxOutOfAABB(AABB boxToPush, AABB portalBox, Vec3 movement) {
        double mz;
        double my;
        double mx;
        double absMovementX = Math.abs(movement.x);
        double absMovementY = Math.abs(movement.y);
        double absMovementZ = Math.abs(movement.z);
        if (absMovementX > absMovementY && absMovementX > absMovementZ && (mx = Range.getPushRangeMovement(boxToPush.minX, boxToPush.maxX, portalBox.minX, portalBox.maxX)) != 0.0) {
            return new Vec3(mx, 0.0, 0.0);
        }
        if (absMovementY > absMovementX && absMovementY > absMovementZ && (my = Range.getPushRangeMovement(boxToPush.minY, boxToPush.maxY, portalBox.minY, portalBox.maxY)) != 0.0) {
            return new Vec3(0.0, my, 0.0);
        }
        if (absMovementZ > absMovementX && absMovementZ > absMovementY && (mz = Range.getPushRangeMovement(boxToPush.minZ, boxToPush.maxZ, portalBox.minZ, portalBox.maxZ)) != 0.0) {
            return new Vec3(0.0, 0.0, mz);
        }
        return Vec3.ZERO;
    }

    public static Vec3 getOffsetForConfiningBoxInsideAABB(AABB boxToPush, AABB portalBox) {
        return new Vec3(Range.getConfineRangeMovement(boxToPush.minX, boxToPush.maxX, portalBox.minX, portalBox.maxX), Range.getConfineRangeMovement(boxToPush.minY, boxToPush.maxY, portalBox.minY, portalBox.maxY), Range.getConfineRangeMovement(boxToPush.minZ, boxToPush.maxZ, portalBox.minZ, portalBox.maxZ));
    }

    @Nullable
    public static Vec3 getOffsetForPushingBoxOutOfPlane(Vec3 origin, Vec3 normal, AABB movedBoundingBox) {
        Vec3 innerDirection = normal.scale(-1.0);
        double innerSignedDistance = Arrays.stream(Helper.eightVerticesOf(movedBoundingBox)).mapToDouble(pos -> pos.subtract(origin).dot(normal)).min().orElseThrow();
        if (innerSignedDistance < 0.0) {
            return normal.scale(-innerSignedDistance);
        }
        return null;
    }

    @NotNull
    public static Vec3 getMovementForPushingEntityOutOfPortal(Vec3 attemptedMove, Vec3 origin, Vec3 normal, AABB originalBoundingBox) {
        Vec3 innerDirection = normal.scale(-1.0);
        double innerSignedDistance = Arrays.stream(Helper.eightVerticesOf(originalBoundingBox)).mapToDouble(pos -> pos.subtract(origin).dot(normal)).min().orElseThrow();
        Vec3 attemptedMoveProjectedToInnerDirection = innerDirection.scale(innerDirection.dot(attemptedMove));
        if (innerSignedDistance < 0.0) {
            return attemptedMove.add(normal.scale(-innerSignedDistance)).subtract(attemptedMoveProjectedToInnerDirection);
        }
        return attemptedMove.subtract(attemptedMoveProjectedToInnerDirection);
    }

    private static boolean isBoxTooBig(AABB aabb) {
        return aabb.getXsize() > 100.0 || aabb.getYsize() > 100.0 || aabb.getZsize() > 100.0;
    }
}

