/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.collision;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ScaleUtils;
import qouteall.imm_ptl.core.collision.CollisionHelperClient;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.mixin.common.collision.IEEntity_Collision;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class CollisionHelper {
    private static final LimitedLogger limitedLogger = new LimitedLogger(20);
    private static boolean thisTickStagnate = false;
    private static boolean lastTickStagnate = false;

    @Nullable
    public static AABB clipBox(AABB box, Vec3 planePos, Vec3 planeNormal) {
        boolean isPushedPosInFrontOfPlane;
        boolean xForward = planeNormal.x > 0.0;
        boolean yForward = planeNormal.y > 0.0;
        boolean zForward = planeNormal.z > 0.0;
        Vec3 pushedPos = new Vec3(xForward ? box.minX : box.maxX, yForward ? box.minY : box.maxY, zForward ? box.minZ : box.maxZ);
        Vec3 staticPos = new Vec3(xForward ? box.maxX : box.minX, yForward ? box.maxY : box.minY, zForward ? box.maxZ : box.minZ);
        double tOfPushedPos = Helper.getCollidingT(planePos, planeNormal, pushedPos, planeNormal);
        boolean bl = isPushedPosInFrontOfPlane = tOfPushedPos < 0.0;
        if (isPushedPosInFrontOfPlane) {
            return box;
        }
        boolean isStaticPosInFrontOfPlane = Helper.isInFrontOfPlane(staticPos, planePos, planeNormal);
        if (!isStaticPosInFrontOfPlane) {
            return null;
        }
        Vec3 afterBeingPushed = pushedPos.add(planeNormal.scale(tOfPushedPos));
        return new AABB(afterBeingPushed, staticPos);
    }

    public static boolean isBoxFullyBehindPlane(Vec3 planePos, Vec3 planeNormal, AABB box) {
        boolean xForward = planeNormal.x > 0.0;
        boolean yForward = planeNormal.y > 0.0;
        boolean zForward = planeNormal.z > 0.0;
        Vec3 testingPos = new Vec3(xForward ? box.maxX : box.minX, yForward ? box.maxY : box.minY, zForward ? box.maxZ : box.minZ);
        return testingPos.subtract(planePos).dot(planeNormal) < 0.0;
    }

    public static boolean canCollideWithPortal(Entity entity, Portal portal, float partialTick) {
        return CollisionHelper.mayEntityCollideWithPortal(entity, portal, entity.getEyePosition(partialTick), entity.getBoundingBox());
    }

    public static boolean mayEntityCollideWithPortal(Entity entity, Portal portal, Vec3 entityEyePos, AABB entityBoundingBox) {
        if (!portal.canCollideWithEntity(entity)) {
            return false;
        }
        return portal.getPortalShape().canCollideWith(portal, portal.getThisSideState(), entityEyePos, entityBoundingBox);
    }

    public static double absMin(double a, double b) {
        return Math.abs(a) < Math.abs(b) ? a : b;
    }

    public static double fixCoordinateFloatingPointError(double attemptedMove, double result) {
        if (Math.abs(attemptedMove - result) < 0.001) {
            return attemptedMove;
        }
        if (Math.abs(result) < 1.0E-4) {
            return 0.0;
        }
        return result;
    }

    @Nullable
    public static VoxelShape clipVoxelShape(VoxelShape shape, Vec3 clippingPlanePos, Vec3 clippingPlaneNormal) {
        if (shape.isEmpty()) {
            return null;
        }
        AABB shapeBoundingBox = shape.bounds();
        boolean boxBehindPlane = CollisionHelper.isBoxFullyBehindPlane(clippingPlanePos, clippingPlaneNormal, shapeBoundingBox);
        if (boxBehindPlane) {
            return null;
        }
        boolean isFullyInFrontOfPlane = CollisionHelper.isBoxFullyBehindPlane(clippingPlanePos, clippingPlaneNormal.scale(-1.0), shapeBoundingBox);
        if (isFullyInFrontOfPlane) {
            return shape;
        }
        AABB clippedBoundingBox = CollisionHelper.clipBox(shapeBoundingBox, clippingPlanePos, clippingPlaneNormal);
        if (clippedBoundingBox == null) {
            return null;
        }
        VoxelShape result = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)clippedBoundingBox), (BooleanOp)BooleanOp.AND);
        return result;
    }

    private static Vec3 refHandleCollisionWithShapeProcessor(Entity entity, Vec3 attemptedMove, Function<VoxelShape, VoxelShape> filter) {
        AABB boundingBox = entity.getBoundingBox();
        List entityCollisions = entity.level().getEntityCollisions(entity, boundingBox.expandTowards(attemptedMove));
        BiFunction<Vec3, AABB, Vec3> collisionFunc = (attempt, bb) -> CollisionHelper.collideBoundingBox(entity, attempt, bb, entity.level(), entityCollisions, filter);
        Vec3 collidedMovement = attemptedMove.lengthSqr() == 0.0 ? attemptedMove : collisionFunc.apply(attemptedMove, boundingBox);
        boolean collideX = attemptedMove.x != collidedMovement.x;
        boolean collideY = attemptedMove.y != collidedMovement.y;
        boolean collideZ = attemptedMove.z != collidedMovement.z;
        boolean collidesWithFloor = collideY && attemptedMove.y < 0.0;
        boolean touchGround = entity.onGround() || collidesWithFloor;
        boolean collidesHorizontally = collideX || collideZ;
        float maxUpStep = entity.maxUpStep();
        if (maxUpStep > 0.0f && touchGround && collidesHorizontally) {
            Vec3 horizontalMoveAfterVerticalStepping;
            Vec3 stepping = collisionFunc.apply(new Vec3(attemptedMove.x, (double)maxUpStep, attemptedMove.z), boundingBox);
            Vec3 verticalStep = collisionFunc.apply(new Vec3(0.0, (double)maxUpStep, 0.0), boundingBox.expandTowards(attemptedMove.x, 0.0, attemptedMove.z));
            if (verticalStep.y < (double)maxUpStep && (horizontalMoveAfterVerticalStepping = collisionFunc.apply(new Vec3(attemptedMove.x, 0.0, attemptedMove.z), boundingBox.move(verticalStep)).add(verticalStep)).horizontalDistanceSqr() > stepping.horizontalDistanceSqr()) {
                stepping = horizontalMoveAfterVerticalStepping;
            }
            if (stepping.horizontalDistanceSqr() > collidedMovement.horizontalDistanceSqr()) {
                Vec3 movingDown = collisionFunc.apply(new Vec3(0.0, -stepping.y + attemptedMove.y, 0.0), boundingBox.move(stepping));
                return stepping.add(movingDown);
            }
        }
        return collidedMovement;
    }

    @IPVanillaCopy
    public static Vec3 handleCollisionWithShapeProcessor(Entity entity, AABB boundingBox, Level world, Vec3 attemptedMove, Function<VoxelShape, VoxelShape> filter, Direction gravity, double steppingScale) {
        Direction jumpDirection = gravity.getOpposite();
        Direction.Axis gravityAxis = gravity.getAxis();
        List entityCollisions = world.getEntityCollisions(entity, boundingBox.expandTowards(attemptedMove));
        BiFunction<Vec3, AABB, Vec3> collisionFunc = (attempt, bb) -> CollisionHelper.collideBoundingBox(entity, attempt, bb, world, entityCollisions, filter);
        Vec3 collidedMovement = attemptedMove.lengthSqr() == 0.0 ? attemptedMove : collisionFunc.apply(attemptedMove, boundingBox);
        Vec3 collisionDelta = attemptedMove.subtract(collidedMovement);
        boolean collidesOnGravityAxis = Helper.getCoordinate(collisionDelta, gravityAxis) != 0.0;
        boolean attemptToMoveAlongGravity = Helper.getSignedCoordinate(attemptedMove, gravity) > 0.0;
        boolean collidesWithFloor = collidesOnGravityAxis && attemptToMoveAlongGravity;
        boolean touchGround = entity.onGround() || collidesWithFloor;
        boolean collidesHorizontally = CollisionHelper.movesOnNonGravityAxis(collisionDelta, gravityAxis);
        double maxUpStep = entity.maxUpStep();
        if (steppingScale > 1.0) {
            maxUpStep *= steppingScale;
        }
        if (maxUpStep > 0.0 && touchGround && collidesHorizontally) {
            Vec3 horizontalMoveAfterVerticalStepping;
            Vec3 stepping = collisionFunc.apply(Helper.putSignedCoordinate(attemptedMove, jumpDirection, maxUpStep), boundingBox);
            Vec3 expandVec = Helper.putSignedCoordinate(attemptedMove, gravity, 0.0);
            Vec3 verticalStep = collisionFunc.apply(Helper.putSignedCoordinate(Vec3.ZERO, jumpDirection, maxUpStep), boundingBox.expandTowards(expandVec));
            if (Helper.getSignedCoordinate(verticalStep, jumpDirection) < maxUpStep + 0.001 && Helper.getDistanceSqrOnAxisPlane(horizontalMoveAfterVerticalStepping = collisionFunc.apply(expandVec, boundingBox.move(verticalStep)).add(verticalStep), gravityAxis) > Helper.getDistanceSqrOnAxisPlane(stepping, gravityAxis)) {
                stepping = horizontalMoveAfterVerticalStepping;
            }
            if (Helper.getDistanceSqrOnAxisPlane(stepping, gravityAxis) > Helper.getDistanceSqrOnAxisPlane(collidedMovement, gravityAxis)) {
                double steppingVerticalLen = Helper.getSignedCoordinate(stepping, jumpDirection);
                double attemptMoveVerticalLen = Helper.getSignedCoordinate(attemptedMove, jumpDirection);
                Vec3 movingDown = collisionFunc.apply(Helper.putSignedCoordinate(Vec3.ZERO, jumpDirection, -steppingVerticalLen + attemptMoveVerticalLen), boundingBox.move(stepping));
                return stepping.add(movingDown);
            }
        }
        return collidedMovement;
    }

    public static boolean movesOnNonGravityAxis(Vec3 vec, Direction.Axis gravityAxis) {
        return switch (gravityAxis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                if (vec.y != 0.0 || vec.z != 0.0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (vec.x != 0.0 || vec.z != 0.0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> vec.x != 0.0 || vec.y != 0.0;
        };
    }

    @IPVanillaCopy
    public static Vec3 collideBoundingBox(Entity entity, Vec3 vec, AABB collisionBox, Level level, List<VoxelShape> potentialHits, Function<VoxelShape, VoxelShape> shapeProcessor) {
        boolean addWorldBorderCollision;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(potentialHits.size() + 1));
        for (VoxelShape potentialHit : potentialHits) {
            VoxelShape processed = shapeProcessor.apply(potentialHit);
            if (processed == null) continue;
            builder.add((Object)processed);
        }
        WorldBorder worldBorder = level.getWorldBorder();
        Vec3 boundingBoxCenter = collisionBox.getCenter();
        boolean bl = addWorldBorderCollision = worldBorder.isWithinBounds(boundingBoxCenter.x, boundingBoxCenter.z) && worldBorder.getDistanceToBorder(boundingBoxCenter.x, boundingBoxCenter.z) < 32.0;
        if (addWorldBorderCollision) {
            builder.add((Object)worldBorder.getCollisionShape());
        }
        Iterable blockCollisions = level.getBlockCollisions(entity, collisionBox.expandTowards(vec));
        for (VoxelShape blockCollision : blockCollisions) {
            VoxelShape processed = shapeProcessor.apply(blockCollision);
            if (processed == null) continue;
            builder.add((Object)processed);
        }
        return IEEntity_Collision.ip_CollideWithShapes(vec, collisionBox, (List<VoxelShape>)builder.build());
    }

    public static AABB transformBox(Portal portal, AABB originalBox) {
        if (portal.getRotation() == null && portal.getScale() == 1.0) {
            return originalBox.move(portal.getDestPos().subtract(portal.getOriginPos()));
        }
        return Helper.transformBox(originalBox, portal::transformPoint);
    }

    @Deprecated
    public static Level getWorld(boolean isClient, ResourceKey<Level> dimension) {
        if (isClient) {
            return CHelper.getClientWorld(dimension);
        }
        return MiscHelper.getServer().getLevel(dimension);
    }

    public static boolean isCollidingWithAnyPortal(Entity entity) {
        return ((IEEntity)entity).ip_getCollidingPortal() != null;
    }

    public static void updateCollidingPortalForWorld(Level world, float partialTick) {
        world.getProfiler().push("update_colliding_portal");
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
        Iterable<Entity> worldEntityList = McHelper.getWorldEntityList(world);
        for (Entity entity : worldEntityList) {
            if (entity instanceof Portal) {
                Portal portal = (Portal)entity;
                CollisionHelper.notifyCollidingPortals(portal, partialTick);
                continue;
            }
            AABB entityBoundingBoxStretched = CollisionHelper.getStretchedBoundingBox(entity);
            for (Portal globalPortal : globalPortals) {
                AABB globalPortalBoundingBox = globalPortal.getBoundingBox();
                if (!entityBoundingBoxStretched.intersects(globalPortalBoundingBox) || !CollisionHelper.canCollideWithPortal(entity, globalPortal, partialTick)) continue;
                ((IEEntity)entity).ip_notifyCollidingWithPortal(globalPortal);
            }
        }
        world.getProfiler().pop();
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(ServerTickEvent.Post.class, event -> {
            for (ServerLevel world : event.getServer().getAllLevels()) {
                CollisionHelper.updateCollidingPortalForWorld((Level)world, 0.0f);
            }
        });
    }

    public static void initClient() {
        NeoForge.EVENT_BUS.addListener(IPGlobal.PostClientTickEvent.class, postClientTickEvent -> CollisionHelper.tickClient());
    }

    public static void tickClient() {
        CollisionHelperClient.updateClientCollidingStatus();
        CollisionHelper.updateClientStagnateStatus();
    }

    public static void notifyCollidingPortals(Portal portal, float partialTick) {
        if (!portal.isTeleportable()) {
            return;
        }
        AABB portalBoundingBox = portal.getBoundingBox();
        McHelper.foreachEntitiesByBoxApproximateRegions(Entity.class, portal.level(), portalBoundingBox, 8.0, entity -> {
            if (entity instanceof Portal) {
                return;
            }
            AABB entityBoxStretched = CollisionHelper.getStretchedBoundingBox(entity);
            if (!entityBoxStretched.intersects(portalBoundingBox)) {
                return;
            }
            boolean canCollideWithPortal = CollisionHelper.canCollideWithPortal(entity, portal, partialTick);
            if (!canCollideWithPortal) {
                return;
            }
            ((IEEntity)entity).ip_notifyCollidingWithPortal(portal);
        });
    }

    public static AABB getStretchedBoundingBox(Entity entity) {
        Vec3 backwardExpand = McHelper.lastTickPosOf(entity).subtract(entity.position());
        Vec3 forwardExpand = McHelper.getWorldVelocity(entity);
        AABB box = entity.getBoundingBox().expandTowards(forwardExpand.scale(1.2)).expandTowards(backwardExpand);
        double scale = ScaleUtils.getScale(entity);
        if (scale > 4.0) {
            box = box.inflate(scale);
        }
        return box;
    }

    public static void informClientStagnant() {
        thisTickStagnate = true;
        limitedLogger.log("client movement stagnated");
    }

    private static void updateClientStagnateStatus() {
        if (thisTickStagnate && lastTickStagnate) {
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"imm_ptl.stagnate_movement"), false);
        } else if (!thisTickStagnate && lastTickStagnate) {
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.literal((String)""), false);
        }
        lastTickStagnate = thisTickStagnate;
        thisTickStagnate = false;
    }

    @Nullable
    public static AABB getTotalBlockCollisionBox(Entity entity, AABB box, Function<VoxelShape, VoxelShape> shapeFilter) {
        Iterable collisions = entity.level().getBlockCollisions(entity, box);
        AABB collisionUnion = null;
        for (VoxelShape c : collisions) {
            VoxelShape currCollision = shapeFilter.apply(c);
            if (currCollision == null || currCollision.isEmpty()) continue;
            AABB collisionBoundingBox = currCollision.bounds();
            if (collisionUnion == null) {
                collisionUnion = collisionBoundingBox;
                continue;
            }
            collisionUnion = collisionUnion.minmax(collisionBoundingBox);
        }
        return collisionUnion;
    }
}

