/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTracking;
import qouteall.imm_ptl.core.network.PacketRedirection;

public class WorldInfoSender {
    public static void init() {
        NeoForge.EVENT_BUS.addListener(ServerTickEvent.Post.class, event -> {
            event.getServer().getProfiler().push("portal_send_world_info");
            if (McHelper.getServerGameTime() % 100L == 42L) {
                for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
                    Set<ResourceKey<Level>> visibleDimensions = ImmPtlChunkTracking.getVisibleDimensions(player);
                    if (player.level().dimension() != Level.OVERWORLD) {
                        ServerLevel overworld = event.getServer().getLevel(Level.OVERWORLD);
                        Validate.notNull((Object)overworld, (String)"missing overworld", (Object[])new Object[0]);
                        WorldInfoSender.sendWorldInfo(player, overworld);
                    }
                    event.getServer().getAllLevels().forEach(thisWorld -> {
                        if (WorldInfoSender.isNonOverworldSurfaceDimension((Level)thisWorld) && visibleDimensions.contains(thisWorld.dimension())) {
                            WorldInfoSender.sendWorldInfo(player, thisWorld);
                        }
                    });
                }
            }
            event.getServer().getProfiler().pop();
        });
    }

    public static void sendWorldInfo(ServerPlayer player, ServerLevel world) {
        ResourceKey remoteDimension = world.dimension();
        PacketRedirection.sendRedirectedMessage(player, (ResourceKey<Level>)remoteDimension, (Packet<ClientGamePacketListener>)new ClientboundSetTimePacket(world.getGameTime(), world.getDayTime(), world.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)));
        if (world.isRaining()) {
            PacketRedirection.sendRedirectedMessage(player, (ResourceKey<Level>)world.dimension(), (Packet<ClientGamePacketListener>)new ClientboundGameEventPacket(ClientboundGameEventPacket.START_RAINING, 0.0f));
        }
        PacketRedirection.sendRedirectedMessage(player, (ResourceKey<Level>)world.dimension(), (Packet<ClientGamePacketListener>)new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, world.getRainLevel(1.0f)));
        PacketRedirection.sendRedirectedMessage(player, (ResourceKey<Level>)world.dimension(), (Packet<ClientGamePacketListener>)new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, world.getThunderLevel(1.0f)));
    }

    public static boolean isNonOverworldSurfaceDimension(Level world) {
        return world.dimensionType().hasSkyLight() && world.dimension() != Level.OVERWORLD;
    }
}

