/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.chunk_loading.PerformanceLevel;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class ServerPerformanceMonitor {
    private static final int sampleNum = 20;
    private static PerformanceLevel level = PerformanceLevel.bad;
    private static final LimitedLogger limitedLogger = new LimitedLogger(50);
    private static long lastUpdateTime = 0L;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(ServerTickEvent.Post.class, event -> ServerPerformanceMonitor.tick(event.getServer()));
    }

    private static void tick(MinecraftServer server) {
        if (!IPGlobal.enableServerPerformanceAdjustment) {
            level = PerformanceLevel.good;
            return;
        }
        if (!server.isRunning()) {
            return;
        }
        long currTime = System.nanoTime();
        if (currTime - lastUpdateTime < Helper.secondToNano(20.0)) {
            return;
        }
        lastUpdateTime = currTime;
        PerformanceLevel newLevel = PerformanceLevel.getServerPerformanceLevel(server);
        if (newLevel != level) {
            level = newLevel;
            limitedLogger.log("Server performance level: " + String.valueOf((Object)newLevel));
        }
    }

    public static PerformanceLevel getLevel() {
        return level;
    }
}

