/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerTickRateManager;

public enum PerformanceLevel {
    good,
    medium,
    bad;


    public static PerformanceLevel getClientPerformanceLevel(int averageFPS, int averageFreeMemoryMB) {
        if (averageFPS > 50 && averageFreeMemoryMB > 800) {
            return good;
        }
        if (averageFPS > 30 && averageFreeMemoryMB > 300) {
            return medium;
        }
        return bad;
    }

    public static PerformanceLevel getServerPerformanceLevel(MinecraftServer server) {
        long nanosecondsPerTick;
        ServerTickRateManager tickRateManager = server.tickRateManager();
        long averageTickTimeNanos = server.getAverageTickTimeNanos();
        if ((double)averageTickTimeNanos < (double)(nanosecondsPerTick = tickRateManager.nanosecondsPerTick()) * 0.8) {
            return good;
        }
        if (averageTickTimeNanos < nanosecondsPerTick) {
            return medium;
        }
        return bad;
    }

    public static int getVisiblePortalRangeChunks(PerformanceLevel level) {
        if (level == good) {
            return 8;
        }
        if (level == medium) {
            return 3;
        }
        return 1;
    }

    public static int getIndirectVisiblePortalRangeChunks(PerformanceLevel level) {
        if (level == good) {
            return 2;
        }
        if (level == medium) {
            return 1;
        }
        return 0;
    }

    public static int getIndirectLoadingRadiusCap(PerformanceLevel level) {
        if (level == good) {
            return 32;
        }
        if (level == medium) {
            return 7;
        }
        return 2;
    }

    public static int getPortalRenderingDistance(PerformanceLevel level, int originalDistance) {
        if (level == good) {
            return originalDistance;
        }
        if (level == medium) {
            return Math.max(2, originalDistance / 2);
        }
        return 2;
    }
}

