/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.q_misc_util.my_util.SignalArged;

@IPVanillaCopy
public class ImmPtlClientChunkMap
extends ClientChunkCache {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Long2ObjectOpenHashMap<LevelChunk> chunkMapForMainThread = new Long2ObjectOpenHashMap();
    protected final Long2ObjectOpenHashMap<LevelChunk> chunkMapForOtherThreads = new Long2ObjectOpenHashMap();
    public final Thread mainThread = ((IEMinecraftClient)Minecraft.getInstance()).ip_getRunningThread();
    public static final SignalArged<LevelChunk> clientChunkLoadSignal = new SignalArged();
    public static final SignalArged<LevelChunk> clientChunkUnloadSignal = new SignalArged();

    public ImmPtlClientChunkMap(ClientLevel clientWorld, int loadDistance) {
        super(clientWorld, 1);
    }

    public void drop(ChunkPos chunkPos) {
        Validate.isTrue((Thread.currentThread() == this.mainThread ? 1 : 0) != 0);
        LevelChunk chunk = (LevelChunk)this.chunkMapForMainThread.get(chunkPos.toLong());
        if (chunk != null) {
            this.modifyChunkMap(chunkMap -> chunkMap.remove(chunkPos.toLong()));
            O_O.postClientChunkUnloadEvent(chunk);
            this.level.unload(chunk);
            SodiumInterface.invoker.onClientChunkUnloaded(this.level, chunkPos.x, chunkPos.z);
            clientChunkUnloadSignal.emit(chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readChunkMap(Function<Long2ObjectOpenHashMap<LevelChunk>, T> func) {
        if (Thread.currentThread() == this.mainThread) {
            return func.apply(this.chunkMapForMainThread);
        }
        Long2ObjectOpenHashMap<LevelChunk> long2ObjectOpenHashMap = this.chunkMapForOtherThreads;
        synchronized (long2ObjectOpenHashMap) {
            return func.apply(this.chunkMapForOtherThreads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyChunkMap(Consumer<Long2ObjectOpenHashMap<LevelChunk>> func) {
        Validate.isTrue((Thread.currentThread() == this.mainThread ? 1 : 0) != 0);
        func.accept(this.chunkMapForMainThread);
        Long2ObjectOpenHashMap<LevelChunk> long2ObjectOpenHashMap = this.chunkMapForOtherThreads;
        synchronized (long2ObjectOpenHashMap) {
            func.accept(this.chunkMapForOtherThreads);
        }
    }

    public LevelChunk getChunk(int x, int z, ChunkStatus chunkStatus, boolean create) {
        return this.readChunkMap(chunkMap -> {
            LevelChunk chunk = (LevelChunk)chunkMap.get(ChunkPos.asLong((int)x, (int)z));
            if (chunk != null) {
                return chunk;
            }
            return create ? this.emptyChunk : null;
        });
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.readChunkMap(chunkMap -> chunkMap.containsKey(ChunkPos.asLong((int)x, (int)z)));
    }

    public void replaceBiomes(int x, int z, FriendlyByteBuf friendlyByteBuf) {
        Validate.isTrue((Thread.currentThread() == this.mainThread ? 1 : 0) != 0);
        long chunkPosLong = ChunkPos.asLong((int)x, (int)z);
        LevelChunk worldChunk = (LevelChunk)this.chunkMapForMainThread.get(chunkPosLong);
        ChunkPos chunkPos = new ChunkPos(x, z);
        if (worldChunk == null) {
            LOGGER.error("Trying to replace biomes for missing chunk {} {}", (Object)x, (Object)z);
        } else {
            worldChunk.replaceBiomes(friendlyByteBuf);
        }
    }

    public LevelChunk replaceWithPacketData(int x, int z, FriendlyByteBuf buf, CompoundTag nbt, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer) {
        Validate.isTrue((Thread.currentThread() == this.mainThread ? 1 : 0) != 0);
        long chunkPosLong = ChunkPos.asLong((int)x, (int)z);
        LevelChunk worldChunk = (LevelChunk)this.chunkMapForMainThread.get(chunkPosLong);
        if (worldChunk == null) {
            worldChunk = new LevelChunk((Level)this.level, new ChunkPos(x, z));
            this.loadChunkDataFromPacket(buf, nbt, worldChunk, consumer);
            LevelChunk worldChunkToPut = worldChunk;
            this.modifyChunkMap(chunkMap -> chunkMap.put(chunkPosLong, (Object)worldChunkToPut));
        } else {
            this.loadChunkDataFromPacket(buf, nbt, worldChunk, consumer);
        }
        this.level.onChunkLoaded(new ChunkPos(x, z));
        O_O.postClientChunkLoadEvent(worldChunk);
        SodiumInterface.invoker.onClientChunkLoaded(this.level, x, z);
        clientChunkLoadSignal.emit(worldChunk);
        return worldChunk;
    }

    private void loadChunkDataFromPacket(FriendlyByteBuf buf, CompoundTag nbt, LevelChunk worldChunk, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer) {
        try {
            worldChunk.replaceWithPacketData(buf, nbt, consumer);
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing chunk packet {} {}", (Object)worldChunk.getLevel().dimension().location(), (Object)worldChunk.getPos(), (Object)e);
            CHelper.printChat((Component)Component.literal((String)"Failed to deserialize chunk packet. %s %s %s".formatted(worldChunk.getLevel().dimension().location(), worldChunk.getPos().x, worldChunk.getPos().z)).append((Component)Component.literal((String)" Report issue:")).append((Component)McHelper.getLinkText(O_O.getIssueLink())).withStyle(ChatFormatting.RED));
            throw new RuntimeException(e);
        }
    }

    public List<LevelChunk> getCopiedChunkList() {
        return this.readChunkMap(chunkMap -> Arrays.asList((LevelChunk[])chunkMap.values().toArray((Object[])new LevelChunk[0])));
    }

    public void updateViewCenter(int x, int z) {
    }

    public void updateViewRadius(int r) {
    }

    public String gatherStats() {
        return "Client Chunks (ImmPtl) " + this.getLoadedChunksCount();
    }

    public int getLoadedChunksCount() {
        return this.readChunkMap(chunkMap -> chunkMap.size());
    }

    public void onLightUpdate(LightLayer lightType, SectionPos chunkSectionPos) {
        ClientWorldLoader.getWorldRenderer((ResourceKey<Level>)this.level.dimension()).setSectionDirty(chunkSectionPos.x(), chunkSectionPos.y(), chunkSectionPos.z());
    }
}

