/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import com.mojang.logging.LogUtils;
import de.nick1st.imm_ptl.events.DimensionEvents;
import de.nick1st.imm_ptl.events.ServerCleanupEvent;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.ChunkVisibility;
import qouteall.imm_ptl.core.chunk_loading.EntitySync;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTickets;
import qouteall.imm_ptl.core.chunk_loading.PerformanceLevel;
import qouteall.imm_ptl.core.chunk_loading.PlayerChunkLoading;
import qouteall.imm_ptl.core.ducks.IEChunkMap;
import qouteall.imm_ptl.core.mixin.common.chunk_sync.IEServerCommonPacketListenerImpl;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.q_misc_util.my_util.IntBox;

public class ImmPtlChunkTracking {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int updateInterval = 13;
    public static final int defaultDelayUnloadGenerations = 4;
    private static final Map<ResourceKey<Level>, Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord>>> chunkWatchRecords = new Object2ObjectOpenHashMap();
    private static final ArrayList<ChunkLoader> additionalChunkLoaders = new ArrayList();
    private static final Object2ObjectOpenHashMap<ServerPlayer, PlayerChunkLoading> playerInfoMap = new Object2ObjectOpenHashMap();
    private static int generationCounter = 0;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(ServerTickEvent.Post.class, event -> ImmPtlChunkTracking.tick(event.getServer()));
        NeoForge.EVENT_BUS.addListener(ServerCleanupEvent.class, event -> {
            MinecraftServer server = event.server;
            ImmPtlChunkTracking.cleanup(server);
        });
        NeoForge.EVENT_BUS.addListener(DimensionEvents.BeforeRemovingDimensionEvent.class, beforeRemovingDimensionEvent -> ImmPtlChunkTracking.onDimensionRemove(beforeRemovingDimensionEvent.dimension));
    }

    public static void onChunkProvidedDeferred(LevelChunk chunk) {
    }

    public static void removePlayerFromChunkTrackersAndEntityTrackers(ServerPlayer oldPlayer) {
        for (ServerLevel world : oldPlayer.server.getAllLevels()) {
            ServerChunkCache chunkManager = world.getChunkSource();
            IEChunkMap storage = (IEChunkMap)chunkManager.chunkMap;
            storage.ip_onPlayerUnload(oldPlayer);
        }
        ImmPtlChunkTracking.forceRemovePlayer(oldPlayer);
    }

    public static void onDimensionRemove(ServerLevel world) {
        ServerChunkCache chunkManager = world.getChunkSource();
        IEChunkMap storage = (IEChunkMap)chunkManager.chunkMap;
        storage.ip_onDimensionRemove();
        ImmPtlChunkTracking.forceRemoveDimension(world);
    }

    private static Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord>> getDimChunkWatchRecords(ResourceKey<Level> dimension) {
        return chunkWatchRecords.computeIfAbsent(dimension, k -> new Long2ObjectOpenHashMap());
    }

    public static PlayerChunkLoading getPlayerInfo(ServerPlayer player) {
        return (PlayerChunkLoading)playerInfoMap.computeIfAbsent((Object)player, p -> new PlayerChunkLoading(((IEServerCommonPacketListenerImpl)p.connection).ip_getConnection().isMemoryConnection()));
    }

    public static void immediatelyUpdateForPlayer(ServerPlayer player) {
        ImmPtlChunkTracking.updateForPlayer(player);
        ImmPtlChunkTracking.getPlayerInfo(player).doChunkSending(player);
        EntitySync.update(player.server);
    }

    public static void updateForPlayer(ServerPlayer player) {
        PlayerChunkLoading playerInfo = ImmPtlChunkTracking.getPlayerInfo(player);
        playerInfo.visibleDimensions.clear();
        int lastLoadedChunks = playerInfo.loadedChunks;
        playerInfo.loadedChunks = 0;
        ObjectOpenHashSet chunkLoaders = new ObjectOpenHashSet();
        ChunkVisibility.foreachBaseChunkLoaders(player, arg_0 -> ((ObjectOpenHashSet)chunkLoaders).add(arg_0));
        chunkLoaders.addAll(playerInfo.additionalChunkLoaders);
        MinecraftServer server = player.server;
        for (ChunkLoader chunkLoader : chunkLoaders) {
            ResourceKey<Level> dimension = chunkLoader.dimension();
            Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord>> chunkRecordMap = ImmPtlChunkTracking.getDimChunkWatchRecords(dimension);
            ServerLevel world = server.getLevel(dimension);
            if (world == null) {
                LOGGER.warn("Dimension not loaded {} in chunk loader {}", dimension, (Object)chunkLoader);
                return;
            }
            playerInfo.visibleDimensions.add(dimension);
            ImmPtlChunkTickets ticketInfo = ImmPtlChunkTickets.get(world);
            chunkLoader.foreachChunkPos((dim, x, z, distanceToSource) -> {
                long chunkPos = ChunkPos.asLong((int)x, (int)z);
                Object2ObjectOpenHashMap records = (Object2ObjectOpenHashMap)chunkRecordMap.computeIfAbsent(chunkPos, k -> new Object2ObjectOpenHashMap());
                ticketInfo.markForLoading(chunkPos, distanceToSource, generationCounter);
                records.compute((Object)player, (k, record) -> {
                    boolean isBoundary;
                    boolean bl = isBoundary = distanceToSource == chunkLoader.radius();
                    if (record == null) {
                        PlayerWatchRecord newRecord = new PlayerWatchRecord(player, dimension, chunkPos, generationCounter, distanceToSource, false, isBoundary);
                        playerInfo.markPendingLoading(newRecord);
                        ++playerInfo.loadedChunks;
                        return newRecord;
                    }
                    int oldDistance = record.distanceToSource;
                    if (record.lastWatchGeneration == generationCounter) {
                        if (distanceToSource < oldDistance) {
                            record.distanceToSource = distanceToSource;
                            playerInfo.markPendingLoading((PlayerWatchRecord)record);
                        }
                        record.isBoundary = record.isBoundary && isBoundary;
                    } else {
                        ++playerInfo.loadedChunks;
                        if (distanceToSource < oldDistance) {
                            playerInfo.markPendingLoading((PlayerWatchRecord)record);
                        }
                        record.distanceToSource = distanceToSource;
                        record.lastWatchGeneration = generationCounter;
                        record.isBoundary = isBoundary;
                    }
                    return record;
                });
            });
        }
    }

    private static void purge(MinecraftServer server, Object2ObjectOpenHashMap<ResourceKey<Level>, LongOpenHashSet> additionalLoadedChunks) {
        chunkWatchRecords.forEach((dimension, chunkRecords) -> chunkRecords.long2ObjectEntrySet().removeIf(entry -> {
            long chunkPosLong = entry.getLongKey();
            Object2ObjectOpenHashMap dimChunkWatchRecords = (Object2ObjectOpenHashMap)entry.getValue();
            dimChunkWatchRecords.entrySet().removeIf(e -> {
                boolean shouldRemove;
                ServerPlayer player = (ServerPlayer)e.getKey();
                if (player.isRemoved()) {
                    return true;
                }
                PlayerWatchRecord record = (PlayerWatchRecord)e.getValue();
                int delayUnloadGenerations = ImmPtlChunkTracking.getDelayUnloadGenerationForPlayer(player);
                boolean bl = shouldRemove = generationCounter - record.lastWatchGeneration > delayUnloadGenerations;
                if (shouldRemove) {
                    if (record.isLoadedToPlayer) {
                        EventHooks.fireChunkUnWatch((ServerPlayer)player, (ChunkPos)new ChunkPos(record.chunkPos), (ServerLevel)player.getServer().getLevel(record.dimension));
                        player.connection.send(PacketRedirection.createRedirectedMessage(player.getServer(), record.dimension, (Packet<ClientGamePacketListener>)new ClientboundForgetLevelChunkPacket(new ChunkPos(record.chunkPos))));
                    }
                    record.isValid = false;
                }
                return shouldRemove;
            });
            return dimChunkWatchRecords.isEmpty();
        }));
        playerInfoMap.entrySet().removeIf(e -> ((ServerPlayer)e.getKey()).isRemoved());
        for (ServerLevel world : server.getAllLevels()) {
            ResourceKey dimension2 = world.dimension();
            @Nullable LongOpenHashSet additional = (LongOpenHashSet)additionalLoadedChunks.get((Object)dimension2);
            Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord>> watchRecs = chunkWatchRecords.get(dimension2);
            ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
            dimTicketManager.purge(world, chunkPos -> {
                if (watchRecs != null && watchRecs.containsKey(chunkPos)) {
                    return true;
                }
                return additional != null && additional.contains(chunkPos);
            });
        }
    }

    private static int getDelayUnloadGenerationForPlayer(ServerPlayer player) {
        PlayerChunkLoading playerInfo = ImmPtlChunkTracking.getPlayerInfo(player);
        if (playerInfo == null) {
            return 4;
        }
        int loadedChunks = playerInfo.loadedChunks;
        if (loadedChunks > 2000) {
            return 1;
        }
        if (loadedChunks > 1200) {
            return 2;
        }
        return 4;
    }

    private static Object2ObjectOpenHashMap<ResourceKey<Level>, LongOpenHashSet> refreshAdditionalChunkLoaders(MinecraftServer server) {
        Object2ObjectOpenHashMap additionalLoadedChunks = new Object2ObjectOpenHashMap();
        additionalChunkLoaders.removeIf(chunkLoader -> {
            ResourceKey<Level> dimension = chunkLoader.dimension();
            ServerLevel world = server.getLevel(dimension);
            if (world == null) {
                LOGGER.error("Missing dimension in chunk loader {}", (Object)dimension.location());
                return true;
            }
            final ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
            final LongOpenHashSet set = (LongOpenHashSet)additionalLoadedChunks.computeIfAbsent(dimension, k -> new LongOpenHashSet());
            chunkLoader.foreachChunkPos(new ChunkLoader.ChunkPosConsumer(){

                @Override
                public void consume(ResourceKey<Level> dimension, int x, int z, int distanceToSource) {
                    long chunkPos = ChunkPos.asLong((int)x, (int)z);
                    dimTicketManager.markForLoading(chunkPos, distanceToSource, generationCounter);
                    set.add(chunkPos);
                }
            });
            return false;
        });
        return additionalLoadedChunks;
    }

    private static void tick(MinecraftServer server) {
        server.getProfiler().push("portal_chunk_tracking");
        boolean updates = false;
        long gameTime = server.overworld().getGameTime();
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            PlayerChunkLoading playerInfo = ImmPtlChunkTracking.getPlayerInfo(player);
            if (!playerInfo.shouldUpdateImmediately && (long)(player.getId() % 13) != gameTime % 13L) continue;
            playerInfo.shouldUpdateImmediately = false;
            ImmPtlChunkTracking.updateForPlayer(player);
            updates = true;
        }
        if (gameTime % 13L == 0L) {
            Object2ObjectOpenHashMap<ResourceKey<Level>, LongOpenHashSet> additionalLoadedChunks = ImmPtlChunkTracking.refreshAdditionalChunkLoaders(server);
            ImmPtlChunkTracking.purge(server, additionalLoadedChunks);
            ++generationCounter;
            updates = true;
        }
        for (ServerLevel world : server.getAllLevels()) {
            ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
            dimTicketManager.tick(world);
        }
        server.getProfiler().pop();
        if (updates) {
            EntitySync.update(server);
        }
        EntitySync.tick(server);
    }

    public static boolean isPlayerWatchingChunk(ServerPlayer player, ResourceKey<Level> dimension, int x, int z, Predicate<PlayerWatchRecord> predicate) {
        long chunkPos = ChunkPos.asLong((int)x, (int)z);
        Object2ObjectOpenHashMap recordMap = (Object2ObjectOpenHashMap)ImmPtlChunkTracking.getDimChunkWatchRecords(dimension).get(chunkPos);
        if (recordMap == null) {
            return false;
        }
        PlayerWatchRecord record = (PlayerWatchRecord)recordMap.get((Object)player);
        if (record == null) {
            return false;
        }
        if (!record.isLoadedToPlayer) {
            return false;
        }
        return predicate.test(record);
    }

    public static boolean isPlayerWatchingChunk(ServerPlayer player, ResourceKey<Level> dimension, int x, int z) {
        return ImmPtlChunkTracking.isPlayerWatchingChunk(player, dimension, x, z, r -> true);
    }

    public static boolean isPlayerWatchingChunkWithinRadius(ServerPlayer player, ResourceKey<Level> dimension, int x, int z, int radiusBlocks) {
        return ImmPtlChunkTracking.isPlayerWatchingChunk(player, dimension, x, z, r -> r.distanceToSource * 16 <= radiusBlocks);
    }

    private static void cleanup(MinecraftServer server) {
        chunkWatchRecords.clear();
        additionalChunkLoaders.clear();
        playerInfoMap.clear();
    }

    public static Stream<ServerPlayer> getPlayersViewingChunk(ResourceKey<Level> dimension, int x, int z) {
        Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord> records = ImmPtlChunkTracking.getWatchRecordForChunk(dimension, x, z);
        if (records == null) {
            return Stream.empty();
        }
        return records.values().stream().filter(e -> e.isLoadedToPlayer).map(e -> e.player);
    }

    public static List<ServerPlayer> getPlayersViewingChunk(ResourceKey<Level> dimension, int x, int z, boolean boundaryOnly) {
        Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord> recs = ImmPtlChunkTracking.getWatchRecordForChunk(dimension, x, z);
        if (recs == null) {
            return Collections.emptyList();
        }
        ArrayList<ServerPlayer> result = new ArrayList<ServerPlayer>();
        for (PlayerWatchRecord rec : recs.values()) {
            if (!rec.isLoadedToPlayer || boundaryOnly && !rec.isBoundary) continue;
            result.add(rec.player);
        }
        return result;
    }

    @Nullable
    public static Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord> getWatchRecordForChunk(ResourceKey<Level> dimension, int x, int z) {
        return (Object2ObjectOpenHashMap)ImmPtlChunkTracking.getDimChunkWatchRecords(dimension).get(ChunkPos.asLong((int)x, (int)z));
    }

    public static void forceRemovePlayer(ServerPlayer oldPlayer) {
        playerInfoMap.remove((Object)oldPlayer);
        chunkWatchRecords.forEach((dim, dimMap) -> dimMap.long2ObjectEntrySet().removeIf(e -> {
            long chunkPos = e.getLongKey();
            Object2ObjectOpenHashMap records = (Object2ObjectOpenHashMap)e.getValue();
            PlayerWatchRecord rec = (PlayerWatchRecord)records.remove((Object)oldPlayer);
            if (rec != null) {
                PacketRedirection.sendRedirectedMessage(oldPlayer, (ResourceKey<Level>)dim, (Packet<ClientGamePacketListener>)new ClientboundForgetLevelChunkPacket(new ChunkPos(chunkPos)));
            }
            return records.isEmpty();
        }));
    }

    public static void forceRemoveDimension(ServerLevel world) {
        ResourceKey dim = world.dimension();
        MinecraftServer server = world.getServer();
        Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord>> map = chunkWatchRecords.get(dim);
        if (map == null) {
            return;
        }
        map.forEach((chunkPos, records) -> {
            Packet<ClientGamePacketListener> unloadPacket = PacketRedirection.createRedirectedMessage(server, (ResourceKey<Level>)dim, (Packet<ClientGamePacketListener>)new ClientboundForgetLevelChunkPacket(new ChunkPos(chunkPos.longValue())));
            for (PlayerWatchRecord record : records.values()) {
                if (record.isValid && record.isLoadedToPlayer) {
                    record.player.connection.send(unloadPacket);
                }
                record.isValid = false;
            }
        });
        chunkWatchRecords.remove(dim);
        additionalChunkLoaders.removeIf(chunkLoader -> chunkLoader.dimension() == dim);
        for (PlayerChunkLoading playerInfo : playerInfoMap.values()) {
            playerInfo.additionalChunkLoaders.removeIf(l -> l.dimension() == dim);
        }
    }

    public static boolean shouldLoadDimension(ResourceKey<Level> dimension) {
        if (!chunkWatchRecords.containsKey(dimension)) {
            return false;
        }
        Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord>> map = chunkWatchRecords.get(dimension);
        return !map.isEmpty();
    }

    public static void addGlobalAdditionalChunkLoader(MinecraftServer server, ChunkLoader chunkLoader) {
        additionalChunkLoaders.add(chunkLoader);
        ResourceKey<Level> dimension = chunkLoader.dimension();
        ServerLevel world = server.getLevel(dimension);
        if (world == null) {
            LOGGER.error("Missing dimension in chunk loader {}", (Object)dimension.location());
            return;
        }
        ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
        chunkLoader.foreachChunkPos((dim, x, z, distanceToSource) -> dimTicketManager.markForLoading(ChunkPos.asLong((int)x, (int)z), distanceToSource, generationCounter));
    }

    public static void removeGlobalAdditionalChunkLoader(MinecraftServer server, ChunkLoader chunkLoader) {
        additionalChunkLoaders.removeIf(c -> c == chunkLoader);
    }

    public static int getLoadedChunkNum(ResourceKey<Level> dimension) {
        return ImmPtlChunkTracking.getDimChunkWatchRecords(dimension).size();
    }

    public static void addPerPlayerAdditionalChunkLoader(ServerPlayer player, ChunkLoader chunkLoader) {
        PlayerChunkLoading playerInfo = ImmPtlChunkTracking.getPlayerInfo(player);
        playerInfo.additionalChunkLoaders.add(chunkLoader);
        playerInfo.shouldUpdateImmediately = true;
    }

    public static void removePerPlayerAdditionalChunkLoader(ServerPlayer player, ChunkLoader chunkLoader) {
        ArrayList<ChunkLoader> chunkLoaderList = ImmPtlChunkTracking.getPlayerInfo((ServerPlayer)player).additionalChunkLoaders;
        chunkLoaderList.removeIf(c -> c == chunkLoader);
    }

    public static Set<ResourceKey<Level>> getVisibleDimensions(ServerPlayer player) {
        return ImmPtlChunkTracking.getPlayerInfo((ServerPlayer)player).visibleDimensions;
    }

    public static void syncBlockUpdateToClientImmediately(ServerLevel world, IntBox box) {
        ChunkPos lowPos = new ChunkPos(box.l);
        ChunkPos highPos = new ChunkPos(box.h);
        HashSet<ServerPlayer> playersViewingRegion = new HashSet<ServerPlayer>();
        ResourceKey dimension = world.dimension();
        for (int x = lowPos.x; x <= highPos.x; ++x) {
            for (int z = lowPos.z; z <= highPos.z; ++z) {
                Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord> rec = ImmPtlChunkTracking.getWatchRecordForChunk((ResourceKey<Level>)dimension, x, z);
                if (rec == null) continue;
                for (PlayerWatchRecord r : rec.values()) {
                    if (!r.isValid || r.isLoadedToPlayer) continue;
                    playersViewingRegion.add(r.player);
                }
            }
        }
        for (ServerPlayer player : playersViewingRegion) {
            ImmPtlChunkTracking.getPlayerInfo(player).doChunkSending(player);
        }
        IEChunkMap chunkMap = (IEChunkMap)world.getChunkSource().chunkMap;
        for (int x = lowPos.x; x <= highPos.x; ++x) {
            for (int z = lowPos.z; z <= highPos.z; ++z) {
                LevelChunk tickingChunk;
                long chunkPosLong = ChunkPos.asLong((int)x, (int)z);
                ChunkHolder chunkHolder = chunkMap.ip_getChunkHolder(chunkPosLong);
                if (chunkHolder == null || (tickingChunk = chunkHolder.getTickingChunk()) == null) continue;
                chunkHolder.broadcastChanges(tickingChunk);
            }
        }
    }

    public static class PlayerWatchRecord {
        public final ServerPlayer player;
        public final ResourceKey<Level> dimension;
        public final long chunkPos;
        public int lastWatchGeneration;
        public int distanceToSource;
        public boolean isLoadedToPlayer;
        public boolean isValid = true;
        public boolean isBoundary = false;

        public PlayerWatchRecord(ServerPlayer player, ResourceKey<Level> dimension, long chunkPos, int lastWatchGeneration, int distanceToSource, boolean isLoadedToPlayer, boolean isBoundary) {
            this.player = player;
            this.dimension = dimension;
            this.chunkPos = chunkPos;
            this.lastWatchGeneration = lastWatchGeneration;
            this.distanceToSource = distanceToSource;
            this.isLoadedToPlayer = isLoadedToPlayer;
            this.isBoundary = isBoundary;
        }

        public String toString() {
            return String.format("%s (%d,%d) distance:%d valid:%s loaded:%s", this.dimension.location(), ChunkPos.getX((long)this.chunkPos), ChunkPos.getZ((long)this.chunkPos), this.distanceToSource, this.isValid, this.isLoadedToPlayer);
        }
    }

    public static class RemoteCallables {
        public static void acceptClientPerformanceInfo(ServerPlayer player, PerformanceLevel performanceLevel) {
            PlayerChunkLoading playerInfo = ImmPtlChunkTracking.getPlayerInfo(player);
            playerInfo.performanceLevel = performanceLevel;
        }
    }
}

