/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import com.mojang.logging.LogUtils;
import de.nick1st.imm_ptl.events.DimensionEvents;
import de.nick1st.imm_ptl.events.ServerCleanupEvent;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongPredicate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEChunkMap;
import qouteall.imm_ptl.core.ducks.IEServerChunkCache;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.mixin.common.chunk_sync.IEDistanceManager;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.RateStat;

public class ImmPtlChunkTickets {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final TicketType<ChunkPos> TICKET_TYPE = TicketType.create((String)"imm_ptl", Comparator.comparingLong(ChunkPos::toLong));
    private static boolean enableDebugRateStat = false;
    private static final RateStat debugRateStat = new RateStat("imm_ptl_chunk_ticket");
    public static final WeakHashMap<ServerLevel, ImmPtlChunkTickets> BY_DIMENSION = new WeakHashMap();
    private final Long2ObjectOpenHashMap<ChunkTicketInfo> chunkPosToTicketInfo = new Long2ObjectOpenHashMap();
    private final ArrayList<LongLinkedOpenHashSet> chunksToAddTicketByDistance = new ArrayList();
    private final LongOpenHashSet waitingForLoading = new LongOpenHashSet();
    private boolean isValid = true;
    public final int throttlingLimit = 4;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(DimensionEvents.BeforeRemovingDimensionEvent.class, beforeRemovingDimensionEvent -> ImmPtlChunkTickets.onDimensionRemove(beforeRemovingDimensionEvent.dimension));
        NeoForge.EVENT_BUS.addListener(ServerCleanupEvent.class, ImmPtlChunkTickets::cleanup);
    }

    private ImmPtlChunkTickets() {
    }

    public static ImmPtlChunkTickets get(ServerLevel world) {
        return BY_DIMENSION.computeIfAbsent(world, k -> new ImmPtlChunkTickets());
    }

    public void markForLoading(long chunkPos, int distanceToSource, int generation) {
        Validate.isTrue((distanceToSource >= 0 ? 1 : 0) != 0);
        ChunkTicketInfo info = (ChunkTicketInfo)this.chunkPosToTicketInfo.get(chunkPos);
        if (info == null) {
            info = new ChunkTicketInfo(generation, distanceToSource);
            this.chunkPosToTicketInfo.put(chunkPos, (Object)info);
            this.getQueueByDistance(distanceToSource).add(chunkPos);
        } else if (generation != info.lastUpdateGeneration) {
            info.lastUpdateGeneration = generation;
            int oldDistanceToSource = info.distanceToSource;
            info.distanceToSource = distanceToSource;
            if (this.getQueueByDistance(oldDistanceToSource).remove(chunkPos)) {
                this.getQueueByDistance(distanceToSource).add(chunkPos);
            }
        } else if (distanceToSource < info.distanceToSource) {
            int oldDistanceToSource = info.distanceToSource;
            info.distanceToSource = distanceToSource;
            if (this.getQueueByDistance(oldDistanceToSource).remove(chunkPos)) {
                this.getQueueByDistance(distanceToSource).add(chunkPos);
            }
        }
    }

    private LongLinkedOpenHashSet getQueueByDistance(int distanceToSource) {
        return Helper.arrayListComputeIfAbsent(this.chunksToAddTicketByDistance, distanceToSource, LongLinkedOpenHashSet::new);
    }

    public void tick(ServerLevel world) {
        this.flushThrottling(world);
    }

    public void flushThrottling(ServerLevel world) {
        if (Thread.currentThread() != ((IEWorld)world).portal_getThread()) {
            LOGGER.error("Called in a non-server-main (or server-world) thread.", new Throwable());
            return;
        }
        if (enableDebugRateStat) {
            debugRateStat.update();
        }
        if (!this.isValid) {
            LOGGER.error("flushing when invalid {}", (Object)world);
            return;
        }
        if (!world.getServer().isRunning()) {
            return;
        }
        DistanceManager distanceManager = ImmPtlChunkTickets.getDistanceManager(world);
        Executor mainThreadExecutor = ((IEDistanceManager)distanceManager).ip_getMainThreadExecutor();
        this.waitingForLoading.removeIf(chunkPos -> {
            ChunkHolder chunkHolder = ImmPtlChunkTickets.getChunkHolder(world, chunkPos);
            if (chunkHolder == null) {
                return true;
            }
            ChunkResult resultNow = chunkHolder.getEntityTickingChunkFuture().getNow(null);
            if (resultNow == null) {
                return false;
            }
            if (!resultNow.isSuccess()) {
                LOGGER.error("Chunk loading failure {} {} {}", (Object)world, (Object)new ChunkPos(chunkPos));
            }
            return true;
        });
        for (LongLinkedOpenHashSet queue : this.chunksToAddTicketByDistance) {
            if (queue == null) continue;
            while (!queue.isEmpty()) {
                if (this.waitingForLoading.size() >= 4) {
                    return;
                }
                long chunkPos2 = queue.removeFirstLong();
                if (this.chunkPosToTicketInfo.containsKey(chunkPos2)) {
                    ImmPtlChunkTickets.addTicket(distanceManager, chunkPos2);
                    this.waitingForLoading.add(chunkPos2);
                    continue;
                }
                LOGGER.warn("Chunk {} is not in the queue", (Object)new ChunkPos(chunkPos2));
            }
        }
    }

    private static void addTicket(DistanceManager distanceManager, long chunkPos) {
        if (!IPConfig.getConfig().enableImmPtlChunkLoading) {
            return;
        }
        ChunkPos chunkPosObj = new ChunkPos(chunkPos);
        distanceManager.addRegionTicket(TICKET_TYPE, chunkPosObj, ImmPtlChunkTickets.getLoadingRadius(), (Object)chunkPosObj);
        if (enableDebugRateStat) {
            debugRateStat.hit();
        }
    }

    public void purge(ServerLevel world, LongPredicate shouldKeepLoadingFunc) {
        DistanceManager distanceManager = ImmPtlChunkTickets.getDistanceManager(world);
        this.chunkPosToTicketInfo.long2ObjectEntrySet().removeIf(e -> {
            long chunkPos = e.getLongKey();
            ChunkTicketInfo ticketInfo = (ChunkTicketInfo)e.getValue();
            boolean keepLoading = shouldKeepLoadingFunc.test(chunkPos);
            if (!keepLoading) {
                this.waitingForLoading.remove(chunkPos);
                boolean pendingTicketAdding = this.getQueueByDistance(ticketInfo.distanceToSource).remove(chunkPos);
                if (!pendingTicketAdding) {
                    ChunkPos chunkPosObj = new ChunkPos(chunkPos);
                    distanceManager.removeRegionTicket(TICKET_TYPE, chunkPosObj, ImmPtlChunkTickets.getLoadingRadius(), (Object)chunkPosObj);
                }
                return true;
            }
            return false;
        });
    }

    public int getLoadedChunkNum() {
        return this.chunkPosToTicketInfo.size();
    }

    public static void onDimensionRemove(ServerLevel world) {
        ImmPtlChunkTickets dimTicketManager = BY_DIMENSION.remove(world);
        if (dimTicketManager == null) {
            return;
        }
        ImmPtlChunkTickets.removeAllTicketsInWorld(world, dimTicketManager);
    }

    private static void removeAllTicketsInWorld(ServerLevel world, ImmPtlChunkTickets dimTicketManager) {
        DistanceManager ticketManager = ImmPtlChunkTickets.getDistanceManager(world);
        dimTicketManager.chunkPosToTicketInfo.keySet().forEach(pos -> {
            SortedArraySet<Ticket<?>> tickets = ((qouteall.imm_ptl.core.ducks.IEDistanceManager)ImmPtlChunkTickets.getDistanceManager(world)).portal_getTicketSet(pos);
            List<Ticket> toRemove = tickets.stream().filter(t -> t.getType() == TICKET_TYPE).toList();
            ChunkPos chunkPos = new ChunkPos(pos);
            for (Ticket ticket : toRemove) {
                ticketManager.removeRegionTicket(TICKET_TYPE, chunkPos, ticket.getTicketLevel(), (Object)chunkPos);
            }
        });
        dimTicketManager.isValid = false;
    }

    public static int getLoadingRadius() {
        if (IPGlobal.activeLoading) {
            return 2;
        }
        return 1;
    }

    public static ChunkHolder getChunkHolder(ServerLevel world, long chunkPos) {
        return ((IEChunkMap)world.getChunkSource().chunkMap).ip_getChunkHolder(chunkPos);
    }

    public static DistanceManager getDistanceManager(ServerLevel world) {
        return ((IEServerChunkCache)world.getChunkSource()).ip_getDistanceManager();
    }

    private static void cleanup(ServerCleanupEvent event) {
        MinecraftServer server = event.server;
        for (ImmPtlChunkTickets immPtlChunkTickets : BY_DIMENSION.values()) {
            immPtlChunkTickets.isValid = false;
        }
        BY_DIMENSION.clear();
    }

    public static class ChunkTicketInfo {
        public int lastUpdateGeneration;
        public int distanceToSource;

        public ChunkTicketInfo(int lastUpdateGeneration, int distanceToSource) {
            this.lastUpdateGeneration = lastUpdateGeneration;
            this.distanceToSource = distanceToSource;
        }
    }
}

