/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.block_manipulation;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.ScaleUtils;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalUtils;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;

public class BlockManipulationServer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ThreadLocal<Context> REDIRECT_CONTEXT = ThreadLocal.withInitial(() -> null);

    private static boolean canPlayerReach(ResourceKey<Level> dimension, ServerPlayer player, BlockPos requestPos) {
        if (!((CrossPortalInteractionEvent)NeoForge.EVENT_BUS.post((Event)new CrossPortalInteractionEvent((Player)player))).canDo()) {
            return false;
        }
        double playerScale = ScaleUtils.computeBlockReachScale((Entity)player);
        Vec3 pos = Vec3.atCenterOf((Vec3i)requestPos);
        Vec3 playerPos = player.position();
        double distanceSquare = 576.0 * playerScale * playerScale;
        if (player.level().dimension() == dimension && playerPos.distanceToSqr(pos) < distanceSquare) {
            return true;
        }
        return IPMcHelper.getNearbyPortals((Entity)player, IPGlobal.maxNormalPortalRadius).anyMatch(portal -> portal.getDestDim() == dimension && portal.isInteractableBy((Player)player) && portal.transformPoint(playerPos).distanceToSqr(pos) < distanceSquare * portal.getScale() * portal.getScale());
    }

    public static Tuple<BlockHitResult, ResourceKey<Level>> getHitResultForPlacing(Level world, BlockHitResult blockHitResult) {
        Direction side = blockHitResult.getDirection();
        Vec3 sideVec = Vec3.atLowerCornerOf((Vec3i)side.getNormal());
        BlockPos hitPos = blockHitResult.getBlockPos();
        Vec3 hitCenter = Vec3.atCenterOf((Vec3i)hitPos);
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
        Portal portal = globalPortals.stream().filter(p -> p.getNormal().dot(sideVec) < -0.9 && p.getPortalShape().isBoxInPortalProjection(p.getThisSideState(), new AABB(hitPos)) && p.getDistanceToPlane(hitCenter) < 0.6).findFirst().orElse(null);
        if (portal == null) {
            return new Tuple((Object)blockHitResult, (Object)world.dimension());
        }
        Vec3 newCenter = portal.transformPoint(hitCenter.add(sideVec.scale(0.501)));
        BlockPos placingBlockPos = BlockPos.containing((Position)newCenter);
        BlockHitResult newHitResult = new BlockHitResult(Vec3.ZERO, side.getOpposite(), placingBlockPos, blockHitResult.isInside());
        return new Tuple((Object)newHitResult, portal.getDestDim());
    }

    public static void init() {
    }

    private static void withRedirect(Context context, Runnable runnable) {
        Context original = REDIRECT_CONTEXT.get();
        REDIRECT_CONTEXT.set(context);
        try {
            PacketRedirection.withForceRedirect(context.world(), runnable);
        }
        finally {
            REDIRECT_CONTEXT.set(original);
        }
    }

    @IPVanillaCopy
    private static void doProcessPlayerAction(ServerLevel world, ServerPlayer player, ServerboundPlayerActionPacket packet) {
        player.resetLastActionTime();
        BlockPos blockPos = packet.getPos();
        ServerboundPlayerActionPacket.Action action = packet.getAction();
        if (!BlockManipulationServer.canPlayerReach((ResourceKey<Level>)world.dimension(), player, blockPos)) {
            LOGGER.error("Reject cross-portal action {} {} {}", new Object[]{player, world, blockPos});
            return;
        }
        if (BlockManipulationServer.isAttackingAction(action)) {
            player.gameMode.handleBlockBreakAction(blockPos, action, packet.getDirection(), world.getMaxBuildHeight(), packet.getSequence());
            player.connection.ackBlockChangesUpTo(packet.getSequence());
        }
    }

    public static boolean isAttackingAction(ServerboundPlayerActionPacket.Action action) {
        return action == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK || action == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK || action == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK;
    }

    @IPVanillaCopy
    private static void doProcessUseItemOn(ServerLevel world, ServerPlayer player, ServerboundUseItemOnPacket packet) {
        player.connection.ackBlockChangesUpTo(packet.getSequence());
        InteractionHand hand = packet.getHand();
        BlockHitResult blockHitResult = packet.getHitResult();
        ResourceKey dimension = world.dimension();
        ItemStack itemStack = player.getItemInHand(hand);
        if (!itemStack.isItemEnabled(world.enabledFeatures())) {
            return;
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        Direction direction = blockHitResult.getDirection();
        player.resetLastActionTime();
        if (world.mayInteract((Player)player, blockPos)) {
            if (!BlockManipulationServer.canPlayerReach((ResourceKey<Level>)dimension, player, blockPos)) {
                LOGGER.error("Reject cross-portal action {} {} {}", new Object[]{player, world, blockPos});
                return;
            }
            InteractionResult actionResult = player.gameMode.useItemOn(player, (Level)world, itemStack, hand, blockHitResult);
            if (actionResult.shouldSwing()) {
                player.swing(hand, true);
            }
        }
        PacketRedirection.sendRedirectedMessage(player, (ResourceKey<Level>)dimension, (Packet<ClientGamePacketListener>)new ClientboundBlockUpdatePacket((BlockGetter)world, blockPos));
        BlockPos offseted = blockPos.relative(direction);
        if (offseted.getY() >= world.getMinBuildHeight() && offseted.getY() < world.getMaxBuildHeight()) {
            PacketRedirection.sendRedirectedMessage(player, (ResourceKey<Level>)dimension, (Packet<ClientGamePacketListener>)new ClientboundBlockUpdatePacket((BlockGetter)world, offseted));
        }
    }

    public static boolean validateReach(Player player, Level targetWorld, BlockPos targetPos) {
        PortalUtils.PortalAwareRaytraceResult result = PortalUtils.portalAwareRayTrace(player.level(), player.getEyePosition(), player.getViewVector(1.0f), 32.0, (Entity)player, ClipContext.Block.COLLIDER);
        return result != null && result.world() == targetWorld && result.hitResult().getBlockPos().distManhattan((Vec3i)targetPos) < 8;
    }

    public static class CrossPortalInteractionEvent
    extends Event {
        public final Player player;
        boolean canDo = true;

        public CrossPortalInteractionEvent(Player player) {
            this.player = player;
        }

        public boolean canDo() {
            return this.canDo;
        }

        public void setCanDo(boolean canDo) {
            this.canDo = this.canDo && canDo;
        }
    }

    public record Context(ServerLevel world, @Nullable BlockHitResult blockHitResult) {
    }

    public static class RemoteCallables {
        public static void processPlayerActionPacket(ServerPlayer player, ResourceKey<Level> dimension, byte[] packetBytes) {
            FriendlyByteBuf buf = IPMcHelper.bytesToBuf(packetBytes);
            ServerboundPlayerActionPacket packet = (ServerboundPlayerActionPacket)ServerboundPlayerActionPacket.STREAM_CODEC.decode((Object)buf);
            ServerLevel world = player.server.getLevel(dimension);
            Validate.notNull((Object)world, (String)"missing %s", (Object[])new Object[]{dimension.location()});
            BlockManipulationServer.withRedirect(new Context(world, null), () -> BlockManipulationServer.doProcessPlayerAction(world, player, packet));
        }

        public static void processUseItemOnPacket(ServerPlayer player, ResourceKey<Level> dimension, byte[] packetBytes) {
            FriendlyByteBuf buf = IPMcHelper.bytesToBuf(packetBytes);
            ServerboundUseItemOnPacket packet = (ServerboundUseItemOnPacket)ServerboundUseItemOnPacket.STREAM_CODEC.decode((Object)buf);
            ServerLevel world = player.server.getLevel(dimension);
            Validate.notNull((Object)world, (String)"missing %s", (Object[])new Object[]{dimension.location()});
            BlockManipulationServer.withRedirect(new Context(world, packet.getHitResult()), () -> BlockManipulationServer.doProcessUseItemOn(world, player, packet));
        }
    }
}

