/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.block_manipulation;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationServer;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalPlaceholderBlock;
import qouteall.imm_ptl.core.portal.PortalUtils;
import qouteall.q_misc_util.my_util.RayTraceResult;

public class BlockManipulationClient {
    private static final Minecraft client = Minecraft.getInstance();
    public static ResourceKey<Level> remotePointedDim;
    public static HitResult remoteHitResult;

    public static boolean isPointingToPortal() {
        return remotePointedDim != null;
    }

    @Nullable
    public static ClientLevel getRemotePointedWorld() {
        if (remotePointedDim == null) {
            return null;
        }
        return ClientWorldLoader.getWorld(remotePointedDim);
    }

    private static BlockHitResult createMissedHitResult(Vec3 from, Vec3 to) {
        Vec3 dir = to.subtract(from).normalize();
        return BlockHitResult.miss((Vec3)to, (Direction)Direction.getNearest((double)dir.x, (double)dir.y, (double)dir.z), (BlockPos)BlockPos.containing((Position)to));
    }

    private static boolean hitResultIsMissedOrNull(HitResult bhr) {
        return bhr == null || bhr.getType() == HitResult.Type.MISS;
    }

    public static void updatePointedBlock(float partialTick) {
        if (BlockManipulationClient.client.gameMode == null || BlockManipulationClient.client.level == null || BlockManipulationClient.client.player == null) {
            return;
        }
        remotePointedDim = null;
        remoteHitResult = null;
        if (!((BlockManipulationServer.CrossPortalInteractionEvent)NeoForge.EVENT_BUS.post((Event)new BlockManipulationServer.CrossPortalInteractionEvent((Player)BlockManipulationClient.client.player))).canDo()) {
            return;
        }
        Vec3 cameraPos = BlockManipulationClient.client.gameRenderer.getMainCamera().getPosition();
        double reachDistance = BlockManipulationClient.client.player.blockInteractionRange();
        PortalUtils.raytracePortalFromEntityView((Entity)BlockManipulationClient.client.player, partialTick, reachDistance, true, portal1 -> portal1.isInteractableBy((Player)BlockManipulationClient.client.player)).ifPresent(pair -> {
            Portal portal = (Portal)pair.getFirst();
            Vec3 hitPos = ((RayTraceResult)pair.getSecond()).hitPos();
            double distanceToPortalPointing = hitPos.distanceTo(cameraPos);
            if (distanceToPortalPointing < BlockManipulationClient.getCurrentTargetDistance() + 0.2) {
                BlockManipulationClient.client.hitResult = BlockManipulationClient.createMissedHitResult(cameraPos, hitPos);
                BlockManipulationClient.updateTargetedBlockThroughPortal(cameraPos, BlockManipulationClient.client.player.getViewVector(partialTick), (ResourceKey<Level>)BlockManipulationClient.client.player.level().dimension(), distanceToPortalPointing, reachDistance, portal);
            }
        });
    }

    private static double getCurrentTargetDistance() {
        BlockPos hitPos;
        Vec3 cameraPos = BlockManipulationClient.client.gameRenderer.getMainCamera().getPosition();
        if (BlockManipulationClient.hitResultIsMissedOrNull(BlockManipulationClient.client.hitResult)) {
            return 23333.0;
        }
        if (BlockManipulationClient.client.hitResult instanceof BlockHitResult && BlockManipulationClient.client.level.getBlockState(hitPos = ((BlockHitResult)BlockManipulationClient.client.hitResult).getBlockPos()).getBlock() == PortalPlaceholderBlock.instance) {
            return 23333.0;
        }
        return cameraPos.distanceTo(BlockManipulationClient.client.hitResult.getLocation());
    }

    private static void updateTargetedBlockThroughPortal(Vec3 cameraPos, Vec3 viewVector, ResourceKey<Level> playerDimension, double beginDistance, double endDistance, Portal portal) {
        Vec3 from = portal.transformPoint(cameraPos.add(viewVector.scale(beginDistance)));
        Vec3 to = portal.transformPoint(cameraPos.add(viewVector.scale(endDistance)));
        ClipContext context = new ClipContext(from, to, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)BlockManipulationClient.client.player);
        ClientLevel world = ClientWorldLoader.getWorld(portal.getDestDim());
        remoteHitResult = (HitResult)BlockGetter.traverseBlocks((Vec3)from, (Vec3)to, (Object)context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.getBlockState(blockPos);
            if (blockState.getBlock() == PortalPlaceholderBlock.instance) {
                return null;
            }
            if (blockState.getBlock() == Blocks.BARRIER) {
                return null;
            }
            FluidState fluidState = world.getFluidState(blockPos);
            Vec3 start = rayTraceContext.getFrom();
            Vec3 end = rayTraceContext.getTo();
            Vec3 correctedStart = start.subtract(end.subtract(start).scale(0.0015));
            VoxelShape solidShape = rayTraceContext.getBlockShape(blockState, (BlockGetter)world, blockPos);
            BlockHitResult blockHitResult = world.clipWithInteractionOverride(correctedStart, end, blockPos, solidShape, blockState);
            VoxelShape fluidShape = rayTraceContext.getFluidShape(fluidState, (BlockGetter)world, blockPos);
            BlockHitResult fluidHitResult = fluidShape.clip(start, end, blockPos);
            double d = blockHitResult == null ? Double.MAX_VALUE : rayTraceContext.getFrom().distanceToSqr(blockHitResult.getLocation());
            double e = fluidHitResult == null ? Double.MAX_VALUE : rayTraceContext.getFrom().distanceToSqr(fluidHitResult.getLocation());
            return d <= e ? blockHitResult : fluidHitResult;
        }, rayTraceContext -> {
            Vec3 vec3d = rayTraceContext.getFrom().subtract(rayTraceContext.getTo());
            return BlockHitResult.miss((Vec3)rayTraceContext.getTo(), (Direction)Direction.getNearest((double)vec3d.x, (double)vec3d.y, (double)vec3d.z), (BlockPos)BlockPos.containing((Position)rayTraceContext.getTo()));
        });
        if (BlockManipulationClient.remoteHitResult.getLocation().y < (double)world.getMinBuildHeight() + 0.1) {
            remoteHitResult = new BlockHitResult(remoteHitResult.getLocation(), Direction.DOWN, ((BlockHitResult)remoteHitResult).getBlockPos(), ((BlockHitResult)remoteHitResult).isInside());
        }
        if (remoteHitResult != null && !world.getBlockState(((BlockHitResult)remoteHitResult).getBlockPos()).isAir()) {
            BlockManipulationClient.client.hitResult = BlockManipulationClient.createMissedHitResult(from, to);
            remotePointedDim = portal.getDestDim();
        }
    }

    public static <T> T withSwitchedContext(Supplier<T> func, boolean transformHitResult) {
        HitResult effectiveHitResult;
        HitResult hitResult;
        Validate.notNull((Object)remoteHitResult);
        ClientLevel remoteWorld = BlockManipulationClient.getRemotePointedWorld();
        Validate.notNull((Object)remoteWorld);
        if (transformHitResult && (hitResult = remoteHitResult) instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            Tuple<BlockHitResult, ResourceKey<Level>> r = BlockManipulationServer.getHitResultForPlacing((Level)remoteWorld, blockHitResult);
            effectiveHitResult = (HitResult)r.getA();
            remoteWorld = ClientWorldLoader.getWorld((ResourceKey<Level>)((ResourceKey)r.getB()));
            Validate.notNull((Object)remoteWorld);
            Validate.notNull((Object)effectiveHitResult);
        } else {
            effectiveHitResult = remoteHitResult;
        }
        return (T)ClientWorldLoader.withSwitchedWorld(remoteWorld, () -> {
            HitResult originalHitResult = BlockManipulationClient.client.hitResult;
            BlockManipulationClient.client.hitResult = effectiveHitResult;
            try {
                Object t = func.get();
                return t;
            }
            finally {
                BlockManipulationClient.client.hitResult = originalHitResult;
            }
        });
    }

    @Nullable
    public static String getDebugString() {
        if (remotePointedDim == null) {
            return null;
        }
        HitResult hitResult = remoteHitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            return "Point:%s %d %d %d".formatted(remotePointedDim.location(), blockHitResult.getBlockPos().getX(), blockHitResult.getBlockPos().getY(), blockHitResult.getBlockPos().getZ());
        }
        return null;
    }
}

