/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;

public class ScaleUtils {
    public static final ResourceLocation IPORTAL_SCALING = ResourceLocation.fromNamespaceAndPath((String)"iportal", (String)"scaling");

    public static void onServerEntityTeleported(Entity entity, Portal portal) {
        if (portal.hasScaling() && portal.isTeleportChangesScale()) {
            ScaleUtils.doScalingForEntity(entity, portal);
            if (entity.getVehicle() != null) {
                ScaleUtils.doScalingForEntity(entity.getVehicle(), portal);
            }
        }
    }

    @Nullable
    public static AttributeInstance getScaleAttr(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.getAttributes().getInstance(Attributes.SCALE);
        }
        return null;
    }

    public static double getScale(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.getScale();
        }
        return 1.0;
    }

    public static double getBaseScale(Entity entity) {
        AttributeInstance scaleAttr = ScaleUtils.getScaleAttr(entity);
        if (scaleAttr != null) {
            return scaleAttr.getBaseValue();
        }
        return 1.0;
    }

    public static double getIPortalScaling(Entity entity) {
        AttributeInstance scaleAttr = ScaleUtils.getScaleAttr(entity);
        if (scaleAttr == null) {
            return 1.0;
        }
        AttributeModifier modifier = scaleAttr.getModifier(IPORTAL_SCALING);
        if (modifier == null) {
            return 1.0;
        }
        return modifier.amount() + 1.0;
    }

    public static void setIPortalScaling(Entity entity, double newScale) {
        AttributeInstance scaleAttr = ScaleUtils.getScaleAttr(entity);
        if (scaleAttr == null) {
            return;
        }
        if (Math.abs(newScale - 1.0) < 1.0E-4) {
            scaleAttr.removeModifier(IPORTAL_SCALING);
            entity.refreshDimensions();
            return;
        }
        scaleAttr.addOrReplacePermanentModifier(new AttributeModifier(IPORTAL_SCALING, newScale - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        entity.refreshDimensions();
    }

    public static void setBaseScale(Entity entity, double scale) {
        AttributeInstance scaleAttr = ScaleUtils.getScaleAttr(entity);
        if (scaleAttr != null) {
            scaleAttr.setBaseValue(scale);
            entity.refreshDimensions();
        }
    }

    public static double computeThirdPersonScale(Entity entity) {
        return ScaleUtils.getScale(entity);
    }

    public static double computeBlockReachScale(Entity entity) {
        return ScaleUtils.getScale(entity);
    }

    public static double computeMotionScale(Entity entity) {
        return ScaleUtils.getScale(entity);
    }

    public static void doScalingForEntity(Entity entity, Portal portal) {
        Vec3 eyePos = McHelper.getEyePos(entity);
        Vec3 lastTickEyePos = McHelper.getLastTickEyePos(entity);
        double oldScale = ScaleUtils.getIPortalScaling(entity);
        double newScale = ScaleUtils.transformScale(portal, oldScale);
        if (!entity.level().isClientSide && ScaleUtils.isScaleIllegal(newScale)) {
            newScale = 1.0;
            entity.sendSystemMessage((Component)Component.literal((String)"Scale out of range"));
        }
        ScaleUtils.setIPortalScaling(entity, newScale);
        if (!entity.level().isClientSide) {
            McHelper.setEyePos(entity, eyePos, lastTickEyePos);
            McHelper.updateBoundingBox(entity);
        } else {
            McHelper.setEyePos(entity, eyePos, lastTickEyePos);
            McHelper.updateBoundingBox(entity);
        }
    }

    private static double transformScale(Portal portal, double oldScale) {
        double result = oldScale * portal.getScaling();
        if (Math.abs(result - 1.0) < 1.0E-4) {
            result = 1.0;
        }
        return result;
    }

    private static boolean isScaleIllegal(double scale) {
        return scale > (double)IPGlobal.scaleLimit || scale < 1.0 / (double)(IPGlobal.scaleLimit * 2);
    }
}

