/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import com.mojang.blaze3d.platform.GlUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IERayTraceContext;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.render.CrossPortalEntityRenderer;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class IPMcHelper {
    public static final LimitedLogger limitedLogger = new LimitedLogger(20);

    public static void foreachNearbyPortals(Level world, Vec3 pos, int range, Consumer<Portal> func) {
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
        for (Portal globalPortal : globalPortals) {
            if (!(globalPortal.getDistanceToNearestPointInPortal(pos) < (double)(range * 2))) continue;
            func.accept(globalPortal);
        }
        McHelper.foreachEntitiesByPointAndRoughRadius(Portal.class, world, pos, range, func);
    }

    public static List<Portal> getNearbyPortalList(Entity center, double range, Predicate<Portal> predicate) {
        return IPMcHelper.getNearbyPortalList(center.level(), center.position(), range, predicate);
    }

    public static List<Portal> getNearbyPortalList(Level world, Vec3 pos, double range, Predicate<Portal> predicate) {
        ArrayList<Portal> result = new ArrayList<Portal>();
        IPMcHelper.foreachNearbyPortals(world, pos, (int)range, portal -> {
            if (predicate.test((Portal)portal)) {
                result.add((Portal)portal);
            }
        });
        return result;
    }

    public static Stream<Portal> getNearbyPortals(Entity center, double range) {
        return IPMcHelper.getNearbyPortals(center.level(), center.position(), range);
    }

    public static Stream<Portal> getNearbyPortals(Level world, Vec3 pos, double range) {
        return IPMcHelper.getNearbyPortalList(world, pos, range, e -> true).stream();
    }

    public static void traverseNearbyPortals(Level world, Vec3 pos, int range, Consumer<Portal> func) {
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
        for (Portal globalPortal : globalPortals) {
            if (!(globalPortal.getDistanceToNearestPointInPortal(pos) < (double)(range * 2))) continue;
            func.accept(globalPortal);
        }
        McHelper.traverseEntitiesByPointAndRoughRadius(Portal.class, world, pos, range, portal -> {
            func.accept((Portal)portal);
            return null;
        });
    }

    public static void onClientEntityTick(Entity entity) {
        CrossPortalEntityRenderer.onEntityTickClient(entity);
    }

    public static List<Tuple<Portal, Vec3>> rayTracePortals(Level world, Vec3 start, Vec3 end, boolean includeGlobalPortals, Predicate<Portal> filter) {
        Vec3 middle = start.scale(0.5).add(end.scale(0.5));
        int chunkRadius = (int)Math.ceil(Math.abs(start.distanceTo(end) / 2.0) / 16.0);
        List<Portal> nearby = McHelper.getEntitiesNearby(world, middle, Portal.class, chunkRadius * 16);
        if (includeGlobalPortals) {
            nearby.addAll(GlobalPortalStorage.getGlobalPortals(world));
        }
        ArrayList<Tuple<Portal, Vec3>> hits = new ArrayList<Tuple<Portal, Vec3>>();
        nearby.forEach(portal -> {
            Vec3 intersection;
            if ((filter == null || filter.test((Portal)portal)) && (intersection = portal.rayTrace(start, end)) != null) {
                hits.add(new Tuple(portal, (Object)intersection));
            }
        });
        hits.sort((pair1, pair2) -> {
            Vec3 intersection1 = (Vec3)pair1.getB();
            Vec3 intersection2 = (Vec3)pair2.getB();
            return (int)Math.signum(intersection1.distanceToSqr(start) - intersection2.distanceToSqr(start));
        });
        return hits;
    }

    public static <T> T withSwitchedContext(Level world, Supplier<T> func) {
        if (world.isClientSide) {
            return ClientWorldLoader.withSwitchedWorld((ClientLevel)world, func);
        }
        return func.get();
    }

    private static Tuple<BlockHitResult, List<Portal>> rayTrace(Level world, ClipContext context, boolean includeGlobalPortals, List<Portal> portals) {
        Vec3 start = context.getFrom();
        Vec3 end = context.getTo();
        if (portals.size() > IPGlobal.maxPortalLayer) {
            Vec3 diff = end.subtract(start);
            return new Tuple((Object)BlockHitResult.miss((Vec3)end, (Direction)Direction.getNearest((double)diff.x, (double)diff.y, (double)diff.z), (BlockPos)BlockPos.containing((Position)end)), portals);
        }
        BlockHitResult hitResult = world.clip(context);
        List<Tuple<Portal, Vec3>> rayTracedPortals = IPMcHelper.rayTracePortals(world, start, end, includeGlobalPortals, Portal::isInteractable);
        if (rayTracedPortals.isEmpty()) {
            return new Tuple((Object)hitResult, portals);
        }
        Tuple<Portal, Vec3> portalHit = rayTracedPortals.get(0);
        Portal portal = (Portal)portalHit.getA();
        Vec3 intersection = (Vec3)portalHit.getB();
        if (hitResult.getLocation().distanceToSqr(start) < intersection.distanceToSqr(start)) {
            return new Tuple((Object)hitResult, portals);
        }
        IERayTraceContext betterContext = (IERayTraceContext)context;
        betterContext.ip_setStart(portal.transformPoint(intersection)).ip_setEnd(portal.transformPoint(end));
        portals.add(portal);
        Level destWorld = portal.getDestinationWorld();
        Tuple recursion = IPMcHelper.withSwitchedContext(destWorld, () -> IPMcHelper.rayTrace(destWorld, context, includeGlobalPortals, portals));
        betterContext.ip_setStart(start).ip_setEnd(end);
        return recursion;
    }

    public static Tuple<BlockHitResult, List<Portal>> rayTrace(Level world, ClipContext context, boolean includeGlobalPortals) {
        return IPMcHelper.rayTrace(world, context, includeGlobalPortals, new ArrayList<Portal>());
    }

    public static boolean hitResultIsMissedOrNull(HitResult hitResult) {
        return hitResult == null || hitResult.getType() == HitResult.Type.MISS;
    }

    public static MutableComponent getTextWithCommand(MutableComponent component, String command) {
        return component.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)).withUnderlined(Boolean.valueOf(true)));
    }

    public static Component getDisableWarningText(String warningKey) {
        return Component.literal((String)" ").append((Component)IPMcHelper.getTextWithCommand(Component.translatable((String)"imm_ptl.disable_warning"), "/imm_ptl_client_debug disable_warning_for \"" + warningKey + "\"")).append(" ");
    }

    public static Component getDisableUpdateCheckText() {
        return Component.literal((String)" ").append((Component)IPMcHelper.getTextWithCommand(Component.translatable((String)"imm_ptl.disable_update_check"), "/imm_ptl_client_debug disable_update_check"));
    }

    public static boolean isNvidiaVideocard() {
        return GlUtil.getVendor().toLowerCase().contains("nvidia");
    }

    public static FriendlyByteBuf bytesToBuf(byte[] packetBytes) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])packetBytes));
        return buf;
    }

    public static byte[] bufToBytes(FriendlyByteBuf buf) {
        byte[] packetBytes = new byte[buf.readableBytes()];
        buf.readBytes(packetBytes);
        return packetBytes;
    }
}

