/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import de.nick1st.imm_ptl.events.ClientExitEvent;
import de.nick1st.imm_ptl.events.DimensionEvents;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IECamera;
import qouteall.imm_ptl.core.ducks.IEClientPlayNetworkHandler;
import qouteall.imm_ptl.core.ducks.IEClientWorld;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.ducks.IEParticleManager;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.mixin.client.accessor.IEClientLevelData;
import qouteall.imm_ptl.core.mixin.client.accessor.IEClientLevel_Accessor;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.context_management.DimensionRenderHelper;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.q_misc_util.my_util.CountDownInt;

public class ClientWorldLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientWorldLoader.class);
    private static final CountDownInt LOG_LIMIT = new CountDownInt(20);
    private static final Map<ResourceKey<Level>, ClientLevel> CLIENT_WORLD_MAP = new Object2ObjectOpenHashMap();
    public static final Map<ResourceKey<Level>, LevelRenderer> WORLD_RENDERER_MAP = new Object2ObjectOpenHashMap();
    public static final Map<ResourceKey<Level>, DimensionRenderHelper> RENDER_HELPER_MAP = new Object2ObjectOpenHashMap();
    @Nullable
    public static Map<ResourceKey<Level>, ResourceKey<DimensionType>> dimIdToDimTypeId;
    private static final Minecraft CLIENT;
    private static boolean isInitialized;
    private static boolean isCreatingClientWorld;
    public static boolean isClientRemoteTicking;
    private static boolean isWorldSwitched;
    private static boolean isReloadingOtherWorldRenderers;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(DimensionEvents.CLIENT_DIMENSION_UPDATE_EVENT.class, event -> {
            if (ClientWorldLoader.getIsInitialized()) {
                List<ResourceKey> dimensionsToRemove = CLIENT_WORLD_MAP.keySet().stream().filter(dim -> !event.dimensions.contains(dim)).toList();
                for (ResourceKey dim2 : dimensionsToRemove) {
                    ClientWorldLoader.disposeDimensionDynamically((ResourceKey<Level>)dim2);
                }
            }
        });
        NeoForge.EVENT_BUS.addListener(ClientExitEvent.class, e -> {
            dimIdToDimTypeId = null;
        });
    }

    public static boolean getIsInitialized() {
        return isInitialized;
    }

    public static boolean getIsCreatingClientWorld() {
        return isCreatingClientWorld;
    }

    public static void tick() {
        if (IPCGlobal.isClientRemoteTickingEnabled) {
            isClientRemoteTicking = true;
            CLIENT_WORLD_MAP.values().forEach(world -> {
                if (ClientWorldLoader.CLIENT.level != world) {
                    ClientWorldLoader.tickRemoteWorld(world);
                }
            });
            WORLD_RENDERER_MAP.values().forEach(worldRenderer -> {
                if (worldRenderer != ClientWorldLoader.CLIENT.levelRenderer) {
                    worldRenderer.tick();
                }
            });
            isClientRemoteTicking = false;
        }
        boolean lightmapTextureConflict = false;
        for (DimensionRenderHelper helper : RENDER_HELPER_MAP.values()) {
            helper.tick();
            if (helper.world == ClientWorldLoader.CLIENT.level || helper.lightmapTexture != ClientWorldLoader.CLIENT.gameRenderer.lightTexture()) continue;
            assert (ClientWorldLoader.CLIENT.level != null);
            LOGGER.info("Lightmap Texture Conflict {} {}", (Object)helper.world.dimension().location(), (Object)ClientWorldLoader.CLIENT.level.dimension().location());
            lightmapTextureConflict = true;
        }
        if (lightmapTextureConflict) {
            ClientWorldLoader.disposeRenderHelpers();
            LOGGER.info("Refreshed Lightmaps");
        }
    }

    public static void disposeRenderHelpers() {
        RENDER_HELPER_MAP.values().forEach(DimensionRenderHelper::cleanUp);
        RENDER_HELPER_MAP.clear();
    }

    private static void tickRemoteWorld(ClientLevel newWorld) {
        List nearbyPortals = CHelper.getClientNearbyPortals(10.0).collect(Collectors.toList());
        ClientWorldLoader.withSwitchedWorld(newWorld, () -> {
            block3: {
                try {
                    newWorld.tickEntities();
                    newWorld.tick(() -> true);
                    if (!CLIENT.isPaused()) {
                        ClientWorldLoader.tickRemoteWorldRandomTicksClient(newWorld, nearbyPortals);
                    }
                    newWorld.pollLightUpdates();
                }
                catch (Throwable e) {
                    if (!LOG_LIMIT.tryDecrement()) break block3;
                    LOGGER.error("", e);
                }
            }
        });
    }

    private static void tickRemoteWorldRandomTicksClient(ClientLevel newWorld, List<Portal> nearbyPortals) {
        nearbyPortals.stream().filter(portal -> portal.getDestDim() == newWorld.dimension()).findFirst().ifPresent(portal -> {
            assert (ClientWorldLoader.CLIENT.player != null);
            Vec3 playerPos = ClientWorldLoader.CLIENT.player.position();
            Vec3 center = portal.transformPoint(playerPos);
            Camera camera = ClientWorldLoader.CLIENT.gameRenderer.getMainCamera();
            Vec3 oldCameraPos = camera.getPosition();
            ((IECamera)camera).portal_setPos(center);
            if (newWorld.getGameTime() % 2L == 0L) {
                newWorld.animateTick((int)center.x, (int)center.y, (int)center.z);
            }
            ClientWorldLoader.CLIENT.particleEngine.tick();
            ((IECamera)camera).portal_setPos(oldCameraPos);
        });
    }

    public static void cleanUp() {
        WORLD_RENDERER_MAP.values().forEach(ClientWorldLoader::disposeWorldRenderer);
        for (ClientLevel clientWorld : CLIENT_WORLD_MAP.values()) {
            ((IEClientWorld)clientWorld).ip_resetWorldRendererRef();
        }
        CLIENT_WORLD_MAP.clear();
        WORLD_RENDERER_MAP.clear();
        ClientWorldLoader.disposeRenderHelpers();
        isInitialized = false;
    }

    private static void disposeWorldRenderer(LevelRenderer worldRenderer) {
        worldRenderer.setLevel(null);
        if (worldRenderer != ClientWorldLoader.CLIENT.levelRenderer) {
            worldRenderer.close();
            ((IEWorldRenderer)worldRenderer).portal_fullyDispose();
        }
    }

    private static void disposeDimensionDynamically(ResourceKey<Level> dimension) {
        Validate.notNull((Object)ClientWorldLoader.CLIENT.player, (String)"player is null", (Object[])new Object[0]);
        Validate.notNull((Object)ClientWorldLoader.CLIENT.level, (String)"level is null", (Object[])new Object[0]);
        Validate.isTrue((ClientWorldLoader.CLIENT.level.dimension() != dimension ? 1 : 0) != 0, (String)"Cannot dispose current dimension", (Object[])new Object[0]);
        Validate.isTrue((ClientWorldLoader.CLIENT.player.level().dimension() != dimension ? 1 : 0) != 0, (String)"Cannot dispose current dimension", (Object[])new Object[0]);
        Validate.isTrue((boolean)CLIENT.isSameThread(), (String)"not on client thread", (Object[])new Object[0]);
        LevelRenderer worldRenderer = WORLD_RENDERER_MAP.get(dimension);
        ClientWorldLoader.disposeWorldRenderer(worldRenderer);
        WORLD_RENDERER_MAP.remove(dimension);
        Validate.isTrue((ClientWorldLoader.CLIENT.levelRenderer != worldRenderer ? 1 : 0) != 0);
        ClientLevel clientWorld = CLIENT_WORLD_MAP.get(dimension);
        ((IEClientWorld)clientWorld).ip_resetWorldRendererRef();
        CLIENT_WORLD_MAP.remove(dimension);
        DimensionRenderHelper renderHelper = RENDER_HELPER_MAP.remove(dimension);
        if (renderHelper != null) {
            renderHelper.cleanUp();
        }
        LOGGER.info("Client Dynamically Removed Dimension {}", (Object)dimension.location());
        if (clientWorld.getChunkSource().getLoadedChunksCount() > 0) {
            LOGGER.error("The chunks of that dimension was not cleared before removal");
        }
        if (clientWorld.getEntityCount() > 0) {
            LOGGER.error("The entities of that dimension was not cleared before removal");
        }
        ClientWorldLoader.CLIENT.gameRenderer.resetData();
        NeoForge.EVENT_BUS.post((Event)new DimensionEvents.CLIENT_DIMENSION_DYNAMIC_REMOVE_EVENT(dimension));
    }

    @NotNull
    public static LevelRenderer getWorldRenderer(ResourceKey<Level> dimension) {
        ClientWorldLoader.initializeIfNeeded();
        LevelRenderer result = WORLD_RENDERER_MAP.get(dimension);
        if (result == null) {
            LOGGER.warn("Acquiring LevelRenderer before acquiring Level. Something is probably wrong. {}", (Object)dimension.location(), (Object)new Throwable());
            ClientWorldLoader.getWorld(dimension);
            result = WORLD_RENDERER_MAP.get(dimension);
            if (result == null) {
                throw new RuntimeException("Unable to get LevelRenderer of " + String.valueOf(dimension.location()));
            }
        }
        return result;
    }

    @NotNull
    public static ClientLevel getWorld(ResourceKey<Level> dimension) {
        Validate.notNull(dimension, (String)"dimension is null", (Object[])new Object[0]);
        Validate.isTrue((boolean)CLIENT.isSameThread());
        ClientWorldLoader.initializeIfNeeded();
        if (!CLIENT_WORLD_MAP.containsKey(dimension)) {
            return ClientWorldLoader.createSecondaryClientWorld(dimension);
        }
        ClientLevel result = CLIENT_WORLD_MAP.get(dimension);
        Validate.notNull((Object)result, (String)"null value in world map", (Object[])new Object[0]);
        return result;
    }

    @Nullable
    public static ClientLevel getOptionalWorld(ResourceKey<Level> dimension) {
        Validate.notNull(dimension, (String)"dimension is null", (Object[])new Object[0]);
        Validate.isTrue((boolean)CLIENT.isSameThread(), (String)"not on client thread", (Object[])new Object[0]);
        if (ClientWorldLoader.getServerDimensions().contains(dimension)) {
            return ClientWorldLoader.getWorld(dimension);
        }
        return null;
    }

    public static DimensionRenderHelper getDimensionRenderHelper(ResourceKey<Level> dimension) {
        ClientWorldLoader.initializeIfNeeded();
        DimensionRenderHelper result = RENDER_HELPER_MAP.computeIfAbsent(dimension, dimensionType -> new DimensionRenderHelper((Level)ClientWorldLoader.getWorld(dimension)));
        Validate.isTrue((result.world.dimension() == dimension ? 1 : 0) != 0);
        return result;
    }

    public static void initializeIfNeeded() {
        if (!isInitialized) {
            Validate.isTrue((ClientWorldLoader.CLIENT.level != null ? 1 : 0) != 0, (String)"level is null", (Object[])new Object[0]);
            Validate.isTrue((ClientWorldLoader.CLIENT.levelRenderer != null ? 1 : 0) != 0, (String)"levelRenderer is null", (Object[])new Object[0]);
            Validate.notNull((Object)ClientWorldLoader.CLIENT.player, (String)"player is null. This may be caused by prior initialization failure. The log may provide useful information.", (Object[])new Object[0]);
            Validate.isTrue((ClientWorldLoader.CLIENT.player.level() == ClientWorldLoader.CLIENT.level ? 1 : 0) != 0, (String)"The player level is not the same as client level", (Object[])new Object[0]);
            ResourceKey playerDimension = ClientWorldLoader.CLIENT.level.dimension();
            CLIENT_WORLD_MAP.put((ResourceKey<Level>)playerDimension, ClientWorldLoader.CLIENT.level);
            WORLD_RENDERER_MAP.put((ResourceKey<Level>)playerDimension, ClientWorldLoader.CLIENT.levelRenderer);
            RENDER_HELPER_MAP.put((ResourceKey<Level>)ClientWorldLoader.CLIENT.level.dimension(), new DimensionRenderHelper((Level)ClientWorldLoader.CLIENT.level));
            isInitialized = true;
        }
    }

    private static ClientLevel createSecondaryClientWorld(ResourceKey<Level> dimension) {
        ClientLevel newWorld;
        Validate.notNull((Object)ClientWorldLoader.CLIENT.player, (String)"player is null", (Object[])new Object[0]);
        Validate.isTrue((boolean)CLIENT.isSameThread(), (String)"not on client thread", (Object[])new Object[0]);
        Set<ResourceKey<Level>> dimIds = ClientWorldLoader.getServerDimensions();
        if (!dimIds.contains(dimension)) {
            throw new RuntimeException("Cannot create invalid client dimension " + String.valueOf(dimension.location()));
        }
        isCreatingClientWorld = true;
        CLIENT.getProfiler().push("create_world");
        int chunkLoadDistance = 3;
        LevelRenderer worldRenderer = new LevelRenderer(CLIENT, CLIENT.getEntityRenderDispatcher(), CLIENT.getBlockEntityRenderDispatcher(), CLIENT.renderBuffers());
        try {
            ClientPacketListener mainNetHandler = ClientWorldLoader.CLIENT.player.connection;
            assert (ClientWorldLoader.CLIENT.level != null);
            Map<String, MapItemSavedData> mapData = ((IEClientLevel_Accessor)ClientWorldLoader.CLIENT.level).ip_getMapData();
            Validate.notNull(dimIdToDimTypeId, (String)"dimension type mapping is missing", (Object[])new Object[0]);
            ResourceKey<DimensionType> dimensionTypeKey = dimIdToDimTypeId.get(dimension);
            if (dimensionTypeKey == null) {
                throw new IllegalStateException("Cannot find dimension type for %s in %s".formatted(dimension.location(), dimIdToDimTypeId));
            }
            ClientLevel.ClientLevelData currentProperty = (ClientLevel.ClientLevelData)((IEWorld)ClientWorldLoader.CLIENT.level).ip_getLevelData();
            RegistryAccess.Frozen registryManager = mainNetHandler.registryAccess();
            int simulationDistance = ClientWorldLoader.CLIENT.level.getServerSimulationDistance();
            Holder.Reference dimensionType = registryManager.registryOrThrow(Registries.DIMENSION_TYPE).getHolderOrThrow(dimensionTypeKey);
            ClientLevel.ClientLevelData properties = new ClientLevel.ClientLevelData(currentProperty.getDifficulty(), currentProperty.isHardcore(), ((IEClientLevelData)currentProperty).ip_getIsFlat());
            newWorld = new ClientLevel(mainNetHandler, properties, dimension, (Holder)dimensionType, chunkLoadDistance, simulationDistance, () -> ((Minecraft)CLIENT).getProfiler(), worldRenderer, ClientWorldLoader.CLIENT.level.isDebug(), ClientWorldLoader.CLIENT.level.getBiomeManager().biomeZoomSeed);
            ((IEClientLevel_Accessor)newWorld).ip_setMapData(mapData);
            ((IEClientWorld)newWorld).ip_setTickRateManager(ClientWorldLoader.CLIENT.level.tickRateManager());
            worldRenderer.setLevel(newWorld);
            worldRenderer.onResourceManagerReload(CLIENT.getResourceManager());
            CLIENT_WORLD_MAP.put(dimension, newWorld);
            WORLD_RENDERER_MAP.put(dimension, worldRenderer);
            LOGGER.info("Client World Created {}", (Object)dimension.location());
        }
        catch (Exception e) {
            throw new IllegalStateException("Creating Client World " + String.valueOf(dimension.location()) + " " + String.valueOf(CLIENT_WORLD_MAP.keySet()), e);
        }
        finally {
            isCreatingClientWorld = false;
            CLIENT.getProfiler().pop();
        }
        NeoForge.EVENT_BUS.post((Event)new DimensionEvents.CLIENT_WORLD_LOAD_EVENT(newWorld));
        return newWorld;
    }

    public static Set<ResourceKey<Level>> getServerDimensions() {
        assert (ClientWorldLoader.CLIENT.player != null);
        return ClientWorldLoader.CLIENT.player.connection.levels();
    }

    public static Collection<ClientLevel> getClientWorlds() {
        Validate.isTrue((boolean)isInitialized);
        return CLIENT_WORLD_MAP.values();
    }

    public static void _onWorldRendererReloaded() {
        Validate.isTrue((boolean)CLIENT.isSameThread());
        if (ClientWorldLoader.CLIENT.level != null) {
            LOGGER.info("WorldRenderer reloaded {}", (Object)ClientWorldLoader.CLIENT.level.dimension().location());
        }
        if (isReloadingOtherWorldRenderers) {
            return;
        }
        if (PortalRendering.isRendering()) {
            return;
        }
        if (ClientWorldLoader.getIsCreatingClientWorld()) {
            return;
        }
        isReloadingOtherWorldRenderers = true;
        List<ResourceKey> toReload = WORLD_RENDERER_MAP.keySet().stream().filter(d -> d != ClientWorldLoader.CLIENT.level.dimension()).toList();
        for (ResourceKey dim : toReload) {
            ClientLevel world = CLIENT_WORLD_MAP.get(dim);
            Validate.notNull((Object)world, (String)"missing client world %s", (Object[])new Object[]{dim.location()});
            ClientWorldLoader.withSwitchedWorld(world, () -> ClientWorldLoader.CLIENT.levelRenderer.allChanged());
        }
        isReloadingOtherWorldRenderers = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withSwitchedWorld(ClientLevel newWorld, Supplier<T> supplier) {
        Validate.isTrue((boolean)CLIENT.isSameThread(), (String)"not on client thread", (Object[])new Object[0]);
        Validate.isTrue((ClientWorldLoader.CLIENT.player != null ? 1 : 0) != 0, (String)"player is null", (Object[])new Object[0]);
        ClientPacketListener networkHandler = CLIENT.getConnection();
        assert (networkHandler != null);
        ClientLevel originalWorld = ClientWorldLoader.CLIENT.level;
        LevelRenderer originalWorldRenderer = ClientWorldLoader.CLIENT.levelRenderer;
        ClientLevel originalNetHandlerWorld = networkHandler.getLevel();
        boolean originalIsWorldSwitched = isWorldSwitched;
        LevelRenderer newWorldRenderer = ClientWorldLoader.getWorldRenderer((ResourceKey<Level>)newWorld.dimension());
        Validate.notNull((Object)newWorldRenderer, (String)"new world renderer is null", (Object[])new Object[0]);
        ClientWorldLoader.CLIENT.level = newWorld;
        ((IEParticleManager)ClientWorldLoader.CLIENT.particleEngine).ip_setWorld(newWorld);
        ((IEMinecraftClient)CLIENT).ip_setWorldRenderer(newWorldRenderer);
        ((IEClientPlayNetworkHandler)networkHandler).ip_setWorld(newWorld);
        isWorldSwitched = true;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            if (ClientWorldLoader.CLIENT.level != newWorld) {
                LOGGER.error("Respawn packet should not be redirected");
                originalWorld = ClientWorldLoader.CLIENT.level;
                originalWorldRenderer = ClientWorldLoader.CLIENT.levelRenderer;
            }
            ClientWorldLoader.CLIENT.level = originalWorld;
            ((IEMinecraftClient)CLIENT).ip_setWorldRenderer(originalWorldRenderer);
            ((IEParticleManager)ClientWorldLoader.CLIENT.particleEngine).ip_setWorld(originalWorld);
            ((IEClientPlayNetworkHandler)networkHandler).ip_setWorld(originalNetHandlerWorld);
            isWorldSwitched = originalIsWorldSwitched;
        }
    }

    public static void withSwitchedWorld(ClientLevel newWorld, Runnable runnable) {
        ClientWorldLoader.withSwitchedWorld(newWorld, () -> {
            runnable.run();
            return null;
        });
    }

    public static void withSwitchedWorldFailSoft(ResourceKey<Level> dim, Runnable runnable) {
        ClientLevel world = ClientWorldLoader.getOptionalWorld(dim);
        if (runnable == null) {
            LOGGER.error("Breakpoint");
        }
        if (world == null) {
            LOGGER.error("Ignoring redirected task of invalid dimension {}", (Object)dim.location(), (Object)new Throwable());
            return;
        }
        ClientWorldLoader.withSwitchedWorld(world, runnable);
    }

    public static boolean getIsWorldSwitched() {
        return isWorldSwitched;
    }

    static {
        CLIENT = Minecraft.getInstance();
        isInitialized = false;
        isCreatingClientWorld = false;
        isClientRemoteTicking = false;
        isWorldSwitched = false;
        isReloadingOtherWorldRenderers = false;
    }

    public static class RemoteCallables {
        public static void checkBiomeRegistry(Map<String, Integer> idMap) {
            LocalPlayer player = Minecraft.getInstance().player;
            assert (player != null);
            RegistryAccess.Frozen registryAccess = player.connection.registryAccess();
            Registry biomes = registryAccess.registryOrThrow(Registries.BIOME);
            for (Map.Entry<String, Integer> entry : idMap.entrySet()) {
                ResourceLocation id = McHelper.newResourceLocation(entry.getKey());
                int expectedId = entry.getValue();
                if (biomes.getId((Object)((Biome)biomes.get(id))) == expectedId) continue;
                LOGGER.error("Biome intId mismatch: {} {}", (Object)id, (Object)expectedId);
            }
            if (idMap.size() != biomes.keySet().size()) {
                LOGGER.error("Biome intId mismatch: size not equal");
            }
            LOGGER.info("Biome intId check finished");
        }
    }
}

