/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.JukeboxSong;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StorageSoundHandler;

public record PlayDiscPayload(boolean blockStorage, UUID storageUuid, Holder<JukeboxSong> song, int entityId, BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayDiscPayload> TYPE = new CustomPacketPayload.Type(SophisticatedCore.getRL("play_disc"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayDiscPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, PlayDiscPayload::blockStorage, (StreamCodec)UUIDUtil.STREAM_CODEC, PlayDiscPayload::storageUuid, (StreamCodec)JukeboxSong.STREAM_CODEC, PlayDiscPayload::song, (StreamCodec)ByteBufCodecs.INT, PlayDiscPayload::entityId, (StreamCodec)BlockPos.STREAM_CODEC, PlayDiscPayload::pos, PlayDiscPayload::new);

    public PlayDiscPayload(UUID storageUuid, Holder<JukeboxSong> song, BlockPos pos) {
        this(true, storageUuid, song, 0, pos);
    }

    public PlayDiscPayload(UUID storageUuid, Holder<JukeboxSong> song, int entityId) {
        this(false, storageUuid, song, entityId, BlockPos.ZERO);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(PlayDiscPayload payload, IPayloadContext context) {
        SoundEvent soundEvent = (SoundEvent)((JukeboxSong)payload.song().value()).soundEvent().value();
        if (payload.blockStorage) {
            StorageSoundHandler.playStorageSound(soundEvent, payload.storageUuid, payload.pos);
        } else {
            StorageSoundHandler.playStorageSound(soundEvent, payload.storageUuid, payload.entityId);
        }
    }
}

