/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.attachment.v4;

import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.attachment.v4.DataAttachmentType;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import fuzs.puzzleslib.impl.attachment.DataAttachmentRegistryImpl;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public final class DataAttachmentRegistry {
    private DataAttachmentRegistry() {
    }

    public static <A> EntityBuilder<A> entityBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getEntityTypeBuilder();
    }

    public static <A> Builder<BlockEntity, A> blockEntityBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getBlockEntityTypeBuilder();
    }

    public static <A> Builder<LevelChunk, A> levelChunkBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getLevelChunkBuilder();
    }

    public static <A> Builder<Level, A> levelBuilder() {
        return DataAttachmentRegistryImpl.INSTANCE.getLevelBuilder();
    }

    public static interface EntityBuilder<A>
    extends RegistryBuilder<Entity, A> {
        public EntityBuilder<A> persistent(Codec<A> var1);

        default public EntityBuilder<A> defaultValue(A defaultValue) {
            return (EntityBuilder)RegistryBuilder.super.defaultValue((Object)defaultValue);
        }

        default public EntityBuilder<A> defaultValue(Class<? extends Entity> type, A defaultValue) {
            return (EntityBuilder)RegistryBuilder.super.defaultValue(type, defaultValue);
        }

        default public EntityBuilder<A> defaultValue(EntityType<?> type, A defaultValue) {
            return this.defaultValue(entity -> entity.getType() == type, (Object)defaultValue);
        }

        public EntityBuilder<A> defaultValue(Predicate<Entity> var1, A var2);

        default public EntityBuilder<A> networkSynchronized(StreamCodec<? super RegistryFriendlyByteBuf, A> streamCodec) {
            return this.networkSynchronized(streamCodec, null);
        }

        public EntityBuilder<A> networkSynchronized(StreamCodec<? super RegistryFriendlyByteBuf, A> var1, @Nullable Function<Entity, PlayerSet> var2);

        public EntityBuilder<A> copyOnDeath();
    }

    public static interface Builder<T, A> {
        public Builder<T, A> defaultValue(A var1);

        public Builder<T, A> persistent(Codec<A> var1);

        public DataAttachmentType<T, A> build(ResourceLocation var1);
    }

    public static interface BlockEntityBuilder<A>
    extends RegistryBuilder<BlockEntity, A> {
        default public BlockEntityBuilder<A> defaultValue(A defaultValue) {
            return (BlockEntityBuilder)RegistryBuilder.super.defaultValue((Object)defaultValue);
        }

        default public BlockEntityBuilder<A> defaultValue(Class<? extends BlockEntity> type, A defaultValue) {
            return (BlockEntityBuilder)RegistryBuilder.super.defaultValue(type, defaultValue);
        }

        default public BlockEntityBuilder<A> defaultValue(BlockEntityType<?> type, A defaultValue) {
            return this.defaultValue(blockEntity -> blockEntity.getType() == type, (Object)defaultValue);
        }

        public BlockEntityBuilder<A> defaultValue(Predicate<BlockEntity> var1, A var2);

        public BlockEntityBuilder<A> persistent(Codec<A> var1);
    }

    public static interface RegistryBuilder<T, A>
    extends Builder<T, A> {
        @Override
        default public RegistryBuilder<T, A> defaultValue(A defaultValue) {
            return this.defaultValue((Predicate<T>)Predicates.alwaysTrue(), defaultValue);
        }

        default public RegistryBuilder<T, A> defaultValue(Class<? extends T> type, A defaultValue) {
            return this.defaultValue(type::isInstance, defaultValue);
        }

        public RegistryBuilder<T, A> defaultValue(Predicate<T> var1, A var2);
    }
}

