/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client;

import com.teammetallurgy.aquaculture.client.gui.screen.TackleBoxScreen;
import com.teammetallurgy.aquaculture.client.renderer.entity.AquaBobberRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.AquaFishRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.FishMountRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.TurtleLandRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishCathfishModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLargeModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLongnoseModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishMediumModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishSmallModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.JellyfishModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.TurtleLandModel;
import com.teammetallurgy.aquaculture.client.renderer.tileentity.NeptunesBountyRenderer;
import com.teammetallurgy.aquaculture.client.renderer.tileentity.TackleBoxRenderer;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.init.AquaBlockEntities;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import com.teammetallurgy.aquaculture.init.AquaGuis;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.FishRegistry;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.SpectralArrowRenderer;
import net.minecraft.client.renderer.entity.TippableArrowRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="aquaculture", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientHandler {
    public static final ModelLayerLocation TACKLE_BOX = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"tackle_box"), "tackle_box");
    public static final ModelLayerLocation TURTLE_LAND_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"turtle_land"), "turtle_land");
    public static final ModelLayerLocation SMALL_MODEL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"small_model"), "small_model");
    public static final ModelLayerLocation MEDIUM_MODEL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"medium_model"), "medium_model");
    public static final ModelLayerLocation LARGE_MODEL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"large_model"), "large_model");
    public static final ModelLayerLocation LONGNOSE_MODEL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"longnose_model"), "longnose_model");
    public static final ModelLayerLocation CATFISH_MODEL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"catfish_model"), "catfish_model");
    public static final ModelLayerLocation JELLYFISH_MODEL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"jellyfish_model"), "jellyfish_model");

    public static void setupClient() {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)AquaBlockEntities.NEPTUNES_BOUNTY.get()), NeptunesBountyRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)AquaBlockEntities.TACKLE_BOX.get()), TackleBoxRenderer::new);
        ClientHandler.registerFishingRodModelProperties((Item)AquaItems.IRON_FISHING_ROD.get());
        ClientHandler.registerFishingRodModelProperties((Item)AquaItems.GOLD_FISHING_ROD.get());
        ClientHandler.registerFishingRodModelProperties((Item)AquaItems.DIAMOND_FISHING_ROD.get());
        ClientHandler.registerFishingRodModelProperties((Item)AquaItems.NEPTUNIUM_FISHING_ROD.get());
        ClientHandler.registerBowModelProperties((Item)AquaItems.NEPTUNIUM_BOW.get());
    }

    @SubscribeEvent
    public static void registerMenuScreen(RegisterMenuScreensEvent event) {
        event.register((MenuType)AquaGuis.TACKLE_BOX.get(), TackleBoxScreen::new);
    }

    @SubscribeEvent
    public static void registerColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)FastColor.ARGB32.color((int)0, (int)0, (int)0)), new ItemLike[]{(ItemLike)AquaItems.FISHING_LINE.get()});
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)FastColor.ARGB32.color((int)193, (int)38, (int)38)), new ItemLike[]{(ItemLike)AquaItems.BOBBER.get()});
    }

    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)AquaEntities.BOBBER.get(), AquaBobberRenderer::new);
        for (DeferredHolder<EntityType<?>, EntityType<AquaFishEntity>> deferredHolder : FishRegistry.fishEntities) {
            event.registerEntityRenderer((EntityType)deferredHolder.get(), context -> new AquaFishRenderer(context, BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)fish.get())).equals((Object)ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"jellyfish"))));
        }
        event.registerEntityRenderer((EntityType)AquaEntities.WATER_ARROW.get(), TippableArrowRenderer::new);
        event.registerEntityRenderer((EntityType)AquaEntities.SPECTRAL_WATER_ARROW.get(), SpectralArrowRenderer::new);
        event.registerEntityRenderer((EntityType)AquaEntities.BOX_TURTLE.get(), TurtleLandRenderer::new);
        event.registerEntityRenderer((EntityType)AquaEntities.ARRAU_TURTLE.get(), TurtleLandRenderer::new);
        event.registerEntityRenderer((EntityType)AquaEntities.STARSHELL_TURTLE.get(), TurtleLandRenderer::new);
        for (DeferredHolder deferredHolder : FishRegistry.fishMounts) {
            event.registerEntityRenderer((EntityType)deferredHolder.get(), FishMountRenderer::new);
        }
    }

    @SubscribeEvent
    public static void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(TACKLE_BOX, TackleBoxRenderer::createLayer);
        event.registerLayerDefinition(TURTLE_LAND_LAYER, TurtleLandModel::createBodyLayer);
        event.registerLayerDefinition(SMALL_MODEL, FishSmallModel::createBodyLayer);
        event.registerLayerDefinition(MEDIUM_MODEL, FishMediumModel::createBodyLayer);
        event.registerLayerDefinition(LARGE_MODEL, FishLargeModel::createBodyLayer);
        event.registerLayerDefinition(LONGNOSE_MODEL, FishLongnoseModel::createBodyLayer);
        event.registerLayerDefinition(CATFISH_MODEL, FishCathfishModel::createBodyLayer);
        event.registerLayerDefinition(JELLYFISH_MODEL, JellyfishModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"block/oak_fish_mount")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"block/spruce_fish_mount")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"block/birch_fish_mount")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"block/jungle_fish_mount")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"block/acacia_fish_mount")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"block/dark_oak_fish_mount")));
    }

    public static void registerFishingRodModelProperties(Item fishingRod) {
        ItemProperties.register((Item)fishingRod, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"cast"), (stack, level, entity, i) -> {
            boolean isOffHand;
            if (entity == null) {
                return 0.0f;
            }
            boolean isMainhand = entity.getMainHandItem() == stack;
            boolean bl = isOffHand = entity.getOffhandItem() == stack;
            if (entity.getMainHandItem().getItem() instanceof FishingRodItem) {
                isOffHand = false;
            }
            return (isMainhand || isOffHand) && entity instanceof Player && ((Player)entity).fishing != null ? 1.0f : 0.0f;
        });
    }

    public static void registerBowModelProperties(Item bow) {
        ItemProperties.register((Item)bow, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (stack, level, entity, i) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / 20.0f;
        });
        ItemProperties.register((Item)bow, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (stack, level, entity, i) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
    }
}

