/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.crafting.recipe;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.crafting.recipe.ComponentTransferringRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class PhotographCopyingRecipe
extends ComponentTransferringRecipe {
    public PhotographCopyingRecipe(CraftingBookCategory category, Ingredient sourceIngredient, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(category, sourceIngredient, ingredients, result);
    }

    @Override
    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Exposure.RecipeSerializers.PHOTOGRAPH_COPYING.get();
    }

    @Override
    @NotNull
    public ItemStack transferComponents(ItemStack stack, ItemStack recipeResultStack) {
        int generation = (Integer)stack.getOrDefault(Exposure.DataComponents.PHOTOGRAPH_GENERATION, (Object)0);
        if (generation < 2) {
            ItemStack result = super.transferComponents(stack, recipeResultStack);
            result.set(Exposure.DataComponents.PHOTOGRAPH_GENERATION, (Object)(generation + 1));
            return result;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList remainingItems = super.getRemainingItems((RecipeInput)input);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (!(stack.getItem() instanceof PhotographItem)) continue;
            ItemStack remainingPhotographStack = stack.copy();
            remainingPhotographStack.setCount(1);
            remainingItems.set(i, (Object)remainingPhotographStack);
        }
        return remainingItems;
    }
}

