/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.camera;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.item.FilmRollItem;
import io.github.mortuusars.exposure.world.item.component.StoredItemStack;
import io.github.mortuusars.exposure.world.sound.Sound;
import io.github.mortuusars.exposure.world.sound.SoundEffect;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record Attachment<T extends Item>(ResourceLocation id, DataComponentType<StoredItemStack> component, Predicate<ItemStack> itemPredicate, Class<T> itemType, Supplier<Integer> maxCount, Optional<SoundEffect> insertedSound, Optional<SoundEffect> removedSound) {
    public static final Attachment<FilmRollItem> FILM = new Attachment<FilmRollItem>(Exposure.resource("film"), Exposure.DataComponents.FILM, stack -> stack.getItem() instanceof FilmRollItem, FilmRollItem.class, () -> 1, new SoundEffect(Exposure.SoundEvents.FILM_ADVANCE, 0.9f, 1.0f), new SoundEffect(Exposure.SoundEvents.FILM_REMOVED, 0.7f, 1.0f));
    public static final Attachment<Item> FLASH = new Attachment<Item>(Exposure.resource("flash"), Exposure.DataComponents.FLASH, stack -> stack.is(Exposure.Tags.Items.FLASHES), Item.class, () -> 1, new SoundEffect(Exposure.SoundEvents.CAMERA_GENERIC_CLICK, 0.6f, 1.15f), new SoundEffect(Exposure.SoundEvents.CAMERA_GENERIC_CLICK, 0.35f, 0.95f));
    public static final Attachment<Item> LENS = new Attachment<Item>(Exposure.resource("lens"), Exposure.DataComponents.LENS, stack -> stack.is(Exposure.Tags.Items.LENSES), Item.class, () -> 1, new SoundEffect(Exposure.SoundEvents.LENS_INSERT), new SoundEffect(Exposure.SoundEvents.LENS_REMOVE));
    public static final Attachment<Item> FILTER = new Attachment<Item>(Exposure.resource("filter"), Exposure.DataComponents.FILTER, stack -> stack.is(Exposure.Tags.Items.FILTERS), Item.class, () -> 1, new SoundEffect(Exposure.SoundEvents.FILTER_INSERT), new SoundEffect(Exposure.SoundEvents.FILTER_REMOVE, 0.5f));

    public Attachment(ResourceLocation id, DataComponentType<StoredItemStack> component, Predicate<ItemStack> itemPredicate, Class<T> itemType, Supplier<Integer> maxCount, SoundEffect insertedSound, SoundEffect removedSound) {
        this(id, component, itemPredicate, itemType, maxCount, Optional.of(insertedSound), Optional.of(removedSound));
    }

    public Attachment(ResourceLocation id, DataComponentType<StoredItemStack> component, Predicate<ItemStack> itemPredicate, Class<T> itemType, Supplier<Integer> maxCount) {
        this(id, component, itemPredicate, itemType, maxCount, Optional.empty(), Optional.empty());
    }

    public boolean matches(ItemStack stack) {
        return this.itemPredicate.test(stack);
    }

    public boolean isEmpty(ItemStack stack) {
        StoredItemStack storedItemStack = this.get(stack);
        return storedItemStack.isEmpty() || !this.itemType.isInstance(storedItemStack.getItem());
    }

    public boolean isPresent(ItemStack stack) {
        return !this.isEmpty(stack);
    }

    public StoredItemStack get(ItemStack stack) {
        return (StoredItemStack)stack.getOrDefault(this.component, (Object)StoredItemStack.EMPTY);
    }

    public Attachment<T> ifPresent(ItemStack stack, BiConsumer<T, ItemStack> ifPresent) {
        StoredItemStack storedItemStack = this.get(stack);
        if (this.itemType.isInstance(storedItemStack.getItem())) {
            ifPresent.accept((Item)this.itemType.cast(storedItemStack.getItem()), storedItemStack.getForReading());
        }
        return this;
    }

    public Attachment<T> ifPresent(ItemStack stack, Consumer<ItemStack> ifPresent) {
        StoredItemStack storedItemStack = this.get(stack);
        if (this.itemType.isInstance(storedItemStack.getItem())) {
            ifPresent.accept(storedItemStack.getForReading());
        }
        return this;
    }

    public Attachment<T> orElse(ItemStack stack, Runnable orElse) {
        StoredItemStack storedItemStack = this.get(stack);
        if (!this.itemType.isInstance(storedItemStack.getItem())) {
            orElse.run();
        }
        return this;
    }

    public Attachment<T> ifPresentOrElse(ItemStack stack, BiConsumer<T, ItemStack> ifPresent, Runnable orElse) {
        return this.ifPresent(stack, ifPresent).orElse(stack, orElse);
    }

    public <R> Optional<R> map(ItemStack stack, Function<ItemStack, R> mappingFunc) {
        return this.mapOrElse(stack, (ItemStack st) -> Optional.of(mappingFunc.apply((ItemStack)st)), Optional::empty);
    }

    public <R> Optional<R> map(ItemStack stack, BiFunction<T, ItemStack, R> mappingFunc) {
        return this.mapOrElse(stack, (T it, ItemStack st) -> Optional.of(mappingFunc.apply((Object)it, (ItemStack)st)), Optional::empty);
    }

    public <R> R mapOrElse(ItemStack stack, Function<ItemStack, R> ifPresentMappingFunc, Supplier<R> orElseSupplier) {
        StoredItemStack storedItemStack = this.get(stack);
        return this.itemType.isInstance(storedItemStack.getItem()) ? ifPresentMappingFunc.apply(storedItemStack.getForReading()) : orElseSupplier.get();
    }

    public <R> R mapOrElse(ItemStack stack, BiFunction<T, ItemStack, R> ifPresentMappingFunc, Supplier<R> orElseSupplier) {
        StoredItemStack storedItemStack = this.get(stack);
        return this.itemType.isInstance(storedItemStack.getItem()) ? ifPresentMappingFunc.apply((Item)this.itemType.cast(storedItemStack.getItem()), storedItemStack.getForReading()) : orElseSupplier.get();
    }

    public Attachment<T> set(ItemStack stack, ItemStack attachment) {
        if (attachment.isEmpty()) {
            stack.remove(this.component);
        } else {
            stack.set(this.component, (Object)new StoredItemStack(attachment));
        }
        return this;
    }

    public void playInsertSoundSided(Entity entity) {
        this.insertedSound().ifPresent(sound -> Sound.playUniqueSided(Integer.toString(entity.getId()), entity, sound, SoundSource.PLAYERS));
    }

    public void playRemoveSoundSided(Entity entity) {
        this.removedSound().ifPresent(sound -> Sound.playUniqueSided(Integer.toString(entity.getId()), entity, sound, SoundSource.PLAYERS));
    }

    @Override
    public String toString() {
        return "Attachment{id='" + String.valueOf(this.id) + "'}";
    }
}

