/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.gui.ClientGUI;
import io.github.mortuusars.exposure.world.inventory.tooltip.PhotographTooltip;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class StackedPhotographsItem
extends Item {
    public static final Codec<ItemAndStack<PhotographItem>> PHOTOGRAPH_ITEM_AND_STACK_CODEC = ItemStack.CODEC.comapFlatMap(stack -> {
        if (stack.getItem() instanceof PhotographItem) {
            return DataResult.success(new ItemAndStack((ItemStack)stack));
        }
        return DataResult.error(() -> "'stacked_photographs' can only hold items of type PhotographItem.");
    }, ItemAndStack::getItemStack);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemAndStack<PhotographItem>> PHOTOGRAPH_ITEM_AND_STACK_STREAM_CODEC = ItemStack.STREAM_CODEC.map(ItemAndStack::new, ItemAndStack::getItemStack);

    public StackedPhotographsItem(Item.Properties properties) {
        super(properties);
    }

    public int getStackLimit() {
        return (Integer)Config.Server.STACKED_PHOTOGRAPHS_MAX_SIZE.get();
    }

    public List<ItemAndStack<PhotographItem>> getPhotographs(ItemStack stack) {
        return (List)stack.getOrDefault(Exposure.DataComponents.STACKED_PHOTOGRAPHS, Collections.emptyList());
    }

    public void setPhotographs(ItemStack stack, List<ItemAndStack<PhotographItem>> photographs) {
        stack.set(Exposure.DataComponents.STACKED_PHOTOGRAPHS, photographs);
    }

    public boolean canAddPhotograph(ItemStack stack) {
        return this.getPhotographs(stack).size() < this.getStackLimit();
    }

    public void addPhotograph(ItemStack stack, ItemStack photographStack, int index) {
        Preconditions.checkElementIndex((int)index, (int)(this.getPhotographs(stack).size() + 1));
        Preconditions.checkState((boolean)this.canAddPhotograph(stack), (Object)("Cannot add more photographs than this photo can store. Max count: " + this.getStackLimit()));
        Preconditions.checkArgument((boolean)(photographStack.getItem() instanceof PhotographItem), (Object)"Only PhotographItem can be stacked.");
        ArrayList<ItemAndStack<PhotographItem>> photographs = new ArrayList<ItemAndStack<PhotographItem>>(this.getPhotographs(stack));
        photographs.add(index, new ItemAndStack(photographStack));
        this.setPhotographs(stack, photographs);
    }

    public void addPhotographOnTop(ItemStack stack, ItemStack photographStack) {
        this.addPhotograph(stack, photographStack, 0);
    }

    public void addPhotographToBottom(ItemStack stack, ItemStack photographStack) {
        this.addPhotograph(stack, photographStack, this.getPhotographs(stack).size());
    }

    public ItemAndStack<PhotographItem> removePhotograph(ItemStack stack, int index) {
        Preconditions.checkElementIndex((int)index, (int)this.getPhotographs(stack).size());
        ArrayList<ItemAndStack<PhotographItem>> photographs = new ArrayList<ItemAndStack<PhotographItem>>(this.getPhotographs(stack));
        ItemAndStack<PhotographItem> removedPhotograph = photographs.remove(index);
        this.setPhotographs(stack, photographs);
        return removedPhotograph;
    }

    public ItemAndStack<PhotographItem> removeTopPhotograph(ItemStack stack) {
        return this.removePhotograph(stack, 0);
    }

    public ItemAndStack<PhotographItem> removeBottomPhotograph(ItemStack stack) {
        return this.removePhotograph(stack, this.getPhotographs(stack).size() - 1);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        List<ItemAndStack<PhotographItem>> photographs = this.getPhotographs(stack);
        if (photographs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new PhotographTooltip(photographs));
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        if (action != ClickAction.SECONDARY || this.getPhotographs(stack).isEmpty() || !slot.mayPlace(new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get()))) {
            return false;
        }
        ItemStack slotItem = slot.getItem();
        if (slotItem.isEmpty()) {
            ItemAndStack<PhotographItem> photograph = this.removeBottomPhotograph(stack);
            slot.set(photograph.getItemStack());
            if (this.getPhotographs(stack).size() == 1) {
                player.containerMenu.setCarried(this.removeTopPhotograph(stack).getItemStack());
            }
            StackedPhotographsItem.playRemoveSoundClientside(player);
            return true;
        }
        if (slotItem.getItem() instanceof PhotographItem && this.canAddPhotograph(stack)) {
            this.addPhotographToBottom(stack, slotItem);
            slot.set(ItemStack.EMPTY);
            StackedPhotographsItem.playAddSoundClientside(player);
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (action != ClickAction.SECONDARY || !slot.mayPlace(new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get()))) {
            return false;
        }
        if (!this.getPhotographs(stack).isEmpty() && other.isEmpty()) {
            ItemAndStack<PhotographItem> photograph = this.removeTopPhotograph(stack);
            access.set(photograph.getItemStack());
            if (this.getPhotographs(stack).size() == 1) {
                ItemAndStack<PhotographItem> lastPhotograph = this.removeTopPhotograph(stack);
                slot.set(lastPhotograph.getItemStack());
            }
            StackedPhotographsItem.playRemoveSoundClientside(player);
            return true;
        }
        if (other.getItem() instanceof PhotographItem) {
            if (this.canAddPhotograph(stack)) {
                this.addPhotographOnTop(stack, other);
                access.set(ItemStack.EMPTY);
                StackedPhotographsItem.playAddSoundClientside(player);
                return true;
            }
            return false;
        }
        Item lastPhotograph = other.getItem();
        if (lastPhotograph instanceof StackedPhotographsItem) {
            StackedPhotographsItem otherStackedItem = (StackedPhotographsItem)lastPhotograph;
            int otherCount = otherStackedItem.getPhotographs(other).size();
            int addedCount = 0;
            for (int i = 0; i < otherCount; ++i) {
                if (!this.canAddPhotograph(stack)) continue;
                ItemAndStack<PhotographItem> photograph = otherStackedItem.removeBottomPhotograph(other);
                this.addPhotographOnTop(stack, photograph.getItemStack());
                ++addedCount;
            }
            if (otherStackedItem.getPhotographs(other).isEmpty()) {
                access.set(ItemStack.EMPTY);
            } else if (otherStackedItem.getPhotographs(other).size() == 1) {
                access.set(otherStackedItem.removeTopPhotograph(other).getItemStack());
            }
            if (addedCount > 0) {
                StackedPhotographsItem.playAddSoundClientside(player);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (player.isSecondaryUseActive() && this.cyclePhotographs(itemInHand)) {
            player.level().playSound(player, (Entity)player, Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), SoundSource.PLAYERS, 0.6f, player.level().getRandom().nextFloat() * 0.2f + 1.2f);
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
            return InteractionResultHolder.success((Object)itemInHand);
        }
        List<ItemAndStack<PhotographItem>> photographs = this.getPhotographs(itemInHand);
        if (!photographs.isEmpty()) {
            if (level.isClientSide) {
                int slot = hand == InteractionHand.OFF_HAND ? 40 : player.getInventory().selected;
                ClientGUI.openPhotographsScreenFromItem(slot);
                player.playSound(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.6f, 1.1f);
            }
            return InteractionResultHolder.success((Object)itemInHand);
        }
        return InteractionResultHolder.fail((Object)itemInHand);
    }

    public boolean cyclePhotographs(ItemStack stack) {
        if (this.getPhotographs(stack).size() < 2) {
            return false;
        }
        ItemAndStack<PhotographItem> topPhotograph = this.removeTopPhotograph(stack);
        this.addPhotographToBottom(stack, topPhotograph.getItemStack());
        return true;
    }

    public static void playAddSoundClientside(Player player) {
        if (player.level().isClientSide) {
            player.playSound(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.6f, player.level().getRandom().nextFloat() * 0.2f + 1.2f);
        }
    }

    public static void playRemoveSoundClientside(Player player) {
        if (player.level().isClientSide) {
            player.playSound(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.75f, player.level().getRandom().nextFloat() * 0.2f + 0.75f);
        }
    }
}

