/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.event;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.animation.EasingFunction;
import io.github.mortuusars.exposure.client.camera.CameraClient;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderRegistry;
import io.github.mortuusars.exposure.client.capture.template.CameraCaptureTemplate;
import io.github.mortuusars.exposure.client.capture.template.CaptureTemplates;
import io.github.mortuusars.exposure.client.capture.template.PreloadingDummyCaptureTemplate;
import io.github.mortuusars.exposure.client.render.ItemFramePhotographRenderer;
import io.github.mortuusars.exposure.client.sound.UniqueSoundManager;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.network.handler.ClientPacketsHandler;
import io.github.mortuusars.exposure.network.packet.Packet;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.camera.capture.CaptureParameters;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ClientEvents {
    public static void levelUnloaded() {
    }

    public static void login() {
        try {
            ClientEvents.preloadStuffToFixLagSpikes();
        }
        catch (Exception e) {
            Exposure.LOGGER.warn("Failed to preload stuff: {}", (Object)e.getMessage());
        }
    }

    private static void preloadStuffToFixLagSpikes() {
        ClientPacketsHandler.clearRenderingCache();
        boolean active = Minecrft.player().getActiveExposureCameraOptional().isEmpty();
        EasingFunction.EASE_OUT_EXPO.ease(0.5);
        ViewfinderRegistry.getConstructor(Exposure.Items.CAMERA.get()).apply((Object)new Camera((CameraHolder)Minecrft.player(), CameraId.create()){

            @Override
            public ItemStack getItemStack() {
                return new ItemStack((ItemLike)Exposure.Items.CAMERA.get());
            }

            @Override
            public Packet createSyncPacket() {
                return null;
            }
        });
        CameraClient.removeViewfinder();
        CaptureTemplates.get(Exposure.resource("dummy"));
        CameraCaptureTemplate cameraCaptureTemplate = new CameraCaptureTemplate();
        ExposureClient.cycles().enqueueTask(new PreloadingDummyCaptureTemplate().createTask(new CaptureParameters.Builder("dummy").build()));
        UniqueSoundManager.stop(Minecrft.player().getScoreboardName(), Exposure.SoundEvents.CAMERA_BUTTON_CLICK.get());
    }

    public static void disconnect() {
        ClientEvents.resetRenderData();
    }

    public static void resetRenderData() {
        ExposureClient.exposureStore().clear();
        ExposureClient.renderedExposures().clearCache();
        ExposureClient.imageRenderer().clearCache();
    }

    public static boolean renderItemFrameItem(ItemFrame itemFrame, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (!((Boolean)Config.Client.PHOTOGRAPH_RENDERS_IN_ITEM_FRAME.get()).booleanValue()) {
            return false;
        }
        Item item = itemFrame.getItem().getItem();
        if (!(item instanceof PhotographItem)) {
            return false;
        }
        PhotographItem photographItem = (PhotographItem)item;
        if (photographItem.getFrame(itemFrame.getItem()).identifier().isEmpty()) {
            return false;
        }
        poseStack.pushPose();
        poseStack.scale(2.0f, 2.0f, 2.0f);
        ItemFramePhotographRenderer.render(itemFrame, poseStack, buffer, packedLight, photographItem, itemFrame.getItem());
        poseStack.popPose();
        return true;
    }

    public static void resourcesReloaded() {
        ExposureClient.exposureStore().clear();
        ExposureClient.renderedExposures().clearCache();
        ExposureClient.imageRenderer().clearCache();
    }
}

