/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.sound.instance;

import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.camera.CameraInHand;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ShutterTickingSoundInstance
extends EntityBoundSoundInstance {
    protected final CameraId cameraId;
    protected final float fullVolume;
    protected final int durationTicks;
    protected final long endsAtTick;
    protected Entity entity;

    public ShutterTickingSoundInstance(Entity entity, CameraId cameraId, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch, int durationTicks) {
        super(soundEvent, soundSource, volume, pitch, entity, entity.getRandom().nextLong());
        this.entity = entity;
        this.cameraId = cameraId;
        this.fullVolume = volume;
        this.durationTicks = durationTicks;
        this.endsAtTick = entity.level().getGameTime() + (long)durationTicks;
        this.looping = true;
        this.volume = 0.0f;
    }

    public void updateEntity(Entity entity) {
        this.entity = entity;
    }

    public boolean canStartSilent() {
        return true;
    }

    public boolean canPlaySound() {
        return !this.entity.isSilent();
    }

    public void tick() {
        CameraItem item;
        this.x = this.entity.getX();
        this.y = this.entity.getY();
        this.z = this.entity.getZ();
        if (this.endsAtTick - this.entity.level().getGameTime() < 0L) {
            this.stop();
            return;
        }
        ItemStack stack = ItemStack.EMPTY;
        boolean isOnHotbar = false;
        Entity entity = this.entity;
        if (entity instanceof CameraHolder) {
            CameraHolder holder = (CameraHolder)entity;
            @Nullable CameraInHand cameraInHand = CameraInHand.find(holder);
            if (cameraInHand != null && cameraInHand.idMatches(this.cameraId)) {
                stack = cameraInHand.getItemStack();
            } else {
                Player player;
                ItemStack hotbarStack;
                Entity entity2 = this.entity;
                if (entity2 instanceof Player && !(hotbarStack = this.getCameraOnHotbar(player = (Player)entity2)).isEmpty()) {
                    stack = hotbarStack;
                    isOnHotbar = true;
                }
            }
        } else {
            ItemEntity itemEntity;
            entity = this.entity;
            if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).getItem().getItem() instanceof CameraItem) {
                stack = itemEntity.getItem();
            }
        }
        Item item2 = stack.getItem();
        this.volume = item2 instanceof CameraItem && (item = (CameraItem)item2).getShutter().isOpen(stack) ? (isOnHotbar ? this.fullVolume * 0.35f : this.fullVolume) : 0.0f;
    }

    protected ItemStack getCameraOnHotbar(Player player) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!this.cameraId.matches(stack)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }
}

