/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.sound;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import io.github.mortuusars.exposure.client.util.Minecrft;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class UniqueSoundManager {
    private static final Table<String, ResourceLocation, SoundInstance> SOUNDS = HashBasedTable.create();

    public static void play(String id, SoundInstance instance) {
        UniqueSoundManager.stop(id, instance.getLocation());
        SOUNDS.put((Object)id, (Object)instance.getLocation(), (Object)instance);
        Minecrft.get().getSoundManager().play(instance);
    }

    public static void play(String id, Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        SoundInstance soundInstance = UniqueSoundManager.createEntityBoundInstance(entity, sound, source, volume, pitch);
        UniqueSoundManager.play(id, soundInstance);
    }

    public static void play(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        String id = entity.getScoreboardName();
        UniqueSoundManager.play(id, entity, sound, source, volume, pitch);
    }

    public static void stop(String id, ResourceLocation location) {
        @Nullable SoundInstance instance = (SoundInstance)SOUNDS.remove((Object)id, (Object)location);
        if (instance != null) {
            Minecrft.get().getSoundManager().stop(instance);
        }
    }

    public static void stop(String id, SoundEvent sound) {
        UniqueSoundManager.stop(id, sound.getLocation());
    }

    public static void stopAllOf(SoundEvent sound) {
        ResourceLocation location = sound.getLocation();
        SOUNDS.cellSet().removeIf(cell -> {
            if (((ResourceLocation)cell.getColumnKey()).equals((Object)location)) {
                Minecrft.get().getSoundManager().stop((SoundInstance)cell.getValue());
                return true;
            }
            return false;
        });
    }

    private static SoundInstance createEntityBoundInstance(Entity entity, SoundEvent soundEvent, SoundSource source, float volume, float pitch) {
        return new EntityBoundSoundInstance(soundEvent, source, volume, pitch, entity, entity.getRandom().nextLong());
    }
}

