/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;

public class ItemFramePhotographRenderer {
    public static void render(ItemFrame itemFrame, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, PhotographItem item, ItemStack stack) {
        if (itemFrame.getType() == EntityType.GLOW_ITEM_FRAME) {
            packedLight = 0xF000F0;
        }
        poseStack.pushPose();
        String entityName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)itemFrame.getType()).toString();
        if (entityName.equals("quark:glass_frame")) {
            poseStack.translate(0.0f, 0.0f, 0.475f);
        }
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)(45 * itemFrame.getRotation())));
        float pixelSize = 0.0625f;
        float scale = 1.0f - pixelSize * 6.0f;
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.scale(scale, scale, scale);
        poseStack.translate(-0.5, -0.5, 0.045);
        ExposureClient.photographRenderer().renderPhotograph(poseStack, bufferSource, item, stack, false, false, packedLight, 255, 255, 255, 255);
        poseStack.popPose();
    }
}

