/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier.pixel;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.image.modifier.pixel.PixelEffect;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class ContrastEffect
implements PixelEffect {
    protected final float contrast;

    public ContrastEffect(float contrast) {
        Preconditions.checkArgument((contrast >= -1.0f && contrast <= 1.0f ? 1 : 0) != 0, (Object)"contrast must be in -1 to 1 range.");
        this.contrast = contrast;
    }

    @Override
    public String getIdentifier() {
        return "contrast-" + this.contrast;
    }

    @Override
    public int modify(int colorARGB) {
        if (this.contrast == 0.0f) {
            return colorARGB;
        }
        int alpha = FastColor.ARGB32.alpha((int)colorARGB);
        int red = FastColor.ARGB32.red((int)colorARGB);
        int green = FastColor.ARGB32.green((int)colorARGB);
        int blue = FastColor.ARGB32.blue((int)colorARGB);
        int contrastValue = Math.round(127.0f * (1.0f + this.contrast));
        red = Mth.clamp((int)((red - 127) * contrastValue / 127 + 127), (int)0, (int)255);
        green = Mth.clamp((int)((green - 127) * contrastValue / 127 + 127), (int)0, (int)255);
        blue = Mth.clamp((int)((blue - 127) * contrastValue / 127 + 127), (int)0, (int)255);
        return FastColor.ARGB32.color((int)alpha, (int)red, (int)green, (int)blue);
    }

    public String toString() {
        return "Contrast{contrast=" + this.contrast + "}";
    }
}

